/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.aspects;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class AnalysisPidAspect
extends LinuxPidAspect {
    private static final AnalysisPidAspect INSTANCE = new AnalysisPidAspect();

    private AnalysisPidAspect() {
    }

    public static AnalysisPidAspect getInstance() {
        return INSTANCE;
    }

    public @Nullable Integer resolve(@NonNull ITmfEvent event) {
        String hostId = event.getTrace().getHostId();
        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpuObj == null) {
            return null;
        }
        IHostModel model = ModelManager.getModelFor(hostId);
        long ts = event.getTimestamp().toNanos();
        int tid = model.getThreadOnCpu((Integer)cpuObj, ts, true);
        if (tid == -1) {
            return null;
        }
        int processId = model.getProcessId(tid, ts);
        if (processId == -1) {
            return null;
        }
        return processId;
    }
}

