/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class ImportCompletionProposal
extends AbstractJavaCompletionProposal {
    private final IJavaScriptUnit fCompilationUnit;
    private final int fParentProposalKind;
    private ImportRewrite fImportRewrite;
    private ContextSensitiveImportRewriteContext fImportContext;
    private final CompletionProposal fProposal;
    private boolean fReplacementStringComputed;

    public ImportCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context, int parentProposalKind) {
        super(context);
        this.fProposal = proposal;
        this.fParentProposalKind = parentProposalKind;
        this.fCompilationUnit = context.getCompilationUnit();
    }

    @Override
    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    private String computeReplacementString() {
        int proposalKind = this.fProposal.getKind();
        String qualifiedTypeName = null;
        char[] qualifiedType = null;
        if (proposalKind == 23) {
            qualifiedType = this.fProposal.getSignature();
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else if (proposalKind == 22 || proposalKind == 21) {
            qualifiedType = this.fProposal.getDeclarationSignature();
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fImportRewrite = this.createImportRewrite();
        if (this.fImportRewrite != null) {
            if (proposalKind == 23) {
                String simpleType = this.fImportRewrite.addImport(qualifiedTypeName, qualifiedTypeName, (ImportRewrite.ImportRewriteContext)this.fImportContext);
                if (this.fParentProposalKind == 6) {
                    return String.valueOf(simpleType) + ".";
                }
            } else {
                this.fImportRewrite.addStaticImport(qualifiedTypeName, String.valueOf(this.fProposal.getName()), proposalKind == 21, (ImportRewrite.ImportRewriteContext)this.fImportContext);
            }
            return "";
        }
        if (this.fCompilationUnit != null && JavaModelUtil.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.fCompilationUnit)) {
            if (this.fProposal.getKind() == 23 && this.fParentProposalKind == 2) {
                return "";
            }
            qualifiedTypeName = String.valueOf(Signature.getSignatureSimpleName((char[])qualifiedType));
        }
        return String.valueOf(qualifiedTypeName) + ".";
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            super.apply(document, trigger, offset);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int oldLen = document.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private ImportRewrite createImportRewrite() {
        if (this.fCompilationUnit != null && this.shouldAddImports()) {
            try {
                JavaScriptUnit cu = this.getASTRoot(this.fCompilationUnit);
                if (cu == null) {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    this.fImportContext = null;
                    return rewrite;
                }
                ImportRewrite rewrite = StubUtility.createImportRewrite(cu, true);
                this.fImportContext = new ContextSensitiveImportRewriteContext(cu, this.fInvocationContext.getInvocationOffset(), rewrite);
                return rewrite;
            }
            catch (CoreException x) {
                JavaScriptPlugin.log(x);
            }
        }
        return null;
    }

    private JavaScriptUnit getASTRoot(IJavaScriptUnit compilationUnit) {
        return JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)compilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean shouldAddImports() {
        if (this.isInJavadoc() && !this.isJavadocProcessingEnabled()) {
            return false;
        }
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaScriptProject project = this.fCompilationUnit.getJavaScriptProject();
        boolean processJavadoc = project == null ? "enabled".equals(JavaScriptCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.doc.comment.support")) : "enabled".equals(project.getOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", true));
        return processJavadoc;
    }
}

