/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.GraphTreeNode;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.HTNode;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdgeInterval;

public class HtIo {
    private static final Logger LOGGER = TraceCompassLog.getLogger(HtIo.class);
    private static final int CACHE_SIZE = 230;
    private static final LoadingCache<CacheKey, GraphTreeNode> NODE_CACHE = (LoadingCache)NonNullUtils.checkNotNull((Object)CacheBuilder.newBuilder().maximumSize(230L).build((CacheLoader)new CacheLoader<CacheKey, GraphTreeNode>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GraphTreeNode load(CacheKey key) throws IOException {
            HtIo io = key.fHistoryTreeIo;
            int seqNb = key.fSeqNumber;
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINEST, (String)"HtIo:CacheMiss", (Object[])new Object[]{"seqNum", seqNb});
            HtIo htIo = io;
            synchronized (htIo) {
                io.seekFCToNodePos(io.fFileChannelIn, seqNb);
                return (GraphTreeNode)HTNode.readNode(io.fBlockSize, io.fNodeMaxChildren, io.fFileChannelIn, (IHTIntervalReader<TmfEdgeInterval>)io.fEdgeIntervalReader, io.fNodeFactory);
            }
        }
    }));
    private final File fStateHistoryFile;
    private final int fBlockSize;
    private final int fNodeMaxChildren;
    private final HTNode.IHTNodeFactory<GraphTreeNode> fNodeFactory;
    private final IHTIntervalReader<TmfEdgeInterval> fEdgeIntervalReader;
    private final FileInputStream fFileInputStream;
    private final FileOutputStream fFileOutputStream;
    private final FileChannel fFileChannelIn;
    private final FileChannel fFileChannelOut;

    @VisibleForTesting
    static void clearCache() {
        NODE_CACHE.invalidateAll();
    }

    @VisibleForTesting
    static boolean isInCache(HtIo htio, int seqNum) {
        @Nullable HTNode present = (HTNode)NODE_CACHE.getIfPresent((Object)new CacheKey(htio, seqNum));
        return present != null;
    }

    public HtIo(File stateHistoryFile, int blockSize, int nodeMaxChildren, boolean newFile, HTNode.IHTNodeFactory<GraphTreeNode> nodeFactory, IHTIntervalReader<TmfEdgeInterval> edgeIntervalReader) throws IOException {
        this.fBlockSize = blockSize;
        this.fNodeMaxChildren = nodeMaxChildren;
        this.fNodeFactory = nodeFactory;
        this.fEdgeIntervalReader = edgeIntervalReader;
        this.fStateHistoryFile = stateHistoryFile;
        if (newFile) {
            boolean success1 = true;
            if (this.fStateHistoryFile.exists()) {
                success1 = this.fStateHistoryFile.delete();
            }
            boolean success2 = this.fStateHistoryFile.createNewFile();
            if (!success1 || !success2) {
                throw new IOException("Cannot create new file at " + this.fStateHistoryFile.getName());
            }
            this.fFileInputStream = new FileInputStream(this.fStateHistoryFile);
            this.fFileOutputStream = new FileOutputStream(this.fStateHistoryFile, false);
        } else {
            this.fFileInputStream = new FileInputStream(this.fStateHistoryFile);
            this.fFileOutputStream = new FileOutputStream(this.fStateHistoryFile, true);
        }
        this.fFileChannelIn = this.fFileInputStream.getChannel();
        this.fFileChannelOut = this.fFileOutputStream.getChannel();
    }

    public GraphTreeNode readNode(int seqNumber) throws ClosedChannelException {
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINEST, (String)"HtIo:CacheLookup", (Object[])new Object[]{"seqNum", seqNumber});
        CacheKey key = new CacheKey(this, seqNumber);
        try {
            return (GraphTreeNode)NonNullUtils.checkNotNull((Object)((GraphTreeNode)NODE_CACHE.get((Object)key)));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClosedChannelException) {
                throw (ClosedChannelException)cause;
            }
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNode(GraphTreeNode node) {
        try {
            int seqNumber = node.getSequenceNumber();
            CacheKey key = new CacheKey(this, seqNumber);
            NODE_CACHE.put((Object)key, (Object)node);
            HtIo htIo = this;
            synchronized (htIo) {
                this.seekFCToNodePos(this.fFileChannelOut, seqNumber);
                node.writeSelf(this.fFileChannelOut);
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    public FileOutputStream getFileWriter(int nodeOffset) {
        try {
            if (nodeOffset < 0) {
                this.fFileChannelOut.position(0L);
            } else {
                this.seekFCToNodePos(this.fFileChannelOut, nodeOffset);
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return this.fFileOutputStream;
    }

    public FileInputStream supplyATReader(int nodeOffset) {
        try {
            this.seekFCToNodePos(this.fFileChannelIn, nodeOffset);
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return this.fFileInputStream;
    }

    public synchronized void closeFile() {
        try {
            this.fFileInputStream.close();
            this.fFileOutputStream.close();
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void deleteFile() {
        this.closeFile();
        if (!this.fStateHistoryFile.delete()) {
            Activator.getInstance().logError("Failed to delete" + this.fStateHistoryFile.getName());
        }
    }

    private void seekFCToNodePos(FileChannel fc, int seqNumber) throws IOException {
        fc.position(4096L + (long)seqNumber * (long)this.fBlockSize);
    }

    private static final class CacheKey {
        public final HtIo fHistoryTreeIo;
        public final int fSeqNumber;

        public CacheKey(HtIo htio, int seqNumber) {
            this.fHistoryTreeIo = htio;
            this.fSeqNumber = seqNumber;
        }

        public int hashCode() {
            return Objects.hash(this.fHistoryTreeIo, this.fSeqNumber);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.fHistoryTreeIo.equals(other.fHistoryTreeIo) && this.fSeqNumber == other.fSeqNumber;
        }
    }
}

