/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.connections;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.AbstractRosStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.connections.RosConnectionsAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosConnectionsStateProvider
extends AbstractRosStateProvider {
    private static int VERSION_NUMBER = 0;
    public static @NonNull String CONNECTION_HOST_SEPARATOR = "/";

    public RosConnectionsStateProvider(ITmfTrace trace) {
        super(trace, RosConnectionsAnalysis.getFullAnalysisId());
    }

    @Override
    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        super.eventHandle(event);
        if (!RosConnectionsStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        if (RosConnectionsStateProvider.isEvent(event, this.fLayout.eventNewConnection())) {
            long timestamp = event.getTimestamp().toNanos();
            String nodeName = this.getNodeName(event);
            String channelType = (String)RosConnectionsStateProvider.getField(event, this.fLayout.fieldChannelType());
            String name = (String)RosConnectionsStateProvider.getField(event, this.fLayout.fieldName());
            String localHostPort = (String)RosConnectionsStateProvider.getField(event, this.fLayout.fieldLocalHostport());
            String remoteHostPort = (String)RosConnectionsStateProvider.getField(event, this.fLayout.fieldRemoteHostport());
            String localRemoteHosts = RosConnectionsStateProvider.getLocalAndRemoteCombo(localHostPort, remoteHostPort);
            int typeQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName, channelType});
            Object typeCounterObject = ss.queryOngoing(typeQuark);
            int typeCounter = typeCounterObject != null ? (Integer)typeCounterObject + 1 : 1;
            ss.modifyAttribute(timestamp, (Object)typeCounter, typeQuark);
            int connectionQuark = ss.getQuarkRelativeAndAdd(typeQuark, new String[]{name});
            ss.pushAttribute(timestamp, (Object)localRemoteHosts, connectionQuark);
            return;
        }
    }

    private static String getLocalAndRemoteCombo(String local, String remote) {
        return String.valueOf(local) + CONNECTION_HOST_SEPARATOR + remote;
    }
}

