/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript;

import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.ui.completion.BasicContext;
import org.eclipse.ease.ui.completion.tokenizer.IVariablesResolver;
import org.eclipse.ease.ui.completion.tokenizer.InputTokenizer;

public class JavaScriptCompletionContext
extends BasicContext {
    public JavaScriptCompletionContext(IScriptEngine scriptEngine, String contents, int position) {
        super(scriptEngine, contents, position);
    }

    public JavaScriptCompletionContext(Object resource, String contents, int position) {
        super(JavaScriptHelper.getScriptType(), resource, contents, position);
    }

    protected InputTokenizer getInputTokenizer() {
        if (this.getScriptEngine() != null) {
            return new JavaScriptInputTokenizer(v -> {
                Object variable = this.getScriptEngine().getVariable(v);
                return variable == null ? null : variable.getClass();
            });
        }
        return new JavaScriptInputTokenizer();
    }

    private final class JavaScriptInputTokenizer
    extends InputTokenizer {
        private static final String PACKAGES_PREFIX = "Packages.";

        private JavaScriptInputTokenizer() {
        }

        private JavaScriptInputTokenizer(IVariablesResolver variablesResolver) {
            super(variablesResolver);
        }

        protected Class<?> getClass(String input) {
            if (input.startsWith(PACKAGES_PREFIX)) {
                return this.filterRhinoClasses(super.getClass(input.substring(PACKAGES_PREFIX.length())));
            }
            return this.filterRhinoClasses(super.getClass(input));
        }

        private Class<?> filterRhinoClasses(Class<?> clazz) {
            if (clazz != null && clazz.getName().startsWith("org.mozilla.javascript")) {
                return null;
            }
            return clazz;
        }

        protected Package getPackage(String input) {
            if (input.startsWith(PACKAGES_PREFIX)) {
                return super.getPackage(input.substring(PACKAGES_PREFIX.length()));
            }
            return super.getPackage(input);
        }

        protected boolean isLiteral(char candidate) {
            return '\"' == candidate || '\'' == candidate;
        }
    }
}

