/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.AxisUtils;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.Section;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionAxis;
import org.eclipse.trace4cps.common.jfreechart.chart.geom.Arrow2D;
import org.eclipse.trace4cps.common.jfreechart.chart.plot.PlotUtils;
import org.eclipse.trace4cps.common.jfreechart.chart.renderer.xy.XYEdgeRenderer;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeDataItem;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeSeries;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeSeriesCollection;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYScaledSeries;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYScaledSeriesCollection;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IFilteredTrace;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.ITSPoints;
import org.eclipse.trace4cps.core.ITSSeries;
import org.eclipse.trace4cps.core.ITimeSeries;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.core.impl.ModifiableTrace;
import org.eclipse.trace4cps.core.impl.TimeValuePair;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.vis.jfree.ColorManager;
import org.eclipse.trace4cps.vis.jfree.DataItemFactory;
import org.eclipse.trace4cps.vis.jfree.DefaultDataItemFactory;
import org.eclipse.trace4cps.vis.jfree.DefaultToolTipGenerator;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;
import org.eclipse.trace4cps.vis.jfree.impl.Cell;
import org.eclipse.trace4cps.vis.jfree.impl.ClaimFragment;
import org.eclipse.trace4cps.vis.jfree.impl.ClaimPartition;
import org.eclipse.trace4cps.vis.jfree.impl.Partition;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.jfree.data.RangeAlign;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalDataItem;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class TracePlotManager
implements XYToolTipGenerator,
XYItemLabelGenerator {
    private static final int CLAIMS_INDEX = 3;
    private static final int SIGNALS_INDEX = 1;
    private static final int TIMESERIES_STEP_INDEX = 4;
    private static final int TIMESERIES_LINEAR_INDEX = 5;
    private static final int TIMESERIES_SPLINE_INDEX = 6;
    private static final int EVENTS_INDEX = 2;
    private static final int DEPENDENCIES_INDEX = 0;
    private final List<ModifiableTrace> traces = new ArrayList<ModifiableTrace>();
    private TraceViewConfiguration viewConfig;
    private Map<Paint, Integer> highlightToClaimSeries;
    private ValueMarker startMarker;
    private ValueMarker endMarker;
    private DataItemFactory dataItemFactory = new DefaultDataItemFactory();
    private XYToolTipGenerator delegateToolTipGenerator = new DefaultToolTipGenerator(this::getViewConfig);

    public TracePlotManager(ITrace ... traces) {
        this(new TraceViewConfiguration(), traces);
    }

    public TracePlotManager(TraceViewConfiguration viewConfig, ITrace ... traces) {
        this.viewConfig = viewConfig;
        this.setTraces(traces);
    }

    public void setDataItemFactory(DataItemFactory dataItemFactory) {
        this.dataItemFactory = dataItemFactory;
    }

    public void setDelegateToolTipGenerator(XYToolTipGenerator delegateToolTipGenerator) {
        this.delegateToolTipGenerator = delegateToolTipGenerator;
    }

    public void setTraces(ITrace ... traces) {
        if (traces != null && traces.length > 0) {
            this.setTraces(Arrays.asList(traces));
        }
    }

    public void setTraces(List<ITrace> traces) {
        if (traces.isEmpty()) {
            throw new IllegalArgumentException();
        }
        TimeUnit tu = traces.get(0).getTimeUnit();
        long offset = traces.get(0).getTimeOffset().longValue();
        for (ITrace trace : traces) {
            if (tu != trace.getTimeUnit() || offset != trace.getTimeOffset().longValue()) {
                throw new IllegalArgumentException("traces must have the same time unit and offset");
            }
            this.traces.add(new ModifiableTrace(trace));
        }
    }

    public TraceViewConfiguration getViewConfig() {
        return this.viewConfig;
    }

    public void setViewConfiguration(TraceViewConfiguration viewConfig) {
        this.viewConfig = viewConfig;
    }

    public List<ModifiableTrace> getTraces() {
        return this.traces;
    }

    public String generateToolTip(XYDataset ds, int series, int item) {
        return this.delegateToolTipGenerator.generateToolTip(ds, series, item);
    }

    public String generateLabel(XYDataset ds, int series, int item) {
        return this.delegateToolTipGenerator.generateToolTip(ds, series, item);
    }

    public void initializePlot(XYPlot xyplot) {
        xyplot.setRangePannable(true);
        xyplot.setDomainPannable(true);
        this.initClaimDatasetAndRenderer(xyplot);
        this.initSignalDatasetAndRenderer(xyplot);
        this.initTimesSeriesDatasetAndRenderer(xyplot);
        this.initEventDatasetAndRenderer(xyplot);
        this.initDependencyDatasetAndRenderer(xyplot);
    }

    private void initDependencyDatasetAndRenderer(XYPlot xyplot) {
        XYEdgeSeriesCollection edgesDataset = new XYEdgeSeriesCollection();
        xyplot.setDataset(0, (XYDataset)edgesDataset);
        XYEdgeRenderer edgesRenderer = new XYEdgeRenderer();
        edgesRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)this);
        edgesRenderer.setDefaultEndShape(this.getArrowHeadShape(), false);
        edgesRenderer.setAutoPopulateSeriesPaint(false);
        xyplot.setRenderer(0, (XYItemRenderer)edgesRenderer);
    }

    private Shape getArrowHeadShape() {
        return new Arrow2D.Double(0.0, 0.0, 8.0, 8.0);
    }

    private void initEventDatasetAndRenderer(XYPlot xyplot) {
        XYEdgeSeriesCollection edgesDataset = new XYEdgeSeriesCollection();
        xyplot.setDataset(2, (XYDataset)edgesDataset);
        XYEdgeRenderer edgesRenderer = new XYEdgeRenderer();
        edgesRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)this);
        edgesRenderer.setDefaultEndShape(this.getArrowHeadShape(), false);
        edgesRenderer.setAutoPopulateSeriesPaint(false);
        edgesRenderer.setAutoPopulateSeriesStroke(false);
        edgesRenderer.setDefaultStroke((Stroke)new BasicStroke(2.0f), false);
        xyplot.setRenderer(2, (XYItemRenderer)edgesRenderer);
    }

    private void initSignalDatasetAndRenderer(XYPlot xyplot) {
        XYScaledSeriesCollection signalDataset = new XYScaledSeriesCollection();
        signalDataset.setIntervalWidth(0.0);
        xyplot.setDataset(1, (XYDataset)signalDataset);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, true);
        renderer.setAutoPopulateSeriesPaint(false);
        renderer.setAutoPopulateSeriesShape(false);
        renderer.setDefaultShape((Shape)new Rectangle2D.Double(-1.0, -1.0, 3.0, 3.0));
        renderer.setDefaultToolTipGenerator((XYToolTipGenerator)this);
        renderer.setDefaultEntityRadius(5);
        xyplot.setRenderer(1, (XYItemRenderer)renderer);
    }

    private void initTimesSeriesDatasetAndRenderer(XYPlot xyplot) {
        TimeSeriesSelect[] timeSeriesSelectArray = TimeSeriesSelect.values();
        int n = timeSeriesSelectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSeriesSelect sel = timeSeriesSelectArray[n2];
            XYScaledSeriesCollection timeSeriesDataset = new XYScaledSeriesCollection();
            timeSeriesDataset.setIntervalWidth(0.0);
            xyplot.setDataset(sel.getIndex(), (XYDataset)timeSeriesDataset);
            XYLineAndShapeRenderer renderer = sel.createRenderer();
            renderer.setAutoPopulateSeriesPaint(false);
            renderer.setAutoPopulateSeriesShape(false);
            renderer.setDefaultShape((Shape)new Rectangle2D.Double(-1.0, -1.0, 3.0, 3.0));
            renderer.setDefaultToolTipGenerator((XYToolTipGenerator)this);
            renderer.setDefaultEntityRadius(5);
            xyplot.setRenderer(sel.getIndex(), (XYItemRenderer)renderer);
            ++n2;
        }
    }

    private void initClaimDatasetAndRenderer(XYPlot xyplot) {
        XYIntervalSeriesCollection claimDataset = new XYIntervalSeriesCollection();
        xyplot.setDataset(3, (XYDataset)claimDataset);
        XYBarRenderer claimRenderer = new XYBarRenderer(){
            private static final long serialVersionUID = 6167536692792897425L;

            public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset dataset, PlotRenderingInfo info) {
                XYItemRendererState state = super.initialise(g2, dataArea, plot, dataset, info);
                state.setProcessVisibleItemsOnly(false);
                return state;
            }
        };
        xyplot.setRenderer(3, (XYItemRenderer)claimRenderer);
        claimRenderer.setUseYInterval(true);
        claimRenderer.setAutoPopulateSeriesPaint(false);
        claimRenderer.setDefaultOutlinePaint((Paint)ChartColor.BLACK);
        claimRenderer.setDefaultOutlineStroke((Stroke)new BasicStroke(1.0f));
        claimRenderer.setShadowVisible(false);
        claimRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)this);
        claimRenderer.setDefaultItemLabelGenerator((XYItemLabelGenerator)this);
        claimRenderer.setDefaultItemLabelsVisible(false);
        claimRenderer.setComputeItemLabelContrastColor(true);
    }

    private void initSeriesAndColors(XYPlot xyplot) {
        if (!this.viewConfig.hasHighlight()) {
            this.initSeriesPaint((XYIntervalSeriesCollection)xyplot.getDataset(3), xyplot.getRenderer(3));
        } else {
            this.initClaimHighlightPaints(xyplot);
        }
        xyplot.getRenderer(3).setDefaultItemLabelsVisible(this.viewConfig.getShowClaimLabels());
        this.initSeriesPaint((XYEdgeSeriesCollection)xyplot.getDataset(2), xyplot.getRenderer(2));
        this.initSeriesPaint((XYEdgeSeriesCollection)xyplot.getDataset(0), xyplot.getRenderer(0));
    }

    private void initSeriesPaint(XYIntervalSeriesCollection ds, XYItemRenderer r) {
        ColorManager[] colorManagerArray = ColorManager.values();
        int n = colorManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorManager color = colorManagerArray[n2];
            ds.addSeries(new XYIntervalSeries((Comparable)((Object)color), false, true));
            r.setSeriesPaint(color.ordinal(), (Paint)color.getColor());
            ++n2;
        }
    }

    private void initSeriesPaint(XYEdgeSeriesCollection ds, XYItemRenderer r) {
        ColorManager[] colorManagerArray = ColorManager.values();
        int n = colorManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorManager color = colorManagerArray[n2];
            ds.addSeries(new XYEdgeSeries((Comparable)((Object)color)));
            r.setSeriesPaint(color.ordinal(), (Paint)color.getColor());
            ++n2;
        }
    }

    private void initClaimHighlightPaints(XYPlot xyplot) {
        XYItemRenderer renderer = xyplot.getRenderer(3);
        XYIntervalSeriesCollection ds = (XYIntervalSeriesCollection)xyplot.getDataset(3);
        this.highlightToClaimSeries = new HashMap<Paint, Integer>();
        HashSet<Paint> paints = new HashSet<Paint>();
        paints.addAll(this.viewConfig.getHighlightMap().values());
        renderer.setSeriesPaint(0, (Paint)ColorManager.NON_HIGHLIGHT.getColor());
        this.highlightToClaimSeries.put(ColorManager.NON_HIGHLIGHT.getColor(), 0);
        ds.addSeries(new XYIntervalSeries((Comparable)((Object)"0"), false, true));
        int i = 1;
        for (Paint p : paints) {
            this.highlightToClaimSeries.put(p, i);
            ds.addSeries(new XYIntervalSeries((Comparable)((Object)("" + i)), false, true));
            renderer.setSeriesPaint(i, p);
            ++i;
        }
    }

    private int getSeriesIndex(IClaim a) {
        if (a instanceof ClaimFragment) {
            a = ((ClaimFragment)a).getWrapped();
        }
        if (!this.viewConfig.hasHighlight()) {
            return this.getSeriesIndex((IAttributeAware)a, TracePart.CLAIM);
        }
        Paint p = this.viewConfig.getHighlightMap().get(a);
        if (p == null) {
            p = ColorManager.NON_HIGHLIGHT.getColor();
        }
        return this.highlightToClaimSeries.get(p);
    }

    private int getSeriesIndex(IEvent a) {
        return this.getSeriesIndex((IAttributeAware)a, TracePart.EVENT);
    }

    private int getSeriesIndex(IDependency a) {
        return this.getSeriesIndex((IAttributeAware)a, TracePart.DEPENDENCY);
    }

    private int getSeriesIndex(IAttributeAware a, TracePart part) {
        return this.getColorManager(a, part).ordinal();
    }

    private Color getColor(IAttributeAware a, TracePart part) {
        return this.getColorManager(a, part).getColor();
    }

    private ColorManager getColorManager(IAttributeAware a, TracePart part) {
        ColorManager color = ColorManager.getColor(a);
        if (color != null) {
            return color;
        }
        Collection<String> colAtts = this.viewConfig.getColoringAttributes(part);
        String colorKey = TraceHelper.getValues((IAttributeAware)a, colAtts, (boolean)false);
        return ColorManager.getAutomaticColor(colorKey);
    }

    public void update(XYPlot xyplot) {
        this.applyFilters();
        boolean firstPlot = xyplot.getDomainAxis().getLabel() == null;
        Range oldRangeX = xyplot.getDomainAxis().getRange();
        SectionAxis rangeAxis = new SectionAxis();
        xyplot.setRangeAxis((ValueAxis)rangeAxis);
        NumberAxis domainAxis = new NumberAxis(null);
        domainAxis.setAutoRangeIncludesZero(false);
        domainAxis.setAutoRangeAlign(RangeAlign.LOWER);
        domainAxis.setRangeMinimumSize(1.0E-5);
        domainAxis.setLabel("Time (" + this.traces.get(0).getTimeUnit().toString().toLowerCase() + ")");
        xyplot.setDomainAxis((ValueAxis)domainAxis);
        XYIntervalSeriesCollection claimsDataset = (XYIntervalSeriesCollection)xyplot.getDataset(3);
        claimsDataset.removeAllSeries();
        XYScaledSeriesCollection signalDataset = (XYScaledSeriesCollection)xyplot.getDataset(1);
        signalDataset.removeAllSeries();
        XYEdgeSeriesCollection eventsDataset = (XYEdgeSeriesCollection)xyplot.getDataset(2);
        eventsDataset.removeAllSeries();
        XYEdgeSeriesCollection dependenciesDataset = (XYEdgeSeriesCollection)xyplot.getDataset(0);
        dependenciesDataset.removeAllSeries();
        HashMap<Integer, XYScaledSeriesCollection> timeSeriesDatasetMap = new HashMap<Integer, XYScaledSeriesCollection>();
        HashMap<Integer, XYLineAndShapeRenderer> timeSeriesRendererMap = new HashMap<Integer, XYLineAndShapeRenderer>();
        TimeSeriesSelect[] timeSeriesSelectArray = TimeSeriesSelect.values();
        int n = timeSeriesSelectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSeriesSelect sel = timeSeriesSelectArray[n2];
            XYScaledSeriesCollection timeSeriesDataset = (XYScaledSeriesCollection)xyplot.getDataset(sel.getIndex());
            timeSeriesDataset.removeAllSeries();
            timeSeriesDatasetMap.put(sel.getIndex(), timeSeriesDataset);
            XYLineAndShapeRenderer timeSeriesRenderer = (XYLineAndShapeRenderer)xyplot.getRenderer(sel.getIndex());
            timeSeriesRendererMap.put(sel.getIndex(), timeSeriesRenderer);
            ++n2;
        }
        this.initSeriesAndColors(xyplot);
        HashMap<IEvent, XYCoordinate> entityMap = new HashMap<IEvent, XYCoordinate>();
        Iterator<ModifiableTrace> it = this.traces.iterator();
        while (it.hasNext()) {
            ITrace trace = (ITrace)it.next();
            List<SectionData> data = this.getSectionsData(trace);
            for (SectionData d : data) {
                if (d instanceof SignalSectionData) {
                    XYLineAndShapeRenderer signalsRenderer = (XYLineAndShapeRenderer)xyplot.getRenderer(1);
                    ((SignalSectionData)d).add(rangeAxis, signalDataset, signalsRenderer);
                    continue;
                }
                if (d instanceof TimeSeriesSectionData) {
                    ((TimeSeriesSectionData)d).add(rangeAxis, timeSeriesDatasetMap, timeSeriesRendererMap);
                    continue;
                }
                if (d instanceof ClaimSectionData) {
                    ((ClaimSectionData)d).add(rangeAxis, claimsDataset, entityMap);
                    continue;
                }
                if (!(d instanceof EventSectionData)) continue;
                ((EventSectionData)d).add(rangeAxis, eventsDataset, entityMap);
            }
            if (this.viewConfig.showDependencies()) {
                this.addDependencies(trace.getDependencies(), entityMap, dependenciesDataset);
            }
            if (!it.hasNext()) continue;
            rangeAxis.nextSection("");
        }
        this.addStartEndMarkers(xyplot);
        ChartFactory.getChartTheme().apply(xyplot.getChart());
        int itemCount = PlotUtils.getItemCount((XYPlot)xyplot);
        if (itemCount > 50000) {
            Range range = xyplot.getDataRange((ValueAxis)domainAxis);
            domainAxis.setAutoRangeAlign(RangeAlign.LOWER);
            domainAxis.setFixedAutoRange(50000.0 / (double)itemCount * range.getLength());
        } else {
            domainAxis.setFixedAutoRange(0.0);
        }
        if (rangeAxis.getSections().size() > 30) {
            rangeAxis.setAutoRangeAlign(RangeAlign.LOWER);
            rangeAxis.setFixedAutoRange(30.0);
        } else {
            rangeAxis.setAutoRange(true);
        }
        if (!firstPlot) {
            domainAxis.setRange(oldRangeX);
        } else if (this.viewConfig.getRange() != null) {
            domainAxis.setRange(this.viewConfig.getRange());
        }
        AxisUtils.calculateAndApplyFixedDimension((SectionAxis)rangeAxis, (RectangleEdge)xyplot.getRangeAxisEdge());
    }

    private void applyFilters() {
        for (IFilteredTrace iFilteredTrace : this.traces) {
            iFilteredTrace.clearFilter(TracePart.ALL);
            for (IAttributeFilter iAttributeFilter : this.viewConfig.getFilters(TracePart.RESOURCE)) {
                iFilteredTrace.addFilter(TracePart.RESOURCE, iAttributeFilter);
            }
            for (IAttributeFilter iAttributeFilter : this.viewConfig.getFilters(TracePart.CLAIM)) {
                iFilteredTrace.addFilter(TracePart.CLAIM, iAttributeFilter);
            }
            for (IAttributeFilter iAttributeFilter : this.viewConfig.getFilters(TracePart.DEPENDENCY)) {
                iFilteredTrace.addFilter(TracePart.DEPENDENCY, iAttributeFilter);
            }
            for (IAttributeFilter iAttributeFilter : this.viewConfig.getFilters(TracePart.EVENT)) {
                iFilteredTrace.addFilter(TracePart.EVENT, iAttributeFilter);
            }
            for (IAttributeFilter iAttributeFilter : this.viewConfig.getFilters(TracePart.SIGNAL)) {
                iFilteredTrace.addFilter(TracePart.SIGNAL, iAttributeFilter);
            }
            for (IAttributeFilter iAttributeFilter : this.viewConfig.getFilters(TracePart.TIMESERIES)) {
                iFilteredTrace.addFilter(TracePart.TIMESERIES, iAttributeFilter);
            }
            iFilteredTrace.recalculate();
        }
    }

    private void addDependencies(List<IDependency> deps, Map<IEvent, XYCoordinate> entityMap, XYEdgeSeriesCollection dependenciesDataset) {
        for (IDependency dep : deps) {
            int key = this.getSeriesIndex(dep);
            XYEdgeSeries series = dependenciesDataset.getSeries(key);
            XYCoordinate src = entityMap.get(dep.getSrc());
            XYCoordinate dst = entityMap.get(dep.getDst());
            if (src != null && dst != null) {
                series.add(this.dataItemFactory.createDependencyDataItem(dep, src.x, src.y, dst.x, dst.y), false);
                continue;
            }
            throw new IllegalStateException("Cannot find src or dst of " + String.valueOf(dep));
        }
    }

    private List<SectionData> getSectionsData(ITrace trace) {
        ArrayList<SectionData> data = new ArrayList<SectionData>();
        if (this.viewConfig.showEvents()) {
            this.createEventsSectionData(trace, data);
        }
        if (this.viewConfig.showClaims()) {
            this.createClaimSectionData(trace, data);
        }
        if (this.viewConfig.showSignals()) {
            this.createSignalSectionData(trace, data);
        }
        if (this.viewConfig.showTimeSeries()) {
            this.createTimeSeriesSectionData(trace, data);
        }
        if (this.viewConfig.sortAlphabetic()) {
            Collections.sort(data, Collections.reverseOrder());
        } else {
            Collections.reverse(data);
        }
        return data;
    }

    private void createSignalSectionData(ITrace trace, List<SectionData> data) {
        for (IPsop p : trace.getSignals()) {
            Color c = ColorManager.getColor((IAttributeAware)p, ColorManager.DARK_BLUE).getColor();
            data.add(new SignalSectionData(trace, p, c));
        }
    }

    private void createTimeSeriesSectionData(ITrace trace, List<SectionData> data) {
        for (ITimeSeries ts : trace.getTimeSeries()) {
            data.add(new TimeSeriesSectionData(trace, ts));
        }
    }

    private void createClaimSectionData(ITrace trace, List<SectionData> data) {
        ClaimPartition groupingPartition = null;
        groupingPartition = this.viewConfig.isActivityView() ? ClaimPartition.createActivityPartition(trace.getClaims(), this.viewConfig.getGroupingAttributes(TracePart.CLAIM)) : ClaimPartition.createResourcePartition(trace.getClaims(), this.viewConfig.getDescribingAttributes(TracePart.RESOURCE));
        groupingPartition.scaleClaims(this.viewConfig.getClaimScaling());
        for (Cell<IClaim> cell : groupingPartition) {
            data.add(new ClaimSectionData(trace, cell));
        }
    }

    private void createEventsSectionData(ITrace trace, List<SectionData> data) {
        List events = TraceHelper.getEvents((ITrace)trace, (boolean)this.viewConfig.showClaimEvents());
        if (!events.isEmpty()) {
            Partition groupingPartition = Partition.createAttributePartition(events, this.viewConfig.getGroupingAttributes(TracePart.EVENT));
            for (Cell<IEvent> cell : groupingPartition) {
                data.add(new EventSectionData(trace, cell));
            }
        }
    }

    private void addStartEndMarkers(XYPlot xyplot) {
        double lb = Double.POSITIVE_INFINITY;
        double ub = Double.NEGATIVE_INFINITY;
        for (ITrace iTrace : this.traces) {
            IInterval dom = TraceHelper.getDomain((ITrace)iTrace);
            lb = Math.min(lb, dom.lb().doubleValue());
            ub = Math.max(ub, dom.ub().doubleValue());
        }
        if (this.startMarker == null) {
            String string = "Start of trace" + (this.traces.size() > 1 ? "s" : "");
            this.startMarker = new ValueMarker(lb, (Paint)Color.DARK_GRAY, xyplot.getDomainGridlineStroke());
            this.startMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            this.startMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            this.startMarker.setLabelPaint((Paint)Color.DARK_GRAY);
            xyplot.addDomainMarker((Marker)this.startMarker);
            this.startMarker.setLabel(string);
            String endLabel = "End of trace" + (this.traces.size() > 1 ? "s" : "");
            this.endMarker = new ValueMarker(ub, (Paint)Color.DARK_GRAY, xyplot.getDomainGridlineStroke());
            this.endMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            this.endMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
            this.endMarker.setLabelPaint((Paint)Color.DARK_GRAY);
            xyplot.addDomainMarker((Marker)this.endMarker);
            this.endMarker.setLabel(endLabel);
        } else {
            this.startMarker.setValue(lb);
            this.endMarker.setValue(ub);
        }
    }

    private class ClaimSectionData
    extends SectionData {
        private final Cell<IClaim> cell;

        public ClaimSectionData(ITrace trace, Cell<IClaim> cell) {
            this(trace, cell.getDescription(), cell);
        }

        public ClaimSectionData(ITrace trace, String description, Cell<IClaim> cell) {
            super(TraceHelper.getValues((IAttributeAware)trace, (boolean)false), description);
            this.cell = cell;
        }

        public void add(SectionAxis rangeAxis, XYIntervalSeriesCollection ds, Map<IEvent, XYCoordinate> entityMap) {
            Section s = rangeAxis.nextSection(this.getSectionLabel(), 1.0, 0.1);
            for (IClaim claim : this.cell) {
                int key = TracePlotManager.this.getSeriesIndex(claim);
                XYIntervalSeries series = ds.getSeries(key);
                XYIntervalDataItem entity = this.createFrom(claim, s);
                this.administrateEvents(claim, entityMap, entity);
                series.add(entity, false);
            }
        }

        private void administrateEvents(IClaim claim, Map<IEvent, XYCoordinate> entityMap, XYIntervalDataItem entity) {
            double y = entity.getYLowValue() + Math.abs((entity.getYLowValue() - entity.getYHighValue()) / 2.0);
            if (Math.abs(claim.getStartTime().doubleValue() - entity.getXLowValue()) < 1.0E-12) {
                entityMap.put((IEvent)claim.getStartEvent(), new XYCoordinate(entity.getXLowValue(), y));
            }
            if (Math.abs(claim.getEndTime().doubleValue() - entity.getXHighValue()) < 1.0E-12) {
                entityMap.put((IEvent)claim.getEndEvent(), new XYCoordinate(entity.getXHighValue(), y));
            }
        }

        private XYIntervalDataItem createFrom(IClaim claim, Section s) {
            if (claim instanceof ClaimFragment) {
                ClaimFragment frag = (ClaimFragment)claim;
                double xmin = frag.getStartTime().doubleValue();
                double xmax = frag.getEndTime().doubleValue();
                double ymin = s.getRange().getLowerBound() + 0.1 + frag.getSwimLaneOffset();
                double ymax = s.getRange().getLowerBound() + 0.1 + frag.getSwimLaneOffset() + frag.getSwimLaneFraction();
                return TracePlotManager.this.dataItemFactory.createClaimDataItem(claim, xmin, xmax, ymin, ymax);
            }
            double xmin = claim.getStartTime().doubleValue();
            double xmax = claim.getEndTime().doubleValue();
            double ymin = s.getRange().getLowerBound() + 0.1;
            double ymax = s.getRange().getUpperBound() - 0.1;
            return TracePlotManager.this.dataItemFactory.createClaimDataItem(claim, xmin, xmax, ymin, ymax);
        }
    }

    private class EventSectionData
    extends SectionData {
        private final Cell<IEvent> cell;

        public EventSectionData(ITrace trace, Cell<IEvent> cell) {
            super(TraceHelper.getValues((IAttributeAware)trace, (boolean)false), cell.getDescription());
            this.cell = cell;
        }

        public void add(SectionAxis rangeAxis, XYEdgeSeriesCollection ds, Map<IEvent, XYCoordinate> entityMap) {
            Section s = rangeAxis.nextSection(this.getSectionLabel(), 1.0, 0.1);
            for (IEvent event : this.cell) {
                int key = TracePlotManager.this.getSeriesIndex(event);
                XYEdgeSeries series = ds.getSeries(key);
                series.add(this.createFrom(event, s, entityMap), false);
            }
        }

        private XYEdgeDataItem createFrom(IEvent event, Section s, Map<IEvent, XYCoordinate> entityMap) {
            double x = event.getTimestamp().doubleValue();
            double ymin = s.getRange().getLowerBound() + 0.1;
            double ymax = s.getRange().getUpperBound() - 0.1;
            if (event instanceof IClaimEvent) {
                double length = (s.getRange().getUpperBound() - s.getRange().getLowerBound()) / 2.0;
                if (((IClaimEvent)event).getType() == ClaimEventType.START) {
                    ymax = s.getRange().getLowerBound() + length;
                } else {
                    ymin = s.getRange().getLowerBound() + length;
                    ymax = s.getRange().getLowerBound() + 0.1;
                }
            }
            XYCoordinate coord = new XYCoordinate(x, Math.min(ymin, ymax) + Math.abs(ymax - ymin) / 2.0);
            entityMap.put(event, coord);
            return TracePlotManager.this.dataItemFactory.createEventDataItem(event, x, ymin, ymax);
        }
    }

    private abstract class SectionData
    implements Comparable<SectionData> {
        protected String traceLabel;
        protected String label;

        public SectionData(String traceLabel, String label) {
            this.traceLabel = traceLabel;
            this.label = label;
        }

        public String getSectionLabel() {
            if (TracePlotManager.this.traces.size() > 1) {
                return this.traceLabel + " : " + this.label;
            }
            return this.label;
        }

        @Override
        public int compareTo(SectionData o) {
            if (this.traceLabel != null) {
                int val = this.traceLabel.compareToIgnoreCase(o.traceLabel);
                if (val == 0) {
                    val = this.label.compareToIgnoreCase(o.label);
                }
                return val;
            }
            return this.label.compareToIgnoreCase(o.label);
        }

        protected Range fixRange(Range dataRange) {
            if (dataRange == null || dataRange.getLength() <= 0.0) {
                return new Range(dataRange.getLowerBound() - 1.0, dataRange.getUpperBound() + 1.0);
            }
            return dataRange;
        }
    }

    private class SignalSectionData
    extends SectionData {
        private final Paint color;
        private final IPsop signal;

        public SignalSectionData(ITrace trace, IPsop signal, Paint color) {
            super(TraceHelper.getValues((IAttributeAware)trace, (boolean)false), TraceHelper.getValues((IAttributeAware)signal, TracePlotManager.this.viewConfig.getDescribingAttributes(TracePart.SIGNAL), (boolean)false));
            this.signal = signal;
            this.color = color;
        }

        public void add(SectionAxis rangeAxis, XYScaledSeriesCollection ds, XYLineAndShapeRenderer renderer) {
            Section s = rangeAxis.nextSection(this.getSectionLabel(), 2.0, 0.1);
            String seriesKey = this.label + UUID.randomUUID().toString();
            XYScaledSeries series = new XYScaledSeries((Comparable)((Object)seriesKey), null, s.getRange(), false, true);
            int i = 0;
            while (i < this.signal.getFragments().size()) {
                IPsopFragment f = (IPsopFragment)this.signal.getFragments().get(i);
                double x = f.dom().lb().doubleValue();
                double y = f.getC().doubleValue();
                series.add(TracePlotManager.this.dataItemFactory.createSignalDataItem(this.signal, f, x, y));
                this.addAdditionalItemOnJumps(series, f, i);
                ++i;
            }
            s.setGridBandNumberRange(this.fixRange(series.getUnscaledRangeY()), false);
            ds.addSeries(series);
            renderer.setDefaultShapesVisible(TracePlotManager.this.getViewConfig().getShowSignalMarkers());
            renderer.setSeriesPaint(ds.getSeriesIndex((Comparable)((Object)seriesKey)), this.color);
        }

        private void addAdditionalItemOnJumps(XYScaledSeries series, IPsopFragment f, int i) {
            double delta;
            boolean lastFragment = i == this.signal.getFragments().size() - 1;
            IPsopFragment nextF = lastFragment ? null : (IPsopFragment)this.signal.getFragments().get(i + 1);
            double x2 = f.dom().ub().doubleValue();
            double y2 = PsopHelper.valueAt((IPsopFragment)f, (Number)x2).doubleValue();
            double d = delta = lastFragment ? 0.0 : Math.abs(y2 - nextF.getC().doubleValue());
            if (lastFragment || delta > 1.0E-9) {
                series.add(x2, y2);
            }
        }
    }

    private class TimeSeriesSectionData
    extends SectionData {
        private final ITimeSeries timeseries;

        public TimeSeriesSectionData(ITrace trace, ITimeSeries timeseries) {
            super(TraceHelper.getValues((IAttributeAware)trace, (boolean)false), TraceHelper.getValues((IAttributeAware)timeseries, TracePlotManager.this.viewConfig.getDescribingAttributes(TracePart.TIMESERIES), (boolean)false));
            this.timeseries = timeseries;
        }

        public void add(SectionAxis rangeAxis, Map<Integer, XYScaledSeriesCollection> timeSeriesDatasetMap, Map<Integer, XYLineAndShapeRenderer> timeSeriesRendererMap) {
            Section s = rangeAxis.nextSection(this.getSectionLabel(), 2.0, 0.1);
            Range yRange = null;
            for (ITSSeries tsSeries : this.timeseries.getAllSeries()) {
                int index;
                String seriesKey = this.label + UUID.randomUUID().toString();
                XYScaledSeries series = new XYScaledSeries((Comparable)((Object)seriesKey), null, s.getRange(), false, true);
                series.setDescription(tsSeries.getAttributeValue("name"));
                for (ITSPoints p : tsSeries.getData()) {
                    for (TimeValuePair pair : p.getData()) {
                        series.add(TracePlotManager.this.dataItemFactory.createTimeSeriesDataItem(tsSeries, pair.getTime(), pair.getValue()));
                    }
                }
                String chartType = tsSeries.getAttributeValue("type");
                try {
                    index = TimeSeriesSelect.valueOf(chartType.toUpperCase()).getIndex();
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    index = TimeSeriesSelect.LINEAR.getIndex();
                }
                XYScaledSeriesCollection ds = timeSeriesDatasetMap.get(index);
                XYLineAndShapeRenderer renderer = timeSeriesRendererMap.get(index);
                ds.addSeries(series);
                Color color = TracePlotManager.this.getColor((IAttributeAware)tsSeries, TracePart.TIMESERIES);
                renderer.setSeriesPaint(ds.getSeriesIndex((Comparable)((Object)seriesKey)), (Paint)color);
                renderer.setDefaultShapesVisible(TracePlotManager.this.getViewConfig().getShowSignalMarkers());
                yRange = yRange == null ? series.getUnscaledRangeY() : new Range(Math.min(series.getUnscaledRangeY().getLowerBound(), yRange.getLowerBound()), Math.max(series.getUnscaledRangeY().getUpperBound(), yRange.getUpperBound()));
            }
            s.setGridBandNumberRange(this.fixRange(yRange), false);
        }
    }

    static enum TimeSeriesSelect {
        STEP(4, XYStepRenderer.class),
        LINEAR(5, XYLineAndShapeRenderer.class),
        SPLINE(6, XYSplineRenderer.class);

        private final int index;
        private final Class<?> renderer;

        private TimeSeriesSelect(int index, Class<?> renderer) {
            this.index = index;
            this.renderer = renderer;
        }

        int getIndex() {
            return this.index;
        }

        XYLineAndShapeRenderer createRenderer() {
            try {
                return (XYLineAndShapeRenderer)this.renderer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class XYCoordinate {
        private final double x;
        private final double y;

        public XYCoordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

