/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.timing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.timing.NormalStatistics;

public class StatisticsManager {
    private TimeUnit timeUnit;
    private final List<Double> samples = new ArrayList<Double>();

    public StatisticsManager(TimeUnit tu) {
        this.timeUnit = tu;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void addSample(double v) {
        this.samples.add(v);
    }

    public int getNumSamples() {
        return this.samples.size();
    }

    public List<Double> getSamples() {
        return this.samples;
    }

    public NormalStatistics getNormalStatistics() {
        return new NormalStatistics(this);
    }

    public void autoScale() {
        block6: {
            double mean;
            block5: {
                if (this.getNumSamples() <= 0) {
                    return;
                }
                mean = this.getNormalStatistics().getMean();
                if (!(mean > 1000.0)) break block5;
                while (mean > 1000.0) {
                    if (this.scaleUp()) {
                        mean = this.getNormalStatistics().getMean();
                        continue;
                    }
                    return;
                }
                break block6;
            }
            if (!(mean < 1.0)) break block6;
            while (mean < 1.0) {
                if (this.scaleDown()) {
                    mean = this.getNormalStatistics().getMean();
                    continue;
                }
                return;
            }
        }
    }

    public void scaleTo(TimeUnit tu) {
        if (tu.compareTo(this.timeUnit) < 0) {
            this.scaleSamples(tu.convert(1L, this.timeUnit), true);
            this.timeUnit = tu;
        } else if (tu.compareTo(this.timeUnit) > 0) {
            this.scaleSamples(this.timeUnit.convert(1L, tu), false);
            this.timeUnit = tu;
        }
    }

    private boolean scaleUp() {
        switch (this.timeUnit) {
            case NANOSECONDS: {
                this.scaleSamples(1000L, false);
                this.timeUnit = TimeUnit.MICROSECONDS;
                return true;
            }
            case MICROSECONDS: {
                this.scaleSamples(1000L, false);
                this.timeUnit = TimeUnit.MILLISECONDS;
                return true;
            }
            case MILLISECONDS: {
                this.scaleSamples(1000L, false);
                this.timeUnit = TimeUnit.SECONDS;
                return true;
            }
            case SECONDS: {
                this.scaleSamples(60L, false);
                this.timeUnit = TimeUnit.MINUTES;
                return true;
            }
            case MINUTES: {
                this.scaleSamples(60L, false);
                this.timeUnit = TimeUnit.HOURS;
                return true;
            }
        }
        return false;
    }

    private boolean scaleDown() {
        switch (this.timeUnit) {
            case MICROSECONDS: {
                this.scaleSamples(1000L, true);
                this.timeUnit = TimeUnit.NANOSECONDS;
                return true;
            }
            case MILLISECONDS: {
                this.scaleSamples(1000L, true);
                this.timeUnit = TimeUnit.MICROSECONDS;
                return true;
            }
            case SECONDS: {
                this.scaleSamples(1000L, true);
                this.timeUnit = TimeUnit.MILLISECONDS;
                return true;
            }
            case MINUTES: {
                this.scaleSamples(60L, true);
                this.timeUnit = TimeUnit.SECONDS;
                return true;
            }
            case HOURS: {
                this.scaleSamples(60L, true);
                this.timeUnit = TimeUnit.MINUTES;
                return true;
            }
        }
        return false;
    }

    private void scaleSamples(long f, boolean mult) {
        ArrayList<Double> newSamples = new ArrayList<Double>();
        for (double d : this.samples) {
            if (!mult) {
                newSamples.add(BigDecimal.valueOf(d).divide(BigDecimal.valueOf(f), RoundingMode.HALF_DOWN).doubleValue());
                continue;
            }
            newSamples.add(BigDecimal.valueOf(d).multiply(BigDecimal.valueOf(f)).doubleValue());
        }
        this.samples.clear();
        this.samples.addAll(newSamples);
    }
}

