/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.ClaimEvent;
import org.eclipse.trace4cps.core.io.DependencyType;

public class TraceWriter {
    private final Map<IResource, Integer> resourceMap = new HashMap<IResource, Integer>();
    private final Map<IClaim, Integer> claimMap = new HashMap<IClaim, Integer>();
    private final Map<IEvent, Integer> eventMap = new HashMap<IEvent, Integer>();

    private TraceWriter() {
    }

    public static void writeTrace(ITrace trace, File f) throws IOException {
        new TraceWriter().writeTraceInt(trace, f);
    }

    private void writeTraceInt(ITrace trace, File f) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
            this.writeTUandOffset(trace, w);
            this.writeTraceAtts(trace, w);
            this.writeResources(trace, w);
            this.writeClaims(trace, w);
            this.writeEvents(trace, w);
            this.writeDependencies(trace, w);
            this.writeSignals(trace, w);
        }
    }

    private void writeTUandOffset(ITrace trace, BufferedWriter w) throws IOException {
        w.write("TU");
        w.write(32);
        w.write(trace.getTimeUnit().toString());
        w.write(10);
        w.write("O");
        w.write(32);
        w.write(Long.toString(trace.getTimeOffset().longValue()));
        w.write(10);
    }

    private void writeTraceAtts(ITrace trace, BufferedWriter w) throws IOException {
        w.write("T");
        w.write(32);
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.putAll(trace.getAttributes());
        atts.remove("name");
        this.writeAttributes(atts, w);
    }

    private void writeResources(ITrace trace, BufferedWriter w) throws IOException {
        int id = 0;
        for (IResource r : trace.getResources()) {
            this.resourceMap.put(r, id);
            w.write("R");
            w.write(32);
            w.write(Integer.toString(id));
            w.write(32);
            w.write(Double.toString(r.getCapacity().doubleValue()));
            w.write(32);
            w.write(Boolean.toString(r.useOffset()));
            w.write(59);
            this.writeAttributes(r.getAttributes(), w);
            ++id;
        }
    }

    private void writeClaims(ITrace trace, BufferedWriter w) throws IOException {
        int id = 0;
        for (IClaim c : trace.getClaims()) {
            this.claimMap.put(c, id);
            w.write("C");
            w.write(32);
            w.write(Integer.toString(id));
            w.write(32);
            w.write(Double.toString(c.getStartTime().doubleValue()));
            w.write(32);
            w.write(Double.toString(c.getEndTime().doubleValue()));
            w.write(32);
            Integer rid = this.resourceMap.get(c.getResource());
            if (rid == null) {
                throw new IOException("Claim " + c + " refers to an IResource that is not part of the IResources of the ITrace instance");
            }
            w.write(Integer.toString(rid));
            if (c.getResource().useOffset()) {
                w.write(32);
                w.write(Double.toString(c.getOffset().doubleValue()));
            }
            w.write(32);
            w.write(Double.toString(c.getAmount().doubleValue()));
            w.write(59);
            this.writeAttributes(c.getAttributes(), w);
            ++id;
        }
    }

    private void writeEvents(ITrace trace, BufferedWriter w) throws IOException {
        int id = 0;
        for (IEvent e : trace.getEvents()) {
            if (e instanceof ClaimEvent) continue;
            this.eventMap.put(e, id);
            w.write("E");
            w.write(32);
            w.write(Integer.toString(id));
            w.write(32);
            w.write(Double.toString(e.getTimestamp().doubleValue()));
            w.write(59);
            this.writeAttributes(e.getAttributes(), w);
            ++id;
        }
    }

    private void writeDependencies(ITrace trace, BufferedWriter w) throws IOException {
        int id = 0;
        for (IDependency d : trace.getDependencies()) {
            Integer[] typeAndIds = this.getTypeAndIds(d);
            if (typeAndIds[1] == null || typeAndIds[2] == null) {
                throw new IOException("Cannot resolve claim or event id in dependency " + d);
            }
            w.write("D");
            w.write(32);
            w.write(Integer.toString(id));
            w.write(32);
            w.write(Integer.toString(typeAndIds[0]));
            w.write(32);
            w.write(Integer.toString(typeAndIds[1]));
            w.write(32);
            w.write(Integer.toString(typeAndIds[2]));
            w.write(59);
            this.writeAttributes(d.getAttributes(), w);
            ++id;
        }
    }

    private Integer[] getTypeAndIds(IDependency dep) {
        Integer[] result = new Integer[3];
        IEvent src = dep.getSrc();
        IEvent dst = dep.getDst();
        boolean srcClaimEvent = src instanceof ClaimEvent;
        boolean dstClaimEvent = dst instanceof ClaimEvent;
        if (!srcClaimEvent && !dstClaimEvent) {
            result[0] = DependencyType.EVENT_EVENT.getValue();
            result[1] = this.eventMap.get(src);
            result[2] = this.eventMap.get(dst);
        } else if (!srcClaimEvent && dstClaimEvent) {
            ClaimEvent d = (ClaimEvent)dst;
            result[1] = this.eventMap.get(src);
            result[2] = this.claimMap.get(d.getClaim());
            result[0] = d.getType() == ClaimEventType.START ? Integer.valueOf(DependencyType.EVENT_CLAIM_START.getValue()) : Integer.valueOf(DependencyType.EVENT_CLAIM_END.getValue());
        } else if (srcClaimEvent && !dstClaimEvent) {
            ClaimEvent s = (ClaimEvent)src;
            result[1] = this.claimMap.get(s.getClaim());
            result[2] = this.eventMap.get(dst);
            result[0] = s.getType() == ClaimEventType.START ? Integer.valueOf(DependencyType.CLAIM_START_EVENT.getValue()) : Integer.valueOf(DependencyType.CLAIM_END_EVENT.getValue());
        } else {
            ClaimEvent s = (ClaimEvent)src;
            ClaimEvent d = (ClaimEvent)dst;
            result[1] = this.claimMap.get(s.getClaim());
            result[2] = this.claimMap.get(d.getClaim());
            result[0] = s.getType() == ClaimEventType.START && d.getType() == ClaimEventType.START ? Integer.valueOf(DependencyType.CLAIM_START_CLAIM_START.getValue()) : (s.getType() == ClaimEventType.START && d.getType() == ClaimEventType.END ? Integer.valueOf(DependencyType.CLAIM_START_CLAIM_END.getValue()) : (s.getType() == ClaimEventType.END && d.getType() == ClaimEventType.START ? Integer.valueOf(DependencyType.CLAIM_END_CLAIM_START.getValue()) : Integer.valueOf(DependencyType.CLAIM_END_CLAIM_END.getValue())));
        }
        return result;
    }

    private void writeSignals(ITrace trace, BufferedWriter w) throws IOException {
        int id = 0;
        for (IPsop p : trace.getSignals()) {
            w.write("S");
            w.write(32);
            w.write(Integer.toString(id));
            w.write(59);
            this.writeAttributes(p.getAttributes(), w);
            this.writeFragments(p, id, w);
            ++id;
        }
    }

    private void writeFragments(IPsop p, int signalId, BufferedWriter w) throws IOException {
        for (IPsopFragment f : p.getFragments()) {
            w.write("F");
            w.write(32);
            w.write(Integer.toString(signalId));
            w.write(32);
            w.write(Double.toString(f.dom().lb().doubleValue()));
            w.write(32);
            w.write(Double.toString(f.dom().ub().doubleValue()));
            w.write(32);
            w.write(Double.toString(f.getC().doubleValue()));
            w.write(32);
            w.write(Double.toString(f.getB().doubleValue()));
            w.write(32);
            w.write(Double.toString(f.getA().doubleValue()));
            w.write(10);
        }
    }

    private void writeAttributes(Map<String, String> attributes, BufferedWriter w) throws IOException {
        int cnt = 0;
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            ++cnt;
            String key = this.escape(e.getKey()).trim();
            String val = this.escape(e.getValue()).trim();
            w.write(key);
            if (key.endsWith("\\")) {
                w.write(32);
            }
            w.write(61);
            w.write(val);
            if (val.endsWith("\\") && cnt < attributes.size()) {
                w.write(32);
            }
            if (cnt >= attributes.size()) continue;
            w.write(44);
        }
        w.write(10);
    }

    private String escape(String str) {
        return str.replace(",", "\\,").replace("=", "\\=");
    }
}

