/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.cpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.trace4cps.analysis.constraintgraph.ConstraintConfig;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.Constraint;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ConstraintGraph;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ConstraintGraphNode;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.EventNode;
import org.eclipse.trace4cps.analysis.cpa.CpaResult;
import org.eclipse.trace4cps.analysis.cpa.PositiveCycleException;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.Dependency;

public final class CriticalPathAnalysis {
    public static final String CPA_ATT_TYPE = "type";
    public static final String CPA_ATT_TYPE_CG = "cg";
    public static final String CPA_ATT_CRITICAL = "critical";
    public static final String CPA_ATT_CRITICAL_TRUE = "true";
    public static final String CPA_ATT_CRITICAL_FALSE = "false";

    private CriticalPathAnalysis() {
    }

    public static IAttributeFilter getCriticalDependencyFilter() {
        return new IAttributeFilter(){

            @Override
            public boolean include(IAttributeAware a) {
                return CriticalPathAnalysis.CPA_ATT_CRITICAL_TRUE.equals(a.getAttributeValue(CriticalPathAnalysis.CPA_ATT_CRITICAL));
            }
        };
    }

    public static CpaResult run(ITrace trace) throws PositiveCycleException {
        ConstraintConfig config = ConstraintConfig.getDefault();
        config.setAddSourceAndSink(true);
        config.setApplyOrderingHeuristic(0.0);
        return CriticalPathAnalysis.run(trace, config);
    }

    public static CpaResult run(ITrace trace, ConstraintConfig config) throws PositiveCycleException {
        if (!config.isAddSourceAndSink()) {
            config.setAddSourceAndSink(true);
        }
        return CriticalPathAnalysis.applyBellmanFord(trace, config);
    }

    private static CpaResult applyBellmanFord(ITrace trace, ConstraintConfig config) throws PositiveCycleException {
        if (config.isUseDependencies() && config.isApplyOrderingHeuristic()) {
            throw new IllegalArgumentException("cannot use dependencies and ordering heuristic");
        }
        ConstraintGraph cg = new ConstraintGraph(trace, config);
        ConstraintGraphNode cgSrc = cg.getNodes().get(0);
        ConstraintGraphNode cgSnk = cg.getNodes().get(cg.getNodes().size() - 1);
        double[] dist = new double[cg.size()];
        HashSet[] pre = new HashSet[cg.size()];
        CriticalPathAnalysis.initializeBFdata(cg, dist, pre, cgSrc);
        int i = 0;
        while (i < cg.size()) {
            boolean change = false;
            int j = 0;
            while (j < cg.size()) {
                ConstraintGraphNode src = cg.getNodes().get(j);
                for (Constraint edge : src.constraints()) {
                    ConstraintGraphNode dst = edge.getDst();
                    if (dist[src.getId()] + edge.weight() > dist[dst.getId()]) {
                        dist[dst.getId()] = dist[src.getId()] + edge.weight();
                        pre[dst.getId()].clear();
                        pre[dst.getId()].add(edge);
                        change = true;
                        continue;
                    }
                    if (dist[src.getId()] + edge.weight() != dist[dst.getId()]) continue;
                    pre[dst.getId()].add(edge);
                    change = true;
                }
                ++j;
            }
            if (!change) break;
            ++i;
        }
        CriticalPathAnalysis.assertNoPositiveCycles(cg, dist);
        return CriticalPathAnalysis.computeResult(cgSrc, cgSnk, pre, cg);
    }

    private static void initializeBFdata(ConstraintGraph cg, double[] dist, Set<Constraint>[] pre, ConstraintGraphNode startNode) {
        int i = 0;
        while (i < cg.size()) {
            pre[i] = new HashSet<Constraint>();
            ++i;
        }
        i = 0;
        while (i < cg.size()) {
            dist[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        dist[startNode.getId()] = 0.0;
    }

    private static void assertNoPositiveCycles(ConstraintGraph cg, double[] dist) throws PositiveCycleException {
        for (ConstraintGraphNode ei : cg.getNodes()) {
            for (Constraint edge : ei.constraints()) {
                if (!(dist[ei.getId()] + edge.weight() > dist[edge.getDst().getId()])) continue;
                throw new PositiveCycleException("graph contains a positive-weight cycle: " + ei);
            }
        }
    }

    private static CpaResult computeResult(ConstraintGraphNode srcNode, ConstraintGraphNode snkNode, Collection<Constraint>[] pre, ConstraintGraph cg) {
        ArrayList<IDependency> criticalDeps = new ArrayList<IDependency>();
        ArrayList<ConstraintGraphNode> waiting = new ArrayList<ConstraintGraphNode>();
        waiting.add(cg.getNodes().get(cg.size() - 1));
        HashSet<ConstraintGraphNode> passed = new HashSet<ConstraintGraphNode>();
        while (!waiting.isEmpty()) {
            ConstraintGraphNode dst = (ConstraintGraphNode)waiting.remove(waiting.size() - 1);
            for (Constraint constraint : pre[dst.getId()]) {
                ConstraintGraphNode src = constraint.getSrc();
                if (!passed.contains(src)) {
                    waiting.add(src);
                }
                if (!(src instanceof EventNode) || !(dst instanceof EventNode)) continue;
                IEvent srcEvent = ((EventNode)src).getEvent();
                IEvent dstEvent = ((EventNode)dst).getEvent();
                Dependency dep = new Dependency(srcEvent, dstEvent);
                dep.setAttribute(CPA_ATT_CRITICAL, CPA_ATT_CRITICAL_TRUE);
                criticalDeps.add(dep);
            }
            passed.add(dst);
        }
        return new CpaResult(criticalDeps);
    }
}

