/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

public class JavaStringConverter {
    public String convertFromJavaString(String string, boolean useUnicode) {
        int firstEscapeSequence = string.indexOf(92);
        if (firstEscapeSequence == -1) {
            return string;
        }
        int length = string.length();
        StringBuilder result = new StringBuilder(length);
        this.appendRegion(string, 0, firstEscapeSequence, result);
        return this.convertFromJavaString(string, useUnicode, firstEscapeSequence, result);
    }

    protected void appendRegion(String string, int fromInclusive, int toExclusive, StringBuilder result) {
        if (this.validateRegion(string, fromInclusive, toExclusive, result)) {
            result.append(string, fromInclusive, toExclusive);
        } else {
            for (int i = fromInclusive; i < toExclusive; ++i) {
                this.validateAndAppendChar(string.charAt(i), result);
            }
        }
    }

    protected boolean validateRegion(String string, int fromInclusive, int toExclusive, StringBuilder result) {
        return true;
    }

    protected String convertFromJavaString(String string, boolean useUnicode, int index, StringBuilder result) {
        int length = string.length();
        while (index < length) {
            if ((index = this.unescapeCharAndAppendTo(string, useUnicode, index, result)) >= length) continue;
            int nextEscapeSequence = string.indexOf(92, index);
            if (nextEscapeSequence == -1) {
                this.appendRegion(string, index, length, result);
                index = length;
                continue;
            }
            this.appendRegion(string, index, nextEscapeSequence, result);
            index = nextEscapeSequence;
        }
        return result.toString();
    }

    protected int unescapeCharAndAppendTo(String string, boolean useUnicode, int index, StringBuilder result) {
        char c;
        if ((c = string.charAt(index++)) == '\\') {
            return this.doUnescapeCharAndAppendTo(string, useUnicode, index, result);
        }
        this.validateAndAppendChar(c, result);
        return index;
    }

    protected void validateAndAppendChar(char c, StringBuilder result) {
        if (this.validate(c, result)) {
            result.append(c);
        }
    }

    protected boolean validate(char c, StringBuilder result) {
        return true;
    }

    protected int doUnescapeCharAndAppendTo(String string, boolean useUnicode, int index, StringBuilder result) {
        char c = string.charAt(index++);
        switch (c) {
            case 'b': {
                c = '\b';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case '\"': 
            case '\'': 
            case '\\': {
                break;
            }
            case 'u': {
                if (useUnicode) {
                    return this.unescapeUnicodeSequence(string, index, result);
                }
            }
            default: {
                return this.handleUnknownEscapeSequence(string, c, useUnicode, index, result);
            }
        }
        this.validateAndAppendChar(c, result);
        return index;
    }

    protected int handleUnknownEscapeSequence(String string, char c, boolean useUnicode, int index, StringBuilder result) {
        throw new IllegalArgumentException("Illegal escape character \\" + c);
    }

    protected int unescapeUnicodeSequence(String string, int index, StringBuilder result) {
        if (!this.isInvalidUnicodeEscapeSequence(string, index)) {
            char c1 = string.charAt(index);
            char c2 = string.charAt(index + 1);
            char c3 = string.charAt(index + 2);
            char c4 = string.charAt(index + 3);
            if (JavaStringConverter.isHex(c1) && JavaStringConverter.isHex(c2) && JavaStringConverter.isHex(c3) && JavaStringConverter.isHex(c4)) {
                int appendMe = 0;
                appendMe = this.buildChar(appendMe, c1);
                appendMe = this.buildChar(appendMe, c2);
                appendMe = this.buildChar(appendMe, c3);
                appendMe = this.buildChar(appendMe, c4);
                this.validateAndAppendChar((char)appendMe, result);
                return index + 4;
            }
        }
        return this.handleInvalidUnicodeEscapeSequence(string, index, result);
    }

    private int buildChar(int appendMe, char c) {
        if (c <= '9') {
            return (appendMe << 4) + c - 48;
        }
        if (c >= 'a') {
            return (appendMe << 4) + c - 97 + 10;
        }
        return (appendMe << 4) + c - 65 + 10;
    }

    protected boolean isInvalidUnicodeEscapeSequence(String string, int index) {
        return index + 4 > string.length();
    }

    protected int handleInvalidUnicodeEscapeSequence(String string, int index, StringBuilder result) {
        throw new IllegalArgumentException("Illegal \\uxxxx encoding in " + string + " at index " + index);
    }

    public String convertToJavaString(String theString) {
        return this.convertToJavaString(theString, true);
    }

    public String convertToJavaString(String input, boolean useUnicode) {
        int length = input.length();
        StringBuilder result = new StringBuilder(length + 4);
        for (int i = 0; i < length; ++i) {
            this.escapeAndAppendTo(input.charAt(i), useUnicode, result);
        }
        return result.toString();
    }

    protected void escapeAndAppendTo(char c, boolean useUnicode, StringBuilder result) {
        String appendMe;
        switch (c) {
            case '\b': {
                appendMe = "\\b";
                break;
            }
            case '\t': {
                appendMe = "\\t";
                break;
            }
            case '\n': {
                appendMe = "\\n";
                break;
            }
            case '\f': {
                appendMe = "\\f";
                break;
            }
            case '\r': {
                appendMe = "\\r";
                break;
            }
            case '\"': {
                appendMe = "\\\"";
                break;
            }
            case '\'': {
                appendMe = "\\'";
                break;
            }
            case '\\': {
                appendMe = "\\\\";
                break;
            }
            default: {
                if (useUnicode && this.mustEncodeAsEscapeSequence(c)) {
                    result.append("\\u");
                    for (int i = 12; i >= 0; i -= 4) {
                        result.append(this.toHex(c >> i & 0xF));
                    }
                } else {
                    result.append(c);
                }
                return;
            }
        }
        result.append(appendMe);
    }

    protected boolean mustEncodeAsEscapeSequence(char next) {
        return next < ' ' || next > '~';
    }

    public char toHex(int i) {
        return "0123456789ABCDEF".charAt(i & 0xF);
    }

    protected boolean isHexSequence(String in, int off, int chars) {
        return JavaStringConverter.doIsHexSequence(in, off, chars);
    }

    public static boolean doIsHexSequence(String in, int off, int chars) {
        for (int i = off; i < in.length() && i < off + chars; ++i) {
            char c = in.charAt(i);
            if (JavaStringConverter.isHex(c)) continue;
            return false;
        }
        return true;
    }

    protected boolean isHexSequence(char[] in, int off, int chars) {
        return JavaStringConverter.doIsHexSequence(in, off, chars);
    }

    public static boolean doIsHexSequence(char[] in, int off, int chars) {
        for (int i = off; i < in.length && i < off + chars; ++i) {
            char c = in[i];
            if (JavaStringConverter.isHex(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        return '0' <= c && (c = (char)(c | 0x20)) <= 'f' && (c <= '9' || 'a' <= c);
    }
}

