/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CycleDetector {
    private final Set<String> vertices = new HashSet<String>();
    private final Map<String, Set<String>> successors = new HashMap<String, Set<String>>();

    private void addVertex(String name) {
        this.vertices.add(name);
        if (!this.successors.containsKey(name)) {
            this.successors.put(name, new HashSet());
        }
    }

    public void addEdge(String src, String dst) {
        this.addVertex(src);
        this.addVertex(dst);
        this.successors.get(src).add(dst);
    }

    private boolean dfs(String v, Set<String> white, Set<String> grey, Set<String> black) {
        white.remove(v);
        grey.add(v);
        for (String w : this.successors.get(v)) {
            if (black.contains(w)) continue;
            if (grey.contains(w)) {
                return true;
            }
            if (!this.dfs(w, white, grey, black)) continue;
            return true;
        }
        grey.remove(v);
        black.add(v);
        return false;
    }

    public boolean hasCycle() {
        HashSet<String> white = new HashSet<String>();
        HashSet<String> grey = new HashSet<String>();
        HashSet<String> black = new HashSet<String>();
        white.addAll(this.vertices);
        while (!white.isEmpty()) {
            for (String v : this.vertices) {
                if (!white.contains(v) || !this.dfs(v, white, grey, black)) continue;
                return true;
            }
        }
        return false;
    }
}

