/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.trace4cps.analysis.behavior.impl.FilteringClaimRepresentation;
import org.eclipse.trace4cps.analysis.dist.DistanceAnalysis;
import org.eclipse.trace4cps.analysis.dist.Representation;
import org.eclipse.trace4cps.core.IEvent;

public final class Behavior {
    private final String idAtt;
    private final int idVal;
    private final List<IEvent> events = new ArrayList<IEvent>();

    Behavior(String idAtt, int idVal) {
        this.idAtt = idAtt;
        this.idVal = idVal;
    }

    void add(IEvent task) {
        this.events.add(task);
    }

    int getValue() {
        return this.idVal;
    }

    public int size() {
        return this.events.size();
    }

    public List<IEvent> getEvents() {
        return this.events;
    }

    long distanceTo(Behavior other, Set<String> uniquenessAtts) {
        HashMap<Integer, Integer> renaming = new HashMap<Integer, Integer>();
        renaming.put(this.idVal, 0);
        renaming.put(other.idVal, 0);
        FilteringClaimRepresentation rep = new FilteringClaimRepresentation(this.idAtt, uniquenessAtts, renaming);
        return DistanceAnalysis.distance(this.events, other.events, (Representation)rep);
    }

    public String toString() {
        return "Behavior[" + this.idAtt + "=" + this.idVal + "]";
    }
}

