/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.process;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.Env;
import org.eclipse.tcf.te.ui.terminals.manager.ConsoleManager;
import org.eclipse.tcf.te.ui.terminals.process.ProcessMonitor;
import org.eclipse.tcf.te.ui.terminals.process.ProcessSettings;
import org.eclipse.tcf.te.ui.terminals.process.ProcessSettingsPage;
import org.eclipse.tcf.te.ui.terminals.process.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.process.help.IContextHelpIds;
import org.eclipse.tcf.te.ui.terminals.process.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.streams.AbstractStreamsConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class ProcessConnector
extends AbstractStreamsConnector {
    private final ProcessSettings settings;
    private PTY pty;
    private Process process;
    private ProcessMonitor monitor;
    private int width = -1;
    private int height = -1;

    public ProcessConnector() {
        this(new ProcessSettings());
    }

    public ProcessConnector(ProcessSettings settings) {
        Assert.isNotNull((Object)settings);
        this.settings = settings;
    }

    public Process getProcess() {
        return this.process;
    }

    public void connect(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        super.connect(control);
        this.pty = null;
        this.width = -1;
        this.height = -1;
        try {
            String lineSeparator;
            this.process = this.settings.getProcess();
            this.pty = this.settings.getPTY();
            if (this.process == null) {
                if (PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL)) {
                    try {
                        this.pty = new PTY(PTY.Mode.TERMINAL);
                    }
                    catch (IOException iOException) {}
                }
                StringBuilder command = new StringBuilder(this.settings.getImage());
                String arguments = this.settings.getArguments();
                if (arguments != null && !"".equals(arguments.trim())) {
                    command.append(" ");
                    command.append(arguments.trim());
                }
                File workingDir = null;
                if (this.settings.getWorkingDir() != null) {
                    workingDir = new File(this.settings.getWorkingDir());
                }
                String[] envp = null;
                if (this.settings.getEnvironment() != null) {
                    envp = this.settings.getEnvironment();
                }
                if (this.settings.isMergeWithNativeEnvironment()) {
                    envp = Env.getEnvironment((String[])envp, (boolean)true);
                }
                if (this.pty != null) {
                    StreamTokenizer st = new StreamTokenizer(new StringReader(command.toString()));
                    st.resetSyntax();
                    st.whitespaceChars(0, 32);
                    st.whitespaceChars(160, 160);
                    st.wordChars(33, 255);
                    st.quoteChar(34);
                    st.quoteChar(39);
                    ArrayList<String> argv = new ArrayList<String>();
                    int ttype = st.nextToken();
                    while (ttype != -1) {
                        argv.add(st.sval);
                        ttype = st.nextToken();
                    }
                    this.process = ProcessFactory.getFactory().exec(argv.toArray(new String[argv.size()]), envp, workingDir, this.pty);
                } else {
                    this.process = Runtime.getRuntime().exec(command.toString(), envp, workingDir);
                }
            }
            if ((lineSeparator = this.settings.getLineSeparator()) == null && this.pty == null) {
                lineSeparator = System.getProperty("line.separator");
                lineSeparator = "\r".equals(lineSeparator) ? "\\r" : ("\n".equals(lineSeparator) ? "\\n" : "\\r\\n");
            }
            this.setStdoutListeners(this.settings.getStdOutListeners());
            this.setStderrListeners(this.settings.getStdErrListeners());
            if (this.pty != null && "win32".equals(Platform.getOS())) {
                control.setVT100LineWrapping(true);
            }
            this.connectStreams(control, this.process.getOutputStream(), this.process.getInputStream(), this.pty == null ? this.process.getErrorStream() : null, this.settings.isLocalEcho(), lineSeparator);
            control.setState(TerminalState.CONNECTED);
            this.monitor = new ProcessMonitor(this);
            this.monitor.startMonitoring();
        }
        catch (IOException e) {
            this.disconnect();
            CTabItem item = ConsoleManager.getInstance().findConsole(control);
            if (item != null) {
                item.dispose();
            }
            String msg = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "";
            Assert.isNotNull((Object)msg);
            msg = msg.replace("Exec_tty error:", "").trim();
            msg = NLS.bind((String)Messages.ProcessConnector_error_creatingProcess, (Object)this.settings.getImage(), (Object)msg);
            Status status = new Status(4, UIPlugin.getUniqueIdentifier(), msg, (Throwable)e);
            StatusHandlerUtil.handleStatus((IStatus)status, (Object)((Object)this), (String)msg, (String)Messages.ProcessConnector_error_title, (String)IContextHelpIds.MESSAGE_CREATE_PROCESS_FAILED, (Object)((Object)this), null);
        }
    }

    public boolean isLocalEcho() {
        return this.settings.isLocalEcho();
    }

    public void doDisconnect() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        super.doDisconnect();
        this.fControl.setState(TerminalState.CLOSED);
    }

    public ISettingsPage makeSettingsPage() {
        return new ProcessSettingsPage(this.settings);
    }

    public String getSettingsSummary() {
        return this.settings.getImage() != null ? this.settings.getImage() : "";
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.width != newWidth || this.height != newHeight) {
            this.width = newWidth;
            this.height = newHeight;
            if (this.pty != null) {
                this.pty.setTerminalSize(newWidth, newHeight);
            }
        }
    }
}

