/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.lrparser.ISecondaryParser;
import org.eclipse.cdt.core.dom.lrparser.action.ASTCompletionNode;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.action.ParserUtil;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParserAction {
    protected static final Object PLACE_HOLDER = Boolean.TRUE;
    protected final ITokenStream stream;
    protected final ScopedStack<Object> astStack;
    protected ASTCompletionNode completionNode;
    protected Map<String, String> properties = Collections.emptyMap();

    protected abstract boolean isCompletionToken(IToken var1);

    protected abstract IASTName createName(char[] var1);

    public AbstractParserAction(ITokenStream parser, ScopedStack<Object> astStack) {
        if (parser == null) {
            throw new NullPointerException("parser is null");
        }
        if (astStack == null) {
            throw new NullPointerException("astStack is null");
        }
        this.stream = parser;
        this.astStack = astStack;
    }

    protected void setOffsetAndLength(IASTNode node) {
        int ruleOffset = this.stream.getLeftIToken().getStartOffset();
        int ruleLength = this.stream.getRightIToken().getEndOffset() - ruleOffset;
        ((ASTNode)node).setOffsetAndLength(ruleOffset, ruleLength < 0 ? 0 : ruleLength);
    }

    protected IASTName createName(IToken token) {
        IASTName name = this.createName(token.toString().toCharArray());
        ParserUtil.setOffsetAndLength((IASTNode)name, token);
        if (this.isCompletionToken(token)) {
            this.addNameToCompletionNode(name, token.toString());
        }
        return name;
    }

    public void setParserProperties(Map<String, String> properties) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    protected void addNameToCompletionNode(IASTName name, String prefix) {
        if (this.completionNode == null) {
            this.completionNode = this.newCompletionNode(prefix);
        }
        this.completionNode.addName(name);
    }

    public ASTCompletionNode newCompletionNode(String prefix) {
        return new ASTCompletionNode(prefix);
    }

    public IASTCompletionNode getASTCompletionNode() {
        return this.completionNode;
    }

    public IASTNode getParseResult() {
        return (IASTNode)this.astStack.peek();
    }

    protected <N extends IASTNode> N runSecondaryParser(ISecondaryParser<N> secondaryParser) {
        return this.runSecondaryParser(secondaryParser, this.stream.getRuleTokens());
    }

    protected <N extends IASTNode> N runSecondaryParser(ISecondaryParser<N> secondaryParser, List<IToken> tokens) {
        int[] savedKinds = new int[tokens.size()];
        int i = 0;
        for (IToken token : tokens) {
            savedKinds[i++] = token.getKind();
        }
        secondaryParser.setTokens(tokens);
        Object result = secondaryParser.parse();
        IASTCompletionNode compNode = secondaryParser.getCompletionNode();
        if (compNode != null) {
            IASTName[] iASTNameArray = compNode.getNames();
            int n = iASTNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName name = iASTNameArray[n2];
                this.addNameToCompletionNode(name, compNode.getPrefix());
                ++n2;
            }
        }
        i = 0;
        for (IToken token : tokens) {
            token.setKind(savedKinds[i++]);
        }
        return result;
    }

    public void openASTScope() {
        this.astStack.openScope();
    }

    public void consumeEmpty() {
        this.astStack.push(null);
    }

    public void consumePlaceHolder() {
        this.astStack.push(PLACE_HOLDER);
    }

    public void consumeIgnore() {
        this.astStack.pop();
    }

    public void consumeToken() {
        this.astStack.push(this.stream.getRightIToken());
    }
}

