/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.xlc.preferences;

import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcPref;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class XlcLanguagePreferences {
    private static final String QUALIFIER = "org.eclipse.cdt.core.lrparser.xlc";
    private static final String XLC_PREFERENCES_NODE = "xlc.preferences";

    static void initializeDefaultPreferences() {
        Preferences defaultNode = XlcLanguagePreferences.getDefaultPreferences();
        XlcPref[] xlcPrefArray = XlcPref.values();
        int n = xlcPrefArray.length;
        int n2 = 0;
        while (n2 < n) {
            XlcPref p = xlcPrefArray[n2];
            defaultNode.put(p.toString(), p.getDefaultValue());
            ++n2;
        }
    }

    public static void setProjectPreference(XlcPref key, String value, IProject project) {
        XlcLanguagePreferences.getProjectPreferences(project).put(key.toString(), value);
    }

    public static void setWorkspacePreference(XlcPref key, String value) {
        XlcLanguagePreferences.getWorkspacePreferences().put(key.toString(), value);
    }

    public static String getProjectPreference(XlcPref key, IProject project) {
        return XlcLanguagePreferences.getProjectPreferences(project).get(key.toString(), null);
    }

    public static String getWorkspacePreference(XlcPref key) {
        return XlcLanguagePreferences.getWorkspacePreferences().get(key.toString(), null);
    }

    public static String getDefaultPreference(XlcPref key) {
        return XlcLanguagePreferences.getDefaultPreferences().get(key.toString(), null);
    }

    public static String get(XlcPref key, IProject project) {
        return Platform.getPreferencesService().get(key.toString(), null, XlcLanguagePreferences.getPreferences(project));
    }

    private static Preferences[] getPreferences(IProject project) {
        if (project == null) {
            return new Preferences[]{XlcLanguagePreferences.getWorkspacePreferences(), XlcLanguagePreferences.getDefaultPreferences()};
        }
        return new Preferences[]{XlcLanguagePreferences.getProjectPreferences(project), XlcLanguagePreferences.getWorkspacePreferences(), XlcLanguagePreferences.getDefaultPreferences()};
    }

    private static Preferences getDefaultPreferences() {
        return XlcLanguagePreferences.getPreferences((IScopeContext)new DefaultScope());
    }

    private static Preferences getWorkspacePreferences() {
        return XlcLanguagePreferences.getPreferences((IScopeContext)new InstanceScope());
    }

    private static Preferences getProjectPreferences(IProject project) {
        return XlcLanguagePreferences.getPreferences((IScopeContext)new ProjectScope(project));
    }

    private static Preferences getPreferences(IScopeContext scope) {
        return scope.getNode(QUALIFIER).node(XLC_PREFERENCES_NODE);
    }
}

