/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MappingSourceContainerType
extends AbstractSourceContainerTypeDelegate {
    private static final String ELEMENT_MAPPING = "mapping";
    private static final String ELEMENT_MAP_ENTRY = "mapEntry";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_MEMENTO = "memento";

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if (ELEMENT_MAPPING.equals(element.getNodeName())) {
                String name = element.getAttribute(ATTR_NAME);
                if (name == null) {
                    name = "";
                }
                ArrayList<MapEntrySourceContainer> entries = new ArrayList<MapEntrySourceContainer>();
                Node childNode = element.getFirstChild();
                while (childNode != null) {
                    Element child;
                    if (childNode.getNodeType() == 1 && ELEMENT_MAP_ENTRY.equals((child = (Element)childNode).getNodeName())) {
                        String childMemento = child.getAttribute(ATTR_MEMENTO);
                        if (childMemento == null || childMemento.length() == 0) {
                            this.abort(InternalSourceLookupMessages.MappingSourceContainerType_0, null);
                        }
                        ISourceContainerType type = DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(MapEntrySourceContainer.TYPE_ID);
                        MapEntrySourceContainer entry = (MapEntrySourceContainer)type.createSourceContainer(childMemento);
                        entries.add(entry);
                    }
                    childNode = childNode.getNextSibling();
                }
                MappingSourceContainer container = new MappingSourceContainer(name);
                for (MapEntrySourceContainer entry : entries) {
                    container.addMapEntry(entry);
                }
                return container;
            }
            this.abort(InternalSourceLookupMessages.MappingSourceContainerType_1, null);
        }
        this.abort(InternalSourceLookupMessages.MappingSourceContainerType_2, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        Document document = this.newDocument();
        Element element = document.createElement(ELEMENT_MAPPING);
        element.setAttribute(ATTR_NAME, container.getName());
        ISourceContainer[] entries = ((MappingSourceContainer)container).getSourceContainers();
        int i = 0;
        while (i < entries.length) {
            Element child = document.createElement(ELEMENT_MAP_ENTRY);
            child.setAttribute(ATTR_MEMENTO, entries[i].getType().getMemento(entries[i]));
            element.appendChild(child);
            ++i;
        }
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

