/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.search;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.search.FindReplaceDialog;
import org.eclipse.cdt.debug.ui.memory.search.MemoryMatch;
import org.eclipse.cdt.debug.ui.memory.search.MemorySearchPlugin;
import org.eclipse.cdt.debug.ui.memory.search.MemorySearchResult;
import org.eclipse.cdt.debug.ui.memory.search.Messages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.Page;

public class MemorySearchResultsPage
extends Page
implements ISearchResultPage,
IQueryListener {
    private TreeViewer fTreeViewer;
    private Composite fViewerContainer;
    private IQueryListener fQueryListener;
    private ISearchResultViewPart fPart;
    private ISearchQuery fQuery;

    public void queryAdded(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
    }

    public void queryStarting(ISearchQuery query) {
    }

    public String getID() {
        return MemorySearchPlugin.getUniqueIdentifier();
    }

    public String getLabel() {
        if (this.fQuery == null) {
            return Messages.getString("MemorySearchResultsPage.LabelMemorySearch");
        }
        return this.fQuery.getLabel();
    }

    public Object getUIState() {
        return this.fTreeViewer.getSelection();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
    }

    public void setInput(ISearchResult search, Object uiState) {
        if (search instanceof MemorySearchResult) {
            ((MemorySearchResult)search).addListener(new ISearchResultListener(){

                public void searchResultChanged(SearchResultEvent e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MemorySearchResultsPage.this.fTreeViewer.refresh();
                        }
                    });
                }
            });
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fPart = part;
    }

    public void createControl(Composite parent) {
        this.fViewerContainer = new Composite(parent, 0);
        this.fViewerContainer.setLayoutData((Object)new GridData(1808));
        this.fViewerContainer.setSize(100, 100);
        this.fViewerContainer.setLayout((Layout)new FillLayout());
        this.fTreeViewer = new TreeViewer(this.fViewerContainer, 770);
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (MemorySearchResultsPage.this.fQuery == null) {
                    return new Object[0];
                }
                return ((MemorySearchResult)MemorySearchResultsPage.this.fQuery.getSearchResult()).getMatches();
            }
        });
        this.fTreeViewer.setInput(new Object());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    IMemoryRenderingContainer[] containers = ((FindReplaceDialog.IMemorySearchQuery)MemorySearchResultsPage.this.fQuery).getMemoryView().getMemoryRenderingContainers();
                    MemoryMatch match = (MemoryMatch)((StructuredSelection)event.getSelection()).getFirstElement();
                    if (match != null) {
                        int i = 0;
                        while (i < containers.length) {
                            IMemoryRendering rendering = containers[i].getActiveRendering();
                            if (rendering instanceof IRepositionableMemoryRendering) {
                                try {
                                    ((IRepositionableMemoryRendering)rendering).goToAddress(match.getStartAddress());
                                }
                                catch (DebugException e) {
                                    MemorySearchPlugin.logError(Messages.getString("MemorySearchResultsPage.RepositioningMemoryViewFailed"), (Exception)((Object)e));
                                }
                            }
                            if (rendering != null) {
                                try {
                                    Method m = rendering.getClass().getMethod("setSelection", BigInteger.class, BigInteger.class);
                                    if (m != null) {
                                        m.invoke((Object)rendering, match.getStartAddress(), match.getEndAddress());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            ++i;
                        }
                    }
                }
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public String getText(Object element) {
                if (element instanceof MemoryMatch) {
                    return "0x" + ((MemoryMatch)element).getStartAddress().toString(16);
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fQueryListener = this.createQueryListener();
        NewSearchUI.addQueryListener((IQueryListener)this.fQueryListener);
    }

    private IQueryListener createQueryListener() {
        return new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryRemoved(ISearchQuery query) {
                this.queryStarting(query);
            }

            public void queryStarting(ISearchQuery query) {
                MemorySearchResultsPage.this.fQuery = query;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MemorySearchResultsPage.this.fPart.updateLabel();
                        if (!MemorySearchResultsPage.this.fTreeViewer.getControl().isDisposed()) {
                            MemorySearchResultsPage.this.fTreeViewer.refresh();
                        }
                    }
                });
            }

            public void queryFinished(ISearchQuery query) {
            }
        };
    }

    public void dispose() {
        this.fTreeViewer.getControl().dispose();
        this.fViewerContainer.dispose();
    }

    public Control getControl() {
        return this.fViewerContainer;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
    }
}

