/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditor;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Automakefile;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IMacroDefinition;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.TargetRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class AutomakeTextHover
implements ITextHover,
ITextHoverExtension {
    AutomakeEditor editor;

    public AutomakeTextHover(AutomakeEditor editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block17: {
            String hoverText;
            Automakefile makefile;
            block16: {
                int hoverLine;
                TargetRule target = null;
                String[] preReqs = null;
                if (hoverRegion == null || hoverRegion.getLength() == 0) {
                    return null;
                }
                makefile = (Automakefile)this.editor.getMakefile();
                if (makefile == null) {
                    return null;
                }
                try {
                    hoverText = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                    hoverLine = textViewer.getDocument().getLineOfOffset(hoverRegion.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                if (!hoverText.startsWith("$")) break block16;
                IDirective containingDirective = makefile.getDirectiveContainingLine(hoverLine);
                if (containingDirective instanceof TargetRule) {
                    target = (TargetRule)containingDirective;
                }
                if (target == null) {
                    return "";
                }
                switch (hoverText.charAt(1)) {
                    case '@': {
                        return target.getTarget().toString();
                    }
                    case '<': {
                        preReqs = target.getPrerequisites();
                        if (preReqs != null && preReqs.length > 0) {
                            return preReqs[0];
                        }
                        break block17;
                    }
                    case '?': {
                        preReqs = target.getPrerequisites();
                        if (preReqs != null && preReqs.length > 0) {
                            StringBuffer toReturn = new StringBuffer();
                            toReturn.append(preReqs[0]);
                            int i = 1;
                            while (i < preReqs.length) {
                                toReturn.append(" " + preReqs[i]);
                                ++i;
                            }
                            return toReturn.toString();
                        }
                        break block17;
                    }
                }
                break block17;
            }
            IMacroDefinition[] macroDefinitions = makefile.getMacroDefinitions(hoverText);
            int i = 0;
            while (i < macroDefinitions.length) {
                IMacroDefinition definition = macroDefinitions[i];
                if (definition.getName().equals(hoverText)) {
                    return definition.getValue().toString();
                }
                ++i;
            }
        }
        return "";
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            Point selectedRange = textViewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            return this.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    private IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && c != '@' && c != '<' && c != '*' && c != '?' && c != '%') break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && c != '@' && c != '<' && c != '*' && c != '?' && c != '%') break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return null;
    }
}

