/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.qt.core.pdom.ASTNameReference;
import org.eclipse.cdt.internal.qt.core.pdom.IQtPDOMCodec;
import org.eclipse.cdt.internal.qt.core.pdom.QObjectName;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMArray;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMBinding;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMNodeType;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMVisitor;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.core.runtime.CoreException;

public class QtPDOMQObject
extends QtPDOMBinding {
    private static int offsetInitializer = QtPDOMBinding.Field.Last.offset;
    private final PDOMNodeLinkedList children;

    protected QtPDOMQObject(QtPDOMLinkage linkage, long record) throws CoreException {
        super(linkage, record);
        this.children = new PDOMNodeLinkedList((PDOMLinkage)linkage, Field.Children.getRecord(record));
    }

    public QtPDOMQObject(QtPDOMLinkage linkage, IASTName qtName, IASTName cppName) throws CoreException {
        super(linkage, null, qtName);
        IPDOMBinding cppPDOMBinding;
        IIndexFragmentBinding cppBinding = this.getPDOM().findBinding(cppName);
        if (cppBinding != null && (cppPDOMBinding = (IPDOMBinding)cppBinding.getAdapter(IPDOMBinding.class)) != null && cppPDOMBinding.getLinkage() != null && cppPDOMBinding.getLinkage().getLinkageID() == 1) {
            this.getDB().putRecPtr(Field.CppRecord.getRecord(this.record), cppPDOMBinding.getRecord());
        }
        this.children = new PDOMNodeLinkedList((PDOMLinkage)linkage, Field.Children.getRecord(this.record));
        if (qtName instanceof QObjectName) {
            QObjectName qobjName = (QObjectName)qtName;
            this.setClassInfos(qobjName.getClassInfos());
        }
    }

    public void delete() throws CoreException {
        long fieldRec = Field.ClassInfos.getRecord(this.record);
        new QtPDOMArray<ClassInfo>(this.getQtLinkage(), ClassInfo.Codec, fieldRec).delete();
        this.getDB().putRecPtr(Field.ClassInfos.getRecord(this.record), 0L);
    }

    public ICPPClassType getCppClassType() throws CoreException {
        long cppRec = this.getDB().getRecPtr(Field.CppRecord.getRecord(this.record));
        if (cppRec == 0L) {
            return null;
        }
        PDOMLinkage cppLinkage = this.getPDOM().getLinkage(1);
        if (cppLinkage == null) {
            return null;
        }
        PDOMBinding cppBinding = cppLinkage.getBinding(cppRec);
        return cppBinding instanceof ICPPClassType ? (ICPPClassType)cppBinding : null;
    }

    public void setClassInfos(Map<String, String> classInfos) throws CoreException {
        if (!Field.ClassInfos.isSupportedIn(this.getQtLinkage())) {
            return;
        }
        ClassInfo[] array = new ClassInfo[classInfos.size()];
        Iterator<Map.Entry<String, String>> iterator = classInfos.entrySet().iterator();
        int i = 0;
        while (i < array.length && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            array[i] = new ClassInfo(entry.getKey(), entry.getValue());
            ++i;
        }
        long arrayRec = this.getDB().getRecPtr(Field.ClassInfos.getRecord(this.record));
        QtPDOMArray<ClassInfo> pdomArray = new QtPDOMArray<ClassInfo>(this.getQtLinkage(), ClassInfo.Codec, arrayRec);
        arrayRec = pdomArray.set((ClassInfo[])array);
        this.getDB().putRecPtr(Field.ClassInfos.getRecord(this.record), arrayRec);
    }

    public Map<String, String> getClassInfos() throws CoreException {
        LinkedHashMap<String, String> classInfos = new LinkedHashMap<String, String>();
        if (!Field.ClassInfos.isSupportedIn(this.getQtLinkage())) {
            return classInfos;
        }
        long arrayRec = this.getDB().getRecPtr(Field.ClassInfos.getRecord(this.record));
        QtPDOMArray<ClassInfo> pdomArray = new QtPDOMArray<ClassInfo>(this.getQtLinkage(), ClassInfo.Codec, arrayRec);
        ClassInfo[] array = pdomArray.get();
        if (array == null) {
            return classInfos;
        }
        ClassInfo[] classInfoArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo classInfo = classInfoArray[n2];
            classInfos.put(classInfo.key, classInfo.value);
            ++n2;
        }
        return classInfos;
    }

    @Override
    protected int getRecordSize() {
        return Field.Last.offset;
    }

    public int getNodeType() {
        return QtPDOMNodeType.QObject.Type;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public List<QtPDOMQObject> findBases() throws CoreException {
        ICPPClassType cppClassType = this.getCppClassType();
        if (cppClassType == null) {
            return Collections.emptyList();
        }
        ArrayList<QtPDOMQObject> bases = new ArrayList<QtPDOMQObject>();
        ICPPBase[] iCPPBaseArray = cppClassType.getBases();
        int n = iCPPBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            PDOMBinding pdomBinding;
            QtPDOMQObject baseQObj;
            IBinding baseCls;
            ICPPBase base = iCPPBaseArray[n2];
            if (base.getVisibility() == 1 && (baseCls = base.getBaseClass()) != null && (baseQObj = ASTNameReference.findFromBinding(QtPDOMQObject.class, pdomBinding = (PDOMBinding)baseCls.getAdapter(PDOMBinding.class))) != null) {
                bases.add(baseQObj);
            }
            ++n2;
        }
        return bases;
    }

    public void addChild(PDOMNode child) throws CoreException {
        this.children.addMember(child);
    }

    public <T extends QtPDOMBinding> List<T> getChildren(Class<T> cls) throws CoreException {
        QtPDOMVisitor.All<T> collector = new QtPDOMVisitor.All<T>(cls);
        try {
            this.children.accept(collector);
        }
        catch (CoreException e) {
            QtPlugin.log(e);
            return Collections.emptyList();
        }
        return collector.list;
    }

    private static class ClassInfo {
        public final String key;
        public final String value;
        public static final IQtPDOMCodec<ClassInfo> Codec = new IQtPDOMCodec<ClassInfo>(){

            @Override
            public int getElementSize() {
                return 8;
            }

            public ClassInfo[] allocArray(int count) {
                return new ClassInfo[count];
            }

            @Override
            public ClassInfo decode(QtPDOMLinkage linkage, long record) throws CoreException {
                long keyRec = linkage.getDB().getRecPtr(record);
                long valRec = linkage.getDB().getRecPtr(record + 4L);
                return new ClassInfo(linkage.getDB().getString(keyRec).getString(), linkage.getDB().getString(valRec).getString());
            }

            @Override
            public void encode(QtPDOMLinkage linkage, long record, ClassInfo element) throws CoreException {
                long rec = linkage.getDB().getRecPtr(record);
                if (rec != 0L) {
                    linkage.getDB().getString(rec).delete();
                }
                linkage.getDB().putRecPtr(record, element == null ? 0L : linkage.getDB().newString(element.key).getRecord());
                rec = linkage.getDB().getRecPtr(record + 4L);
                if (rec != 0L) {
                    linkage.getDB().getString(rec).delete();
                }
                linkage.getDB().putRecPtr(record + 4L, element == null ? 0L : linkage.getDB().newString(element.value).getRecord());
            }
        };

        public ClassInfo(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    protected static enum Field {
        CppRecord(4, 3),
        Children(4, 0),
        ClassInfos(4, 2),
        Last(0, 0);

        private final int offset = QtPDOMQObject.access$0();
        private final int version;

        private Field(int sizeof, int version) {
            this.version = version;
            offsetInitializer = offsetInitializer + sizeof;
        }

        public long getRecord(long baseRec) {
            return baseRec + (long)this.offset;
        }

        public boolean isSupportedIn(QtPDOMLinkage linkage) {
            return linkage.getVersion() >= this.version;
        }
    }
}

