/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.cdt.qt.core.index.IQtVersion;

public final class QMakeVersion
implements IQtVersion {
    private static final Pattern REGEXP = Pattern.compile("([\\d]+)\\.([\\d]+).*");
    private final int major;
    private final int minor;

    public static QMakeVersion create(String version) {
        if (version == null) {
            return null;
        }
        Matcher m = REGEXP.matcher(version.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            return new QMakeVersion(major, minor);
        }
        catch (NumberFormatException e) {
            QtPlugin.log(e);
            return null;
        }
    }

    private QMakeVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }
}

