/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.qt.core.index.QMakeEnvProviderManager;
import org.eclipse.cdt.internal.qt.core.index.QMakeInfo;
import org.eclipse.cdt.qt.core.QtNature;
import org.eclipse.cdt.qt.core.index.IQMakeEnv;
import org.eclipse.cdt.qt.core.index.IQMakeEnvProvider;
import org.eclipse.cdt.qt.core.index.IQMakeInfo;
import org.eclipse.cdt.qt.core.index.IQMakeProjectInfo;
import org.eclipse.cdt.qt.core.index.IQMakeProjectInfoListener;
import org.eclipse.cdt.qt.core.index.QMakeEnvInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class QMakeProjectInfo
implements IQMakeProjectInfo,
ICProjectDescriptionListener {
    private static final RCListener LISTENER = new RCListener();
    private static final Object SYNC = new Object();
    private static final Map<IProject, QMakeProjectInfo> CACHE = new HashMap<IProject, QMakeProjectInfo>();
    private final IProject project;
    private final Object sync = new Object();
    private boolean live = true;
    private final SensitiveSet sensitiveFilePathSet = new SensitiveSet();
    private ControllerImpl activeController;
    private IQMakeInfo qmakeInfo = null;
    private final List<IQMakeProjectInfoListener> listeners = new CopyOnWriteArrayList<IQMakeProjectInfoListener>();

    public static final void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)LISTENER, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)LISTENER);
        Object object = SYNC;
        synchronized (object) {
            Iterator<IProject> iterator;
            while ((iterator = CACHE.keySet().iterator()).hasNext()) {
                QMakeProjectInfo.removeProjectFromCache((IResource)iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QMakeProjectInfo getQMakeProjectInfoFor(IProject project) {
        Object object = SYNC;
        synchronized (object) {
            QMakeProjectInfo info = CACHE.get(project);
            if (info == null && QtNature.hasNature(project)) {
                info = new QMakeProjectInfo(project);
                CACHE.put(project, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeProjectFromCache(IResource project) {
        QMakeProjectInfo info;
        Object object = SYNC;
        synchronized (object) {
            info = CACHE.remove(project);
        }
        if (info != null) {
            info.destroy();
        }
    }

    private QMakeProjectInfo(IProject project) {
        this.project = project;
        CoreModel.getDefault().addCProjectDescriptionListener((ICProjectDescriptionListener)this, 1);
        this.updateActiveConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.live) {
                return;
            }
            this.live = false;
            CoreModel.getDefault().removeCProjectDescriptionListener((ICProjectDescriptionListener)this);
            this.setActiveConfiguration(null);
            this.qmakeInfo = QMakeInfo.INVALID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveConfiguration() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.live) {
                return;
            }
            ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescriptionManager().getProjectDescription(this.project);
            this.setActiveConfiguration(projectDescription != null ? projectDescription.getActiveConfiguration() : null);
            this.qmakeInfo = null;
        }
        this.notifyListeners();
    }

    private void setActiveConfiguration(ICConfigurationDescription configuration) {
        ControllerImpl previous = this.activeController;
        ControllerImpl controllerImpl = this.activeController = configuration != null ? new ControllerImpl(configuration) : null;
        if (previous != null) {
            previous.destroy();
        }
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        if (event.getProject() != this.project) {
            return;
        }
        this.updateActiveConfiguration();
    }

    @Override
    public void addListener(IQMakeProjectInfoListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IQMakeProjectInfoListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQMakeInfo getActualInfo() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.live) {
                return QMakeInfo.INVALID;
            }
            if (this.qmakeInfo == null) {
                this.fetchQMakeInfo();
            }
            return this.qmakeInfo;
        }
    }

    private void fetchQMakeInfo() {
        List<String> list;
        IQMakeEnv qmakeEnv = this.activeController != null ? this.activeController.getQMakeEnv() : null;
        QMakeEnvInfo qmakeEnvInfo = qmakeEnv != null ? qmakeEnv.getQMakeEnvInfo() : null;
        String proFilePath = QMakeProjectInfo.toFilePath(qmakeEnvInfo != null ? qmakeEnvInfo.getProFile() : null);
        String qmakeFilePath = qmakeEnvInfo != null ? qmakeEnvInfo.getQMakeFilePath() : null;
        ArrayList<String> envList = new ArrayList<String>();
        Map<Object, Object> envMap = qmakeEnvInfo != null ? qmakeEnvInfo.getEnvironment() : Collections.emptyMap();
        for (Map.Entry<Object, Object> entry : envMap.entrySet()) {
            envList.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
        }
        this.qmakeInfo = QMakeInfo.create(proFilePath, qmakeFilePath, envList.toArray(new String[envList.size()]));
        this.sensitiveFilePathSet.clear();
        Set<Object> envSensFiles = qmakeEnvInfo != null ? qmakeEnvInfo.getSensitiveFiles() : Collections.emptySet();
        for (IFile iFile : envSensFiles) {
            if (iFile == null) continue;
            this.sensitiveFilePathSet.addSensitiveFile(iFile);
        }
        if (proFilePath != null) {
            this.sensitiveFilePathSet.addSensitiveFile(proFilePath);
        }
        if ((list = this.qmakeInfo.getInvolvedQMakeFiles()) != null) {
            for (String sensitiveFile : list) {
                this.sensitiveFilePathSet.addSensitiveFile(sensitiveFile);
            }
        }
    }

    private static String toFilePath(IFile file) {
        File f;
        IPath rawLocation;
        if (file != null && (rawLocation = file.getRawLocation()) != null && (rawLocation = rawLocation.makeAbsolute()) != null && (f = rawLocation.toFile()) != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsAnySensitiveFile(Set<IPath> files) {
        Object object = this.sync;
        synchronized (object) {
            if (this.live) {
                for (IPath path : files) {
                    if (!this.sensitiveFilePathSet.contains(path)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFetchQMakeInfo() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.live) {
                return;
            }
            this.qmakeInfo = null;
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (IQMakeProjectInfoListener listener : this.listeners) {
            listener.qmakeInfoChanged();
        }
    }

    private final class ControllerImpl
    implements IQMakeEnvProvider.IController {
        private final ICConfigurationDescription configuration;
        private final IQMakeEnv qmakeEnv;

        public ControllerImpl(ICConfigurationDescription configuration) {
            this.configuration = configuration;
            this.qmakeEnv = QMakeEnvProviderManager.getInstance().createEnv(this);
        }

        public void destroy() {
            this.qmakeEnv.destroy();
        }

        public IQMakeEnv getQMakeEnv() {
            return this.qmakeEnv;
        }

        @Override
        public ICConfigurationDescription getConfiguration() {
            return this.configuration;
        }

        @Override
        public void scheduleUpdate() {
            QMakeProjectInfo.this.scheduleFetchQMakeInfo();
        }
    }

    private static final class RCListener
    implements IResourceChangeListener {
        private RCListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            RDVisitor visitor = new RDVisitor();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IResource project = event.getResource();
                    if (project == null || project.getType() != 4) break;
                    visitor.addProjectToDelete(project);
                    break;
                }
                case 1: {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) break;
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                        break;
                    }
                    catch (CoreException coreException) {}
                }
            }
            visitor.process();
        }
    }

    private static final class RDVisitor
    implements IResourceDeltaVisitor {
        private final Set<IResource> projectsToDelete = new HashSet<IResource>();
        private final Set<IPath> changedFiles = new HashSet<IPath>();

        private RDVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null) {
                switch (resource.getType()) {
                    case 1: {
                        this.addChangedFile(resource);
                        return false;
                    }
                    case 4: {
                        if (delta.getKind() != 2) break;
                        this.addProjectToDelete(resource);
                        return false;
                    }
                }
            }
            return true;
        }

        private void addProjectToDelete(IResource project) {
            this.projectsToDelete.add(project);
        }

        private void addChangedFile(IResource file) {
            IPath fullPath = file.getFullPath();
            if (fullPath != null) {
                this.changedFiles.add(fullPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            ArrayList infos;
            for (IResource project : this.projectsToDelete) {
                QMakeProjectInfo.removeProjectFromCache(project);
            }
            Object object = SYNC;
            synchronized (object) {
                infos = new ArrayList(CACHE.values());
            }
            for (QMakeProjectInfo info : infos) {
                if (!info.containsAnySensitiveFile(this.changedFiles)) continue;
                info.scheduleFetchQMakeInfo();
            }
        }
    }

    private static final class SensitiveSet
    extends HashSet<IPath> {
        private SensitiveSet() {
        }

        private void addSensitiveFile(String sensitiveFile) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = root.findFilesForLocation(Path.fromOSString((String)sensitiveFile));
            if (files != null && files.length > 0) {
                IFile file = files[0];
                this.addSensitiveFile(file);
            }
        }

        private void addSensitiveFile(IFile file) {
            IPath fullPath = file.getFullPath();
            if (fullPath != null) {
                this.add(fullPath);
            }
        }
    }
}

