/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.qt.core.QtMethodUtil;
import org.eclipse.cdt.internal.qt.core.QtSignalSlotReference;
import org.eclipse.cdt.qt.core.index.IQMethod;
import org.eclipse.cdt.qt.core.index.IQObject;
import org.eclipse.core.resources.IProject;

public class ASTUtil {
    public static final Pattern Regex_SignalSlotExpansion = Pattern.compile("(?s)(SIGNAL|SLOT)\\s*\\(\\s*(.*?)\\s*\\)\\s*");
    public static final Pattern Regex_FunctionCall = Pattern.compile("(?s)\\s*(.*)\\s*\\(\\s*(.*?)\\s*\\)\\s*");

    public static IProject getProject(IASTNode node) {
        IASTTranslationUnit astTU = node.getTranslationUnit();
        if (astTU == null) {
            return null;
        }
        ITranslationUnit tu = astTU.getOriginatingTranslationUnit();
        if (tu == null) {
            return null;
        }
        ICProject cProject = tu.getCProject();
        if (cProject == null) {
            return null;
        }
        return cProject.getProject();
    }

    public static IType getBaseType(IType type) {
        while (type instanceof ITypeContainer) {
            type = ((ITypeContainer)type).getType();
        }
        return type;
    }

    public static IType getBaseType(IASTNode node) {
        if (node instanceof IASTIdExpression) {
            return ASTUtil.getBaseType((IASTInitializerClause)((IASTIdExpression)node));
        }
        if (node instanceof IASTFunctionCallExpression) {
            return ASTUtil.getReceiverType((IASTFunctionCallExpression)node);
        }
        if (node instanceof IASTExpression) {
            return ASTUtil.getBaseType(((IASTExpression)node).getExpressionType());
        }
        return null;
    }

    public static IType getBaseType(IASTInitializerClause init) {
        if (!(init instanceof ICPPASTInitializerClause)) {
            return null;
        }
        ICPPASTInitializerClause cppInit = (ICPPASTInitializerClause)init;
        ICPPEvaluation eval = cppInit.getEvaluation();
        return eval == null ? null : ASTUtil.getBaseType(eval.getTypeOrFunctionSet((IASTNode)cppInit));
    }

    public static ICPPClassType getReceiverType(IASTFunctionCallExpression fncall) {
        IASTExpression fnName = fncall.getFunctionNameExpression();
        if (!(fnName instanceof ICPPASTFieldReference)) {
            return null;
        }
        ICPPASTFieldReference fieldRef = (ICPPASTFieldReference)fnName;
        ICPPASTExpression receiver = fieldRef.getFieldOwner();
        IType recvType = ASTUtil.getBaseType((IASTInitializerClause)receiver);
        return recvType instanceof ICPPClassType ? (ICPPClassType)recvType : null;
    }

    public static Collection<IQMethod> findMethods(IQObject qobj, QtSignalSlotReference ref) {
        LinkedHashSet<IQMethod> bindings = new LinkedHashSet<IQMethod>();
        Collection<IQMethod> methods = null;
        switch (ref.type) {
            case Signal: {
                methods = qobj.getSignals().withoutOverrides();
                break;
            }
            case Slot: {
                methods = qobj.getSlots().withoutOverrides();
            }
        }
        if (methods != null) {
            String qtNormalizedSig = QtMethodUtil.getQtNormalizedMethodSignature(ref.signature);
            if (qtNormalizedSig == null) {
                return bindings;
            }
            for (IQMethod method : methods) {
                for (String signature : method.getSignatures()) {
                    if (!signature.equals(qtNormalizedSig)) continue;
                    bindings.add(method);
                }
            }
        }
        return bindings;
    }

    public static IBinding resolveFunctionBinding(IASTFunctionCallExpression fnCall) {
        IASTName fnName = null;
        IASTExpression fnNameExpr = fnCall.getFunctionNameExpression();
        if (fnNameExpr instanceof IASTIdExpression) {
            fnName = ((IASTIdExpression)fnNameExpr).getName();
        } else if (fnNameExpr instanceof ICPPASTFieldReference) {
            fnName = ((ICPPASTFieldReference)fnNameExpr).getFieldName();
        }
        return fnName == null ? null : fnName.resolveBinding();
    }

    public static ICPPASTVisibilityLabel findVisibilityLabel(ICPPMethod method, IASTNode ast) {
        if (ast == null) {
            return null;
        }
        MethodSpec methodSpec = new MethodSpec(ast);
        if (methodSpec.clsSpec == null && method instanceof ICPPInternalBinding) {
            ICPPInternalBinding internalBinding = (ICPPInternalBinding)method;
            IASTNode[] decls = internalBinding.getDeclarations();
            int i = 0;
            while (methodSpec.clsSpec == null && i < decls.length) {
                methodSpec = new MethodSpec(decls[i]);
                ++i;
            }
        }
        if (methodSpec.clsSpec == null) {
            return null;
        }
        ICPPASTVisibilityLabel lastLabel = null;
        IASTDeclaration[] iASTDeclarationArray = methodSpec.clsSpec.getMembers();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof ICPPASTVisibilityLabel) {
                lastLabel = (ICPPASTVisibilityLabel)decl;
            } else if (decl == methodSpec.methodDecl) {
                return lastLabel;
            }
            ++n2;
        }
        return null;
    }

    private static class MethodSpec {
        public final ICPPASTCompositeTypeSpecifier clsSpec;
        public final IASTNode methodDecl;

        public MethodSpec(IASTNode node) {
            ICPPASTCompositeTypeSpecifier cls = null;
            IASTNode mth = node;
            while (mth != null && cls == null) {
                IASTNode parent = mth.getParent();
                if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                    cls = (ICPPASTCompositeTypeSpecifier)parent;
                    continue;
                }
                mth = parent;
            }
            this.clsSpec = cls;
            this.methodDecl = mth;
        }
    }
}

