/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.util.NoSuchElementException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMIterator;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

public class PDOMExternalReferencesList {
    private final PDOM pdom;
    private final long record;

    public PDOMExternalReferencesList(PDOM pdom, long record) throws CoreException {
        this.pdom = pdom;
        this.record = record;
    }

    public IPDOMIterator<PDOMName> getIterator() throws CoreException {
        return new Iterator(this.record);
    }

    public void add(PDOMName name) throws CoreException {
        long namerec;
        PDOMLinkage nameLinkage = name.getLinkage();
        int nameLinkageID = nameLinkage.getLinkageID();
        long lastAddr = this.record;
        long nodeRec = 0L;
        while ((nodeRec = this.pdom.getDB().getRecPtr(lastAddr)) != 0L) {
            int linkageID = this.pdom.getDB().getInt(nodeRec);
            if (linkageID == nameLinkageID) break;
            lastAddr = nodeRec + 4L;
        }
        if (nodeRec == 0L) {
            nodeRec = this.pdom.getDB().malloc(12);
            this.pdom.getDB().putInt(nodeRec, nameLinkageID);
            this.pdom.getDB().putRecPtr(nodeRec + 4L, 0L);
            this.pdom.getDB().putRecPtr(nodeRec + 4L + 4L, 0L);
            this.pdom.getDB().putRecPtr(lastAddr, nodeRec);
        }
        if ((namerec = this.pdom.getDB().getRecPtr(nodeRec + 4L + 4L)) != 0L) {
            PDOMName first = new PDOMName(nameLinkage, namerec);
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.pdom.getDB().putRecPtr(nodeRec + 4L + 4L, name.getRecord());
    }

    private class Iterator
    implements IPDOMIterator<PDOMName> {
        private long nodeAddr;
        private long node;
        private PDOMName next;

        public Iterator(long record) throws CoreException {
            this.nodeAddr = record;
            this.node = 0L;
            this.next = this.advance();
        }

        @Override
        public boolean hasNext() throws CoreException {
            return this.next != null;
        }

        @Override
        public PDOMName next() throws CoreException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            PDOMName ret = this.next;
            this.next = ret.getNextInBinding();
            if (this.next == null) {
                this.next = this.advance();
            }
            return ret;
        }

        private PDOMName advance() throws CoreException {
            while (true) {
                long nextNameRec = 0L;
                while (this.nodeAddr != 0L) {
                    this.node = PDOMExternalReferencesList.this.pdom.getDB().getRecPtr(this.nodeAddr);
                    if (this.node == 0L) {
                        return null;
                    }
                    nextNameRec = PDOMExternalReferencesList.this.pdom.getDB().getRecPtr(this.node + 4L + 4L);
                    if (nextNameRec != 0L) break;
                    this.nodeAddr = this.node + 4L;
                }
                if (this.nodeAddr == 0L || nextNameRec == 0L) {
                    return null;
                }
                this.nodeAddr = PDOMExternalReferencesList.this.pdom.getDB().getRecPtr(this.node + 4L);
                int linkageID = PDOMExternalReferencesList.this.pdom.getDB().getInt(this.node);
                PDOMLinkage linkage = PDOMExternalReferencesList.this.pdom.getLinkage(linkageID);
                if (linkage != null) {
                    return new PDOMName(linkage, nextNameRec);
                }
                CCorePlugin.log("Could not load linkage for external reference from linkageID " + linkageID);
            }
        }
    }
}

