/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.Template;

public class FunctionTemplateDeclaration
extends FunctionDeclaration
implements IFunctionTemplateDeclaration {
    protected Template fTemplate;

    public FunctionTemplateDeclaration(ICElement parent, String name) {
        super(parent, name, 88);
        this.fTemplate = new Template(name);
    }

    @Override
    public String[] getTemplateParameterTypes() {
        return this.fTemplate.getTemplateParameterTypes();
    }

    @Override
    public String[] getTemplateArguments() {
        return this.fTemplate.getTemplateArguments();
    }

    @Override
    public String getTemplateSignature() throws CModelException {
        StringBuffer sig = new StringBuffer(this.fTemplate.getTemplateSignature());
        sig.append(this.getParameterClause());
        if (this.isConst()) {
            sig.append(" const");
        }
        if (this.isVolatile()) {
            sig.append(" volatile");
        }
        if (this.getReturnType() != null && this.getReturnType().length() > 0) {
            sig.append(" : ");
            sig.append(this.getReturnType());
        }
        return sig.toString();
    }

    @Override
    public int getNumberOfTemplateParameters() {
        return this.fTemplate.getNumberOfTemplateParameters();
    }

    public void setTemplateParameterTypes(String[] templateParameterTypes) {
        this.fTemplate.setTemplateInfo(templateParameterTypes, null);
    }
}

