/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDecltypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.parser.GCCKeywords;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;

public class ASTStringUtil {
    private static final String SPACE = " ";
    private static final String COMMA_SPACE = ", ";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String getQualifiedName(IASTName name) {
        return ASTStringUtil.appendQualifiedNameString(new StringBuilder(), name).toString();
    }

    public static String getSimpleName(IASTName name) {
        return ASTStringUtil.appendSimpleNameString(new StringBuilder(), name).toString();
    }

    public static String getSignatureString(IASTDeclarator declarator) {
        return ASTStringUtil.trimRight(ASTStringUtil.appendSignatureString(new StringBuilder(), declarator)).toString();
    }

    public static String getSignatureString(IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) {
        StringBuilder buffer = new StringBuilder();
        ASTStringUtil.appendDeclarationString(buffer, declSpecifier, declarator, null);
        return ASTStringUtil.trimRight(buffer).toString();
    }

    public static String getReturnTypeString(IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator fdecl) {
        StringBuilder buffer = new StringBuilder();
        IASTDeclarator declarator = ASTQueries.findOutermostDeclarator(fdecl);
        ASTStringUtil.appendDeclarationString(buffer, declSpecifier, declarator, fdecl);
        return ASTStringUtil.trimRight(buffer).toString();
    }

    public static String[] getParameterSignatureArray(IASTFunctionDeclarator functionDeclarator) {
        if (functionDeclarator instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator standardFunctionDecl = (IASTStandardFunctionDeclarator)functionDeclarator;
            IASTParameterDeclaration[] parameters = standardFunctionDecl.getParameters();
            boolean takesVarArgs = standardFunctionDecl.takesVarArgs();
            String[] parameterStrings = new String[parameters.length + (takesVarArgs ? 1 : 0)];
            int i = 0;
            while (i < parameters.length) {
                parameterStrings[i] = ASTStringUtil.getParameterSignatureString(parameters[i]);
                ++i;
            }
            if (takesVarArgs) {
                parameterStrings[i] = new String(Keywords.cpELLIPSIS);
            }
            return parameterStrings;
        }
        if (functionDeclarator instanceof ICASTKnRFunctionDeclarator) {
            ICASTKnRFunctionDeclarator knrDeclarator = (ICASTKnRFunctionDeclarator)functionDeclarator;
            IASTName[] names = knrDeclarator.getParameterNames();
            String[] result = new String[names.length];
            int i = 0;
            while (i < names.length) {
                if (names[i] != null) {
                    IASTDeclarator declaratorForParameterName = knrDeclarator.getDeclaratorForParameterName(names[i]);
                    result[i] = declaratorForParameterName != null ? ASTStringUtil.getSignatureString(declaratorForParameterName) : "?";
                }
                ++i;
            }
            return result;
        }
        return EMPTY_STRING_ARRAY;
    }

    public static String[] getTemplateParameterArray(ICPPASTTemplateParameter[] templateParams) {
        String[] parameterTypes = new String[templateParams.length];
        int i = 0;
        while (i < templateParams.length) {
            StringBuilder paramType = new StringBuilder();
            ICPPASTTemplateParameter parameter = templateParams[i];
            ASTStringUtil.appendTemplateParameterString(paramType, parameter);
            parameterTypes[i] = ASTStringUtil.trimRight(paramType).toString();
            ++i;
        }
        return parameterTypes;
    }

    public static String getExpressionString(IASTExpression expression) {
        StringBuilder buf = new StringBuilder();
        return ASTStringUtil.appendExpressionString(buf, expression).toString();
    }

    public static String getInitializerString(IASTInitializer init) {
        StringBuilder buf = new StringBuilder();
        return ASTStringUtil.appendInitializerString(buf, init).toString();
    }

    public static String join(String[] strings, CharSequence delimiter) {
        if (strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder buf = new StringBuilder(strings[0]);
        int i = 1;
        while (i < strings.length) {
            buf.append(delimiter);
            buf.append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    private static String getParameterSignatureString(IASTParameterDeclaration parameterDeclaration) {
        return ASTStringUtil.trimRight(ASTStringUtil.appendParameterDeclarationString(new StringBuilder(), parameterDeclaration)).toString();
    }

    private static StringBuilder appendSignatureString(StringBuilder buffer, IASTDeclarator declarator) {
        IASTNode node = declarator.getParent();
        while (node instanceof IASTDeclarator) {
            declarator = (IASTDeclarator)node;
            node = node.getParent();
        }
        IASTDeclSpecifier declSpec = node instanceof IASTParameterDeclaration ? ((IASTParameterDeclaration)node).getDeclSpecifier() : (node instanceof IASTSimpleDeclaration ? ((IASTSimpleDeclaration)node).getDeclSpecifier() : (node instanceof IASTFunctionDefinition ? ((IASTFunctionDefinition)node).getDeclSpecifier() : (node instanceof IASTTypeId ? ((IASTTypeId)node).getDeclSpecifier() : null)));
        return ASTStringUtil.appendDeclarationString(buffer, declSpec, declarator, null);
    }

    private static StringBuilder appendDeclarationString(StringBuilder buffer, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator, IASTFunctionDeclarator returnTypeOf) {
        if (declSpecifier != null) {
            ASTStringUtil.appendDeclSpecifierString(buffer, declSpecifier);
            ASTStringUtil.trimRight(buffer);
        }
        ASTStringUtil.appendDeclaratorString(buffer, declarator, false, returnTypeOf);
        return buffer;
    }

    private static StringBuilder appendDeclaratorString(StringBuilder buffer, IASTDeclarator declarator, boolean protectPointers, IASTFunctionDeclarator returnTypeOf) {
        boolean useParenthesis;
        if (declarator == null) {
            return buffer;
        }
        IASTPointerOperator[] ptrs = declarator.getPointerOperators();
        boolean bl = useParenthesis = protectPointers && ptrs.length > 0;
        if (useParenthesis) {
            buffer.append(Keywords.cpLPAREN);
            protectPointers = false;
        }
        ASTStringUtil.appendPointerOperatorsString(buffer, ptrs);
        if (declarator != returnTypeOf) {
            IASTFieldDeclarator fieldDeclarator;
            IASTExpression bitFieldSize;
            IASTDeclarator nestedDeclarator = declarator.getNestedDeclarator();
            if (nestedDeclarator != null) {
                protectPointers = protectPointers || declarator instanceof IASTArrayDeclarator || declarator instanceof IASTFunctionDeclarator || declarator instanceof IASTFieldDeclarator;
                ASTStringUtil.appendDeclaratorString(buffer, nestedDeclarator, protectPointers, returnTypeOf);
            } else if (declarator instanceof ICPPASTDeclarator && ((ICPPASTDeclarator)declarator).declaresParameterPack()) {
                buffer.append(Keywords.cpELLIPSIS);
            }
            if (declarator instanceof IASTArrayDeclarator) {
                ASTStringUtil.appendArrayQualifiersString(buffer, (IASTArrayDeclarator)declarator);
            } else if (declarator instanceof IASTFunctionDeclarator) {
                IASTFunctionDeclarator functionDecl = (IASTFunctionDeclarator)declarator;
                ASTStringUtil.appendParameterSignatureString(buffer, functionDecl);
                if (declarator instanceof ICPPASTFunctionDeclarator) {
                    IASTTypeId[] exceptionTypeIds;
                    ICPPASTFunctionDeclarator cppFunctionDecl = (ICPPASTFunctionDeclarator)declarator;
                    if (cppFunctionDecl.isConst()) {
                        buffer.append("const").append(' ');
                    }
                    if (cppFunctionDecl.isVolatile()) {
                        buffer.append("volatile").append(' ');
                    }
                    if (cppFunctionDecl.isPureVirtual()) {
                        buffer.append("=0 ");
                    }
                    if ((exceptionTypeIds = cppFunctionDecl.getExceptionSpecification()) != ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION) {
                        buffer.append("throw").append(" (");
                        int i = 0;
                        while (i < exceptionTypeIds.length) {
                            if (i > 0) {
                                buffer.append(COMMA_SPACE);
                            }
                            ASTStringUtil.appendTypeIdString(buffer, exceptionTypeIds[i]);
                            ++i;
                        }
                        buffer.append(')');
                    }
                }
            } else if (declarator instanceof IASTFieldDeclarator && (bitFieldSize = (fieldDeclarator = (IASTFieldDeclarator)declarator).getBitFieldSize()) != null) {
                buffer.append(Keywords.cpCOLON);
                ASTStringUtil.appendExpressionString(buffer, bitFieldSize);
            }
        }
        if (useParenthesis) {
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpRPAREN);
        }
        return buffer;
    }

    private static StringBuilder appendInitializerString(StringBuilder buffer, IASTInitializer initializer) {
        if (initializer instanceof IASTEqualsInitializer) {
            IASTEqualsInitializer initializerExpression = (IASTEqualsInitializer)initializer;
            buffer.append(Keywords.cpASSIGN);
            ASTStringUtil.appendInitClauseString(buffer, initializerExpression.getInitializerClause());
        } else if (initializer instanceof IASTInitializerList) {
            IASTInitializerList initializerList = (IASTInitializerList)initializer;
            IASTInitializerClause[] initializers = initializerList.getClauses();
            buffer.append(Keywords.cpASSIGN);
            buffer.append(Keywords.cpLBRACE);
            int i = 0;
            while (i < initializers.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendInitClauseString(buffer, initializers[i]);
                ++i;
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpRBRACE);
        } else if (!(initializer instanceof ICASTDesignatedInitializer)) {
            if (initializer instanceof ICPPASTConstructorInitializer) {
                ICPPASTConstructorInitializer constructorInitializer = (ICPPASTConstructorInitializer)initializer;
                IASTInitializerClause[] clauses = constructorInitializer.getArguments();
                buffer.append(Keywords.cpLPAREN);
                int i = 0;
                while (i < clauses.length) {
                    if (i > 0) {
                        buffer.append(COMMA_SPACE);
                    }
                    ASTStringUtil.appendInitClauseString(buffer, clauses[i]);
                    ++i;
                }
                ASTStringUtil.trimRight(buffer);
                buffer.append(Keywords.cpRPAREN);
            } else if (initializer != null) assert (false) : "TODO: handle " + initializer.getClass().getName();
        }
        return buffer;
    }

    private static StringBuilder appendInitClauseString(StringBuilder buffer, IASTInitializerClause initializerClause) {
        if (initializerClause instanceof IASTExpression) {
            return ASTStringUtil.appendExpressionString(buffer, (IASTExpression)initializerClause);
        }
        if (initializerClause instanceof IASTInitializer) {
            return ASTStringUtil.appendInitializerString(buffer, (IASTInitializer)((Object)initializerClause));
        }
        return buffer;
    }

    private static StringBuilder appendTypeIdString(StringBuilder buffer, IASTTypeId typeId) {
        ASTStringUtil.appendDeclSpecifierString(buffer, typeId.getDeclSpecifier());
        ASTStringUtil.appendDeclaratorString(buffer, typeId.getAbstractDeclarator(), false, null);
        if (typeId instanceof ICPPASTTypeId && ((ICPPASTTypeId)typeId).isPackExpansion()) {
            buffer.append(Keywords.cpELLIPSIS);
        }
        return buffer;
    }

    private static StringBuilder trimRight(StringBuilder buffer) {
        int length = buffer.length();
        while (length > 0 && buffer.charAt(length - 1) == ' ') {
            --length;
        }
        buffer.setLength(length);
        return buffer;
    }

    private static StringBuilder appendArrayQualifiersString(StringBuilder buffer, IASTArrayDeclarator declarator) {
        IASTArrayModifier[] modifiers = declarator.getArrayModifiers();
        int count = modifiers.length;
        int i = 0;
        while (i < count) {
            buffer.append(Keywords.cpLBRACKET).append(Keywords.cpRBRACKET);
            ++i;
        }
        return buffer;
    }

    private static StringBuilder appendPointerOperatorsString(StringBuilder buffer, IASTPointerOperator[] pointerOperators) {
        IASTPointerOperator[] iASTPointerOperatorArray = pointerOperators;
        int n = pointerOperators.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointerOperator = iASTPointerOperatorArray[n2];
            if (pointerOperator instanceof IASTPointer) {
                IASTPointer pointer = (IASTPointer)pointerOperator;
                if (pointer instanceof ICPPASTPointerToMember) {
                    ICPPASTPointerToMember pointerToMember = (ICPPASTPointerToMember)pointer;
                    ASTStringUtil.appendQualifiedNameString(buffer, pointerToMember.getName());
                }
                buffer.append(Keywords.cpSTAR);
                if (pointer.isConst()) {
                    buffer.append(' ').append("const");
                }
                if (pointer.isVolatile()) {
                    buffer.append(' ').append("volatile");
                }
                if (pointer.isRestrict()) {
                    buffer.append(' ').append("restrict");
                }
            } else if (pointerOperator instanceof ICPPASTReferenceOperator) {
                buffer.append(Keywords.cpAMPER);
            }
            ++n2;
        }
        return buffer;
    }

    private static StringBuilder appendParameterSignatureString(StringBuilder buffer, IASTFunctionDeclarator functionDeclarator) {
        if (functionDeclarator instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator standardFunctionDecl = (IASTStandardFunctionDeclarator)functionDeclarator;
            IASTParameterDeclaration[] parameters = standardFunctionDecl.getParameters();
            boolean takesVarArgs = standardFunctionDecl.takesVarArgs();
            buffer.append(Keywords.cpLPAREN);
            int i = 0;
            while (i < parameters.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendParameterDeclarationString(buffer, parameters[i]);
                ++i;
            }
            if (takesVarArgs) {
                if (parameters.length > 0) {
                    buffer.append(COMMA_SPACE);
                }
                buffer.append(Keywords.cpELLIPSIS);
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpRPAREN);
        } else if (functionDeclarator instanceof ICASTKnRFunctionDeclarator) {
            buffer.append(Keywords.cpLPAREN);
            ICASTKnRFunctionDeclarator knrDeclarator = (ICASTKnRFunctionDeclarator)functionDeclarator;
            IASTName[] names = knrDeclarator.getParameterNames();
            int i = 0;
            while (i < names.length) {
                IASTDeclarator declaratorForParameterName;
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                if (names[i] != null && (declaratorForParameterName = knrDeclarator.getDeclaratorForParameterName(names[i])) != null) {
                    ASTStringUtil.appendSignatureString(buffer, declaratorForParameterName);
                }
                ++i;
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpRPAREN);
        }
        return buffer;
    }

    private static StringBuilder appendParameterDeclarationString(StringBuilder buffer, IASTParameterDeclaration parameter) {
        IASTDeclarator declarator;
        IASTDeclSpecifier declSpecifier = parameter.getDeclSpecifier();
        if (declSpecifier != null) {
            ASTStringUtil.appendDeclSpecifierString(buffer, declSpecifier);
            ASTStringUtil.trimRight(buffer);
        }
        if ((declarator = parameter.getDeclarator()) != null) {
            ASTStringUtil.appendDeclaratorString(buffer, declarator, false, null);
            ASTStringUtil.appendInitializerString(buffer, declarator.getInitializer());
        }
        return buffer;
    }

    private static StringBuilder appendDeclSpecifierString(StringBuilder buffer, IASTDeclSpecifier declSpecifier) {
        if (declSpecifier.isConst()) {
            buffer.append("const").append(' ');
        }
        if (declSpecifier.isVolatile()) {
            buffer.append("volatile").append(' ');
        }
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier compositeTypeSpec = (IASTCompositeTypeSpecifier)declSpecifier;
            int key = compositeTypeSpec.getKey();
            switch (key) {
                case 1: {
                    buffer.append("struct").append(' ');
                    break;
                }
                case 2: {
                    buffer.append("union").append(' ');
                    break;
                }
                case 3: {
                    buffer.append("class").append(' ');
                }
            }
            ASTStringUtil.appendQualifiedNameString(buffer, compositeTypeSpec.getName());
        } else if (declSpecifier instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elaboratedTypeSpec = (IASTElaboratedTypeSpecifier)declSpecifier;
            switch (elaboratedTypeSpec.getKind()) {
                case 0: {
                    buffer.append("enum").append(' ');
                    break;
                }
                case 1: {
                    buffer.append("struct").append(' ');
                    break;
                }
                case 2: {
                    buffer.append("union").append(' ');
                    break;
                }
                case 3: {
                    buffer.append("class").append(' ');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ASTStringUtil.appendQualifiedNameString(buffer, elaboratedTypeSpec.getName());
        } else if (declSpecifier instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumerationSpec = (IASTEnumerationSpecifier)declSpecifier;
            buffer.append("enum").append(' ');
            ASTStringUtil.appendQualifiedNameString(buffer, enumerationSpec.getName());
        } else if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier simpleDeclSpec = (IASTSimpleDeclSpecifier)declSpecifier;
            if (simpleDeclSpec.isSigned()) {
                buffer.append("signed").append(' ');
            }
            if (simpleDeclSpec.isUnsigned()) {
                buffer.append("unsigned").append(' ');
            }
            if (simpleDeclSpec.isShort()) {
                buffer.append("short").append(' ');
            }
            if (simpleDeclSpec.isLong()) {
                buffer.append("long").append(' ');
            }
            if (simpleDeclSpec.isLongLong()) {
                buffer.append("long long").append(' ');
            }
            if (simpleDeclSpec.isComplex()) {
                buffer.append("_Complex").append(' ');
            }
            if (simpleDeclSpec.isImaginary()) {
                buffer.append("_Imaginary").append(' ');
            }
            switch (simpleDeclSpec.getType()) {
                case 1: {
                    buffer.append("void").append(' ');
                    break;
                }
                case 2: {
                    buffer.append("char").append(' ');
                    break;
                }
                case 3: {
                    buffer.append("int").append(' ');
                    break;
                }
                case 13: {
                    buffer.append(GCCKeywords.cp__int128).append(' ');
                    break;
                }
                case 4: {
                    buffer.append("float").append(' ');
                    break;
                }
                case 5: {
                    buffer.append("double").append(' ');
                    break;
                }
                case 14: {
                    buffer.append(GCCKeywords.cp__float128).append(' ');
                    break;
                }
                case 6: {
                    if (simpleDeclSpec instanceof ICASTSimpleDeclSpecifier) {
                        buffer.append(Keywords.cBOOL).append(' ');
                        break;
                    }
                    buffer.append("bool").append(' ');
                    break;
                }
                case 7: {
                    buffer.append("wchar_t").append(' ');
                    break;
                }
                case 11: {
                    buffer.append("char16_t").append(' ');
                    break;
                }
                case 12: {
                    buffer.append("char32_t").append(' ');
                }
            }
        } else if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            IASTNamedTypeSpecifier namedTypeSpec = (IASTNamedTypeSpecifier)declSpecifier;
            ASTStringUtil.appendQualifiedNameString(buffer, namedTypeSpec.getName());
        }
        return buffer;
    }

    private static StringBuilder appendQualifiedNameString(StringBuilder buffer, IASTName name) {
        return ASTStringUtil.appendNameString(buffer, name, true);
    }

    private static StringBuilder appendDecltypeSpecifier(StringBuilder buffer, ICPPASTDecltypeSpecifier decltypeSpec) {
        buffer.append("decltype");
        buffer.append(Keywords.cpLPAREN);
        ASTStringUtil.appendExpressionString(buffer, decltypeSpec.getDecltypeExpression());
        buffer.append(Keywords.cpRPAREN);
        return buffer;
    }

    private static StringBuilder appendQualifiedNameString(StringBuilder buffer, ICPPASTNameSpecifier nameSpec) {
        if (nameSpec instanceof IASTName) {
            ASTStringUtil.appendQualifiedNameString(buffer, (IASTName)((Object)nameSpec));
        } else if (nameSpec instanceof ICPPASTDecltypeSpecifier) {
            ASTStringUtil.appendDecltypeSpecifier(buffer, (ICPPASTDecltypeSpecifier)nameSpec);
        }
        return buffer;
    }

    private static StringBuilder appendSimpleNameString(StringBuilder buffer, IASTName name) {
        return ASTStringUtil.appendNameString(buffer, name, false);
    }

    private static StringBuilder appendNameString(StringBuilder buffer, IASTName name, boolean qualified) {
        if (name instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qualifiedName = (ICPPASTQualifiedName)name;
            if (qualified) {
                ICPPASTNameSpecifier[] segments = qualifiedName.getAllSegments();
                int i = 0;
                while (i < segments.length) {
                    if (i > 0) {
                        buffer.append(Keywords.cpCOLONCOLON);
                    }
                    ASTStringUtil.appendQualifiedNameString(buffer, segments[i]);
                    ++i;
                }
            } else {
                buffer.append(qualifiedName.getLastName());
            }
        } else if (name instanceof ICPPASTTemplateId) {
            ICPPASTTemplateId templateId = (ICPPASTTemplateId)name;
            ASTStringUtil.appendQualifiedNameString(buffer, templateId.getTemplateName());
            IASTNode[] templateArguments = templateId.getTemplateArguments();
            buffer.append(Keywords.cpLT);
            int i = 0;
            while (i < templateArguments.length) {
                IASTNode argument;
                if (i > 0) {
                    buffer.append(Keywords.cpCOMMA);
                }
                if ((argument = templateArguments[i]) instanceof IASTTypeId) {
                    ASTStringUtil.appendTypeIdString(buffer, (IASTTypeId)argument);
                } else if (argument instanceof IASTExpression) {
                    IASTExpression expression = (IASTExpression)argument;
                    ASTStringUtil.appendExpressionString(buffer, expression);
                }
                ASTStringUtil.trimRight(buffer);
                ++i;
            }
            buffer.append(Keywords.cpGT);
        } else if (name != null) {
            buffer.append(name.getSimpleID());
        }
        return buffer;
    }

    private static StringBuilder appendTemplateParameterString(StringBuilder buffer, ICPPASTTemplateParameter parameter) {
        if (parameter instanceof ICPPASTParameterDeclaration) {
            ASTStringUtil.appendParameterDeclarationString(buffer, (ICPPASTParameterDeclaration)parameter);
        } else if (parameter instanceof ICPPASTSimpleTypeTemplateParameter) {
            ICPPASTSimpleTypeTemplateParameter simpletypeParameter = (ICPPASTSimpleTypeTemplateParameter)parameter;
            IASTName name = simpletypeParameter.getName();
            if (name != null) {
                ASTStringUtil.appendSimpleNameString(buffer, name);
            } else {
                int type = simpletypeParameter.getParameterType();
                switch (type) {
                    case 1: {
                        buffer.append("class");
                        break;
                    }
                    case 2: {
                        buffer.append("typename");
                    }
                }
            }
        } else if (parameter instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedTypeParameter = (ICPPASTTemplatedTypeTemplateParameter)parameter;
            ICPPASTTemplateParameter[] subParameters = templatedTypeParameter.getTemplateParameters();
            buffer.append("template").append(Keywords.cpLT);
            int i = 0;
            while (i < subParameters.length) {
                ICPPASTTemplateParameter templateParameter = subParameters[i];
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendTemplateParameterString(buffer, templateParameter);
                ++i;
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpGT);
        }
        return buffer;
    }

    private static StringBuilder appendExpressionString(StringBuilder buffer, IASTExpression expression) {
        if (expression instanceof IASTIdExpression) {
            IASTIdExpression idExpression = (IASTIdExpression)expression;
            return ASTStringUtil.appendQualifiedNameString(buffer, idExpression.getName());
        }
        if (expression instanceof IASTExpressionList) {
            IASTExpressionList expressionList = (IASTExpressionList)expression;
            IASTExpression[] expressions = expressionList.getExpressions();
            int i = 0;
            while (i < expressions.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendExpressionString(buffer, expressions[i]);
                ++i;
            }
            return buffer;
        }
        if (expression instanceof ICPPASTSimpleTypeConstructorExpression) {
            ICPPASTSimpleTypeConstructorExpression typeCast = (ICPPASTSimpleTypeConstructorExpression)expression;
            ASTStringUtil.appendDeclSpecifierString(buffer, typeCast.getDeclSpecifier());
            ASTStringUtil.trimRight(buffer);
            return ASTStringUtil.appendInitializerString(buffer, typeCast.getInitializer());
        }
        if (expression instanceof IASTArraySubscriptExpression) {
            return ASTStringUtil.appendArraySubscriptExpression(buffer, (IASTArraySubscriptExpression)expression);
        }
        if (expression instanceof IASTBinaryExpression) {
            return ASTStringUtil.appendBinaryExpression(buffer, (IASTBinaryExpression)expression);
        }
        if (expression instanceof IASTCastExpression) {
            return ASTStringUtil.appendCastExpression(buffer, (IASTCastExpression)expression);
        }
        if (expression instanceof IASTConditionalExpression) {
            return ASTStringUtil.appendConditionalExpression(buffer, (IASTConditionalExpression)expression);
        }
        if (expression instanceof IASTExpressionList) {
            return ASTStringUtil.appendExpressionList(buffer, (IASTExpressionList)expression);
        }
        if (expression instanceof IASTFieldReference) {
            return ASTStringUtil.appendFieldReference(buffer, (IASTFieldReference)expression);
        }
        if (expression instanceof IASTFunctionCallExpression) {
            return ASTStringUtil.appendFunctionCallExpression(buffer, (IASTFunctionCallExpression)expression);
        }
        if (expression instanceof IASTLiteralExpression) {
            return ASTStringUtil.appendLiteralExpression(buffer, (IASTLiteralExpression)expression);
        }
        if (expression instanceof IASTTypeIdExpression) {
            return ASTStringUtil.appendTypeIdExpression(buffer, (IASTTypeIdExpression)expression);
        }
        if (expression instanceof IASTUnaryExpression) {
            return ASTStringUtil.appendUnaryExpression(buffer, (IASTUnaryExpression)expression);
        }
        if (expression instanceof ICASTTypeIdInitializerExpression) {
            return ASTStringUtil.appendTypeIdInitializerExpression(buffer, (ICASTTypeIdInitializerExpression)expression);
        }
        if (expression instanceof ICPPASTDeleteExpression) {
            return ASTStringUtil.appendDeleteExpression(buffer, (ICPPASTDeleteExpression)expression);
        }
        if (expression instanceof ICPPASTNewExpression) {
            return ASTStringUtil.appendNewExpression(buffer, (ICPPASTNewExpression)expression);
        }
        if (expression instanceof IGNUASTCompoundStatementExpression) {
            return ASTStringUtil.appendCompoundStatementExpression(buffer, (IGNUASTCompoundStatementExpression)expression);
        }
        if (expression instanceof ICPPASTPackExpansionExpression) {
            return ASTStringUtil.appendPackExpansionExpression(buffer, (ICPPASTPackExpansionExpression)expression);
        }
        return buffer;
    }

    private static StringBuilder appendArraySubscriptExpression(StringBuilder buffer, IASTArraySubscriptExpression expression) {
        ASTStringUtil.appendExpressionString(buffer, expression.getArrayExpression());
        buffer.append(Keywords.cpLBRACKET);
        ASTStringUtil.appendInitClauseString(buffer, expression.getArgument());
        return buffer.append(Keywords.cpRBRACKET);
    }

    private static StringBuilder appendCastExpression(StringBuilder buffer, IASTCastExpression expression) {
        if (expression.getOperator() == 0) {
            buffer.append(Keywords.cpLPAREN);
            ASTStringUtil.appendTypeIdString(buffer, expression.getTypeId());
            buffer.append(Keywords.cpRPAREN);
            return ASTStringUtil.appendExpressionString(buffer, expression.getOperand());
        }
        buffer.append(ASTStringUtil.getCastOperatorString(expression));
        buffer.append(Keywords.cpLT);
        ASTStringUtil.appendTypeIdString(buffer, expression.getTypeId());
        ASTStringUtil.trimRight(buffer);
        buffer.append(Keywords.cpGT);
        buffer.append(Keywords.cpLPAREN);
        ASTStringUtil.appendExpressionString(buffer, expression.getOperand());
        return buffer.append(Keywords.cpRPAREN);
    }

    private static StringBuilder appendFieldReference(StringBuilder buffer, IASTFieldReference expression) {
        ASTStringUtil.appendExpressionString(buffer, expression.getFieldOwner());
        buffer.append(expression.isPointerDereference() ? Keywords.cpARROW : Keywords.cpDOT);
        return ASTStringUtil.appendNameString(buffer, expression.getFieldName(), true);
    }

    private static StringBuilder appendFunctionCallExpression(StringBuilder buffer, IASTFunctionCallExpression expression) {
        ASTStringUtil.appendExpressionString(buffer, expression.getFunctionNameExpression());
        buffer.append(Keywords.cpLPAREN);
        IASTInitializerClause[] clauses = expression.getArguments();
        int i = 0;
        while (i < clauses.length) {
            if (i > 0) {
                buffer.append(COMMA_SPACE);
            }
            ASTStringUtil.appendInitClauseString(buffer, clauses[i]);
            ++i;
        }
        return buffer.append(Keywords.cpRPAREN);
    }

    private static StringBuilder appendTypeIdInitializerExpression(StringBuilder buffer, ICASTTypeIdInitializerExpression expression) {
        buffer.append(Keywords.cpLPAREN);
        ASTStringUtil.appendTypeIdString(buffer, expression.getTypeId());
        buffer.append(Keywords.cpRPAREN);
        return ASTStringUtil.appendInitializerString(buffer, expression.getInitializer());
    }

    private static StringBuilder appendDeleteExpression(StringBuilder buffer, ICPPASTDeleteExpression expression) {
        buffer.append("delete");
        buffer.append(SPACE);
        return ASTStringUtil.appendExpressionString(buffer, expression.getOperand());
    }

    private static StringBuilder appendCompoundStatementExpression(StringBuilder buffer, IGNUASTCompoundStatementExpression expression) {
        buffer.append(Keywords.cpLPAREN).append(Keywords.cpLBRACE);
        buffer.append(Keywords.cpELLIPSIS);
        return buffer.append(Keywords.cpRBRACE).append(Keywords.cpRPAREN);
    }

    private static StringBuilder appendTypeIdExpression(StringBuilder buffer, IASTTypeIdExpression expression) {
        buffer.append(ASTStringUtil.getTypeIdExpressionOperator(expression));
        buffer.append(Keywords.cpLPAREN);
        ASTStringUtil.appendTypeIdString(buffer, expression.getTypeId());
        ASTStringUtil.trimRight(buffer);
        return buffer.append(Keywords.cpRPAREN);
    }

    private static StringBuilder appendExpressionList(StringBuilder buffer, IASTExpressionList expression) {
        IASTExpression[] exps = expression.getExpressions();
        if (exps != null) {
            int i = 0;
            while (i < exps.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendExpressionString(buffer, exps[i]);
                ++i;
            }
        }
        return buffer;
    }

    private static StringBuilder appendLiteralExpression(StringBuilder buffer, IASTLiteralExpression expression) {
        return buffer.append(expression.toString());
    }

    private static StringBuilder appendConditionalExpression(StringBuilder buffer, IASTConditionalExpression expression) {
        ASTStringUtil.appendExpressionString(buffer, expression.getLogicalConditionExpression());
        buffer.append(SPACE);
        buffer.append(Keywords.cpQUESTION);
        buffer.append(SPACE);
        ASTStringUtil.appendExpressionString(buffer, expression.getPositiveResultExpression());
        buffer.append(SPACE);
        buffer.append(Keywords.cpCOLON);
        buffer.append(SPACE);
        return ASTStringUtil.appendExpressionString(buffer, expression.getNegativeResultExpression());
    }

    private static StringBuilder appendNewExpression(StringBuilder buffer, ICPPASTNewExpression expression) {
        buffer.append("new");
        buffer.append(SPACE);
        IASTInitializerClause[] args = expression.getPlacementArguments();
        if (args != null) {
            buffer.append(Keywords.cpLPAREN);
            int i = 0;
            while (i < args.length) {
                if (i != 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendInitClauseString(buffer, args[i]);
                ++i;
            }
            buffer.append(Keywords.cpRPAREN);
        }
        ASTStringUtil.appendTypeIdString(buffer, expression.getTypeId());
        return ASTStringUtil.appendInitializerString(buffer, expression.getInitializer());
    }

    private static StringBuilder appendBinaryExpression(StringBuilder buffer, IASTBinaryExpression expression) {
        ASTStringUtil.appendExpressionString(buffer, expression.getOperand1());
        buffer.append(SPACE);
        buffer.append(ASTStringUtil.getBinaryOperatorString(expression));
        buffer.append(SPACE);
        return ASTStringUtil.appendExpressionString(buffer, expression.getOperand2());
    }

    private static StringBuilder appendUnaryExpression(StringBuilder buffer, IASTUnaryExpression expression) {
        boolean postOperator = false;
        boolean primaryBracketed = false;
        switch (expression.getOperator()) {
            case 9: 
            case 10: {
                postOperator = true;
                break;
            }
            case 11: {
                primaryBracketed = true;
                break;
            }
            default: {
                postOperator = false;
            }
        }
        if (!postOperator && !primaryBracketed) {
            buffer.append(ASTStringUtil.getUnaryOperatorString(expression));
        }
        switch (expression.getOperator()) {
            case 8: 
            case 12: 
            case 13: 
            case 17: {
                buffer.append(SPACE);
            }
        }
        if (primaryBracketed) {
            buffer.append(Keywords.cpLPAREN);
        }
        buffer.append(ASTStringUtil.getExpressionString(expression.getOperand()));
        if (primaryBracketed) {
            buffer.append(Keywords.cpRPAREN);
        }
        if (postOperator && !primaryBracketed) {
            buffer.append(ASTStringUtil.getUnaryOperatorString(expression));
        }
        return buffer;
    }

    public static String getCastOperatorString(IASTCastExpression expression) {
        int op = expression.getOperator();
        switch (op) {
            case 4: {
                return "const_cast";
            }
            case 1: {
                return "dynamic_cast";
            }
            case 3: {
                return "reinterpret_cast";
            }
            case 2: {
                return "static_cast";
            }
        }
        return "";
    }

    public static char[] getUnaryOperatorString(IASTUnaryExpression ue) {
        int op = ue.getOperator();
        switch (op) {
            case 17: {
                return Keywords.cNOEXCEPT;
            }
            case 12: {
                return Keywords.cTHROW;
            }
            case 13: {
                return Keywords.cTYPEID;
            }
            case 15: {
                return Keywords.cALIGNOF;
            }
            case 5: {
                return Keywords.cpAMPER;
            }
            case 3: {
                return Keywords.cpMINUS;
            }
            case 7: {
                return Keywords.cpNOT;
            }
            case 2: {
                return Keywords.cpPLUS;
            }
            case 1: 
            case 10: {
                return Keywords.cpDECR;
            }
            case 0: 
            case 9: {
                return Keywords.cpINCR;
            }
            case 8: {
                return Keywords.cSIZEOF;
            }
            case 16: {
                return Keywords.cSIZEOFPACK;
            }
            case 4: {
                return Keywords.cpSTAR;
            }
            case 6: {
                return Keywords.cpCOMPL;
            }
        }
        return CharArrayUtils.EMPTY;
    }

    public static char[] getBinaryOperatorString(IASTBinaryExpression be) {
        switch (be.getOperator()) {
            case 1: {
                return Keywords.cpSTAR;
            }
            case 2: {
                return Keywords.cpDIV;
            }
            case 3: {
                return Keywords.cpMOD;
            }
            case 4: {
                return Keywords.cpPLUS;
            }
            case 5: {
                return Keywords.cpMINUS;
            }
            case 6: {
                return Keywords.cpSHIFTL;
            }
            case 7: {
                return Keywords.cpSHIFTR;
            }
            case 8: {
                return Keywords.cpLT;
            }
            case 9: {
                return Keywords.cpGT;
            }
            case 10: {
                return Keywords.cpLTEQUAL;
            }
            case 11: {
                return Keywords.cpGTEQUAL;
            }
            case 12: {
                return Keywords.cpAMPER;
            }
            case 13: {
                return Keywords.cpXOR;
            }
            case 14: {
                return Keywords.cpBITOR;
            }
            case 15: {
                return Keywords.cpAND;
            }
            case 16: {
                return Keywords.cpOR;
            }
            case 17: {
                return Keywords.cpASSIGN;
            }
            case 18: {
                return Keywords.cpSTARASSIGN;
            }
            case 19: {
                return Keywords.cpDIVASSIGN;
            }
            case 20: {
                return Keywords.cpMODASSIGN;
            }
            case 21: {
                return Keywords.cpPLUSASSIGN;
            }
            case 22: {
                return Keywords.cpMINUSASSIGN;
            }
            case 23: {
                return Keywords.cpSHIFTLASSIGN;
            }
            case 24: {
                return Keywords.cpSHIFTRASSIGN;
            }
            case 25: {
                return Keywords.cpAMPERASSIGN;
            }
            case 26: {
                return Keywords.cpXORASSIGN;
            }
            case 27: {
                return Keywords.cpBITORASSIGN;
            }
            case 28: {
                return Keywords.cpEQUAL;
            }
            case 29: {
                return Keywords.cpNOTEQUAL;
            }
            case 32: {
                return Keywords.cpMAX;
            }
            case 33: {
                return Keywords.cpMIN;
            }
            case 31: {
                return Keywords.cpARROW;
            }
            case 30: {
                return Keywords.cpDOT;
            }
        }
        return CharArrayUtils.EMPTY;
    }

    private static String getTypeIdExpressionOperator(IASTTypeIdExpression expression) {
        switch (expression.getOperator()) {
            case 2: {
                return "alignof";
            }
            case 3: {
                return "typeof";
            }
            case 1: {
                return "typeid";
            }
            case 0: {
                return "sizeof";
            }
        }
        return "";
    }

    private static StringBuilder appendPackExpansionExpression(StringBuilder buffer, ICPPASTPackExpansionExpression expression) {
        ASTStringUtil.appendExpressionString(buffer, expression.getPattern());
        return buffer.append(Keywords.cpELLIPSIS);
    }
}

