/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.Assert;

public class CPPASTQualifiedName
extends CPPASTNameBase
implements ICPPASTQualifiedName,
ICPPASTCompletionContext {
    private ICPPASTNameSpecifier[] fQualifier;
    private int fQualifierPos = -1;
    private ICPPASTName fLastName;
    private boolean fIsFullyQualified;
    private char[] fSignature;

    @Deprecated
    public CPPASTQualifiedName() {
    }

    public CPPASTQualifiedName(ICPPASTName lastName) {
        this.setLastName(lastName);
    }

    @Override
    public CPPASTQualifiedName copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTQualifiedName copy(IASTNode.CopyStyle style) {
        CPPASTQualifiedName copy = new CPPASTQualifiedName();
        if (this.fLastName != null) {
            copy.addName(this.fLastName.copy(style));
        }
        ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = this.getQualifier();
        int n = iCPPASTNameSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTNameSpecifier nameSpecifier = iCPPASTNameSpecifierArray[n2];
            copy.addNameSpecifier(nameSpecifier == null ? null : nameSpecifier.copy(style));
            ++n2;
        }
        copy.setFullyQualified(this.fIsFullyQualified);
        return this.copy(copy, style);
    }

    @Override
    public final IBinding resolvePreBinding() {
        return this.getLastName().resolvePreBinding();
    }

    @Override
    public IBinding resolveBinding() {
        IASTName lastName = this.getLastName();
        return lastName == null ? null : lastName.resolveBinding();
    }

    @Override
    public final IBinding getPreBinding() {
        return this.getLastName().getPreBinding();
    }

    @Override
    public IBinding getBinding() {
        return this.getLastName().getBinding();
    }

    @Override
    public void setBinding(IBinding binding) {
        this.getLastName().setBinding(binding);
    }

    @Override
    public void addName(IASTName name) {
        if (this.fLastName != null) {
            this.addNameSpecifier(this.fLastName);
        }
        this.setLastName((ICPPASTName)name);
    }

    @Override
    public void setLastName(ICPPASTName lastName) {
        this.assertNotFrozen();
        assert (!(lastName instanceof ICPPASTQualifiedName));
        this.fLastName = lastName;
        this.fLastName.setParent(this);
        this.fLastName.setPropertyInParent(SEGMENT_NAME);
    }

    @Override
    public void addNameSpecifier(ICPPASTNameSpecifier nameSpecifier) {
        this.assertNotFrozen();
        assert (!(nameSpecifier instanceof ICPPASTQualifiedName));
        if (nameSpecifier != null) {
            this.fQualifier = ArrayUtil.appendAt(ICPPASTNameSpecifier.class, this.fQualifier, ++this.fQualifierPos, nameSpecifier);
            nameSpecifier.setParent(this);
            nameSpecifier.setPropertyInParent(SEGMENT_NAME);
        }
    }

    @Override
    public ICPPASTNameSpecifier[] getQualifier() {
        if (this.fQualifierPos < 0) {
            return ICPPASTNameSpecifier.EMPTY_NAME_SPECIFIER_ARRAY;
        }
        this.fQualifier = ArrayUtil.trimAt(ICPPASTNameSpecifier.class, this.fQualifier, this.fQualifierPos);
        return this.fQualifier;
    }

    @Override
    public ICPPASTNameSpecifier[] getAllSegments() {
        ICPPASTNameSpecifier[] result = new ICPPASTNameSpecifier[this.fQualifierPos + (this.fLastName == null ? 1 : 2)];
        int idx = 0;
        ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = this.getQualifier();
        int n = iCPPASTNameSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTNameSpecifier nameSpecifier = iCPPASTNameSpecifierArray[n2];
            result[idx++] = nameSpecifier;
            ++n2;
        }
        if (this.fLastName != null) {
            result[this.fQualifierPos + 1] = this.fLastName;
        }
        return result;
    }

    @Override
    @Deprecated
    public IASTName[] getNames() {
        IASTName[] result = new IASTName[this.fQualifierPos + (this.fLastName == null ? 1 : 2)];
        int idx = 0;
        ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = this.getQualifier();
        int n = iCPPASTNameSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTNameSpecifier nameSpecifier = iCPPASTNameSpecifierArray[n2];
            if (!(nameSpecifier instanceof IASTName)) {
                throw new UnsupportedOperationException("Can't use getNames() on a qualified name that includes a decltype-specifier. Use getQualifier() and getLastName() instead.");
            }
            result[idx++] = (IASTName)((Object)nameSpecifier);
            ++n2;
        }
        if (this.fLastName != null) {
            result[this.fQualifierPos + 1] = this.fLastName;
        }
        return result;
    }

    @Override
    public IASTName getLastName() {
        return this.fLastName;
    }

    @Override
    public char[] getSimpleID() {
        return this.fLastName.getSimpleID();
    }

    @Override
    public char[] getLookupKey() {
        return this.fLastName.getLookupKey();
    }

    @Override
    public char[] toCharArray() {
        if (this.fSignature == null) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i <= this.fQualifierPos) {
                if (i > 0 || this.fIsFullyQualified) {
                    buf.append(Keywords.cpCOLONCOLON);
                }
                buf.append(this.fQualifier[i].toCharArray());
                ++i;
            }
            if (this.fQualifierPos >= 0 || this.fIsFullyQualified) {
                buf.append(Keywords.cpCOLONCOLON);
            }
            buf.append(this.fLastName.toCharArray());
            int len = buf.length();
            this.fSignature = new char[len];
            buf.getChars(0, len, this.fSignature, 0);
        }
        return this.fSignature;
    }

    @Override
    public boolean isFullyQualified() {
        return this.fIsFullyQualified;
    }

    @Override
    public void setFullyQualified(boolean isFullyQualified) {
        this.assertNotFrozen();
        this.fIsFullyQualified = isFullyQualified;
    }

    @Deprecated
    public void setSignature(String signature) {
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = this.getQualifier();
        int n = iCPPASTNameSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTNameSpecifier nameSpecifier = iCPPASTNameSpecifierArray[n2];
            if (!nameSpecifier.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (this.fLastName != null && this.fLastName.getLookupKey().length > 0 && !this.fLastName.accept(action)) {
            return false;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    @Override
    public int getRoleForName(IASTName n) {
        IASTNode p;
        int i = 0;
        while (i <= this.fQualifierPos) {
            if (this.fQualifier[i] == n) {
                return 1;
            }
            ++i;
        }
        if (this.getLastName() == n && (p = this.getParent()) instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)p)).getRoleForName(this);
        }
        return 3;
    }

    @Override
    public boolean isConversionOrOperator() {
        IASTName tempName;
        IASTName lastName = this.getLastName();
        if (lastName instanceof ICPPASTConversionName || lastName instanceof ICPPASTOperatorName) {
            return true;
        }
        return lastName instanceof ICPPASTTemplateId && ((tempName = ((ICPPASTTemplateId)lastName).getTemplateName()) instanceof ICPPASTConversionName || tempName instanceof ICPPASTOperatorName);
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding binding;
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        if (this.fQualifierPos >= 0 && (binding = this.fQualifier[this.fQualifierPos].resolveBinding()) instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)binding;
            boolean isDeclaration = this.getParent().getParent() instanceof IASTSimpleDeclaration;
            List<IBinding> filtered = this.filterClassScopeBindings(classType, bindings, isDeclaration);
            if (isDeclaration && CPPASTQualifiedName.nameMatches(classType.getNameCharArray(), n.getLookupKey(), isPrefix)) {
                ICPPConstructor[] constructors = ClassTypeHelper.getConstructors(classType, n);
                int i = 0;
                while (i < constructors.length) {
                    if (!constructors[i].isImplicit()) {
                        filtered.add(constructors[i]);
                    }
                    ++i;
                }
            }
            return filtered.toArray(new IBinding[filtered.size()]);
        }
        return bindings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canBeFieldAccess(ICPPClassType baseClass) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTFieldReference) {
            return true;
        }
        if (!(parent instanceof IASTIdExpression)) return false;
        IScope scope = CPPVisitor.getContainingScope(this);
        try {
            while (true) {
                ICPPClassType classType;
                if (scope == null) {
                    return false;
                }
                if (scope instanceof ICPPClassScope && SemanticUtil.calculateInheritanceDepth(classType = ((ICPPClassScope)scope).getClassType(), baseClass, this) >= 0) {
                    return true;
                }
                scope = scope.getParent();
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    private List<IBinding> filterClassScopeBindings(ICPPClassType classType, IBinding[] bindings, boolean isDeclaration) {
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        boolean canBeFieldAccess = this.canBeFieldAccess(classType);
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IBinding binding;
                block4: {
                    IType type;
                    ICPPMethod method;
                    block3: {
                        binding = iBindingArray[n2];
                        if (!(binding instanceof IField)) break block3;
                        IField field = (IField)binding;
                        if (canBeFieldAccess || field.isStatic()) break block4;
                        break block5;
                    }
                    if (binding instanceof ICPPMethod ? (method = (ICPPMethod)binding).isImplicit() || !isDeclaration && (method.isDestructor() || method instanceof ICPPConstructor || !canBeFieldAccess && !method.isStatic()) : (binding instanceof IEnumerator || binding instanceof IEnumeration ? isDeclaration : binding instanceof IType && (type = (IType)((Object)binding)).isSameType(classType))) break block5;
                }
                filtered.add(binding);
            }
            ++n2;
        }
        return filtered;
    }

    private static boolean nameMatches(char[] potential, char[] name, boolean isPrefix) {
        if (isPrefix) {
            return ContentAssistMatcherFactory.getInstance().match(name, potential);
        }
        return CharArrayUtils.equals(potential, name);
    }

    @Override
    protected IBinding createIntermediateBinding() {
        Assert.isLegal((boolean)false);
        return null;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

