/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointContext;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblySelection;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public abstract class AbstractDisassemblyBreakpointsTarget
implements IToggleBreakpointsTargetExtension2,
IToggleBreakpointsTargetCExtension {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IDisassemblySelection disassemblySelection;
        int line;
        IBreakpoint[] bp;
        assert (part instanceof IDisassemblyPart && selection instanceof ITextSelection);
        if (!(selection instanceof IDisassemblySelection)) {
            selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
        }
        if ((bp = this.getBreakpointsAtLine((IDisassemblyPart)part, line = (disassemblySelection = (IDisassemblySelection)selection).getStartLine())) == null || bp.length == 0) {
            this.insertBreakpoint(part, disassemblySelection, false);
        } else {
            int i = 0;
            while (i < bp.length) {
                bp[i].delete();
                ++i;
            }
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return part instanceof IDisassemblyPart && selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public boolean canToggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
        IDisassemblySelection disassemblySelection;
        int line;
        IBreakpoint[] bp;
        boolean mod2;
        assert (part instanceof IDisassemblyPart && selection instanceof ITextSelection);
        boolean mod1 = event != null && (event.stateMask & SWT.MOD1) > 0;
        boolean bl = mod2 = event != null && (event.stateMask & SWT.MOD2) > 0;
        if (!(selection instanceof IDisassemblySelection)) {
            selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
        }
        if ((bp = this.getBreakpointsAtLine((IDisassemblyPart)part, line = (disassemblySelection = (IDisassemblySelection)selection).getStartLine())) == null || bp.length == 0) {
            this.insertBreakpoint(part, disassemblySelection, mod1);
        } else {
            if (mod2) {
                this.toggleBreakpointEnabled(bp[0]);
                return;
            }
            if (mod1 && bp[0] instanceof ICBreakpoint) {
                CDebugUIUtils.editBreakpointProperties((IWorkbenchPart)part, (ICBreakpoint)((ICBreakpoint)bp[0]));
                return;
            }
            int i = 0;
            while (i < bp.length) {
                bp[i].delete();
                ++i;
            }
        }
    }

    public boolean canCreateLineBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void createLineBreakpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
        assert (part instanceof IDisassemblyPart && selection instanceof ITextSelection);
        if (!(selection instanceof IDisassemblySelection)) {
            selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
        }
        IDisassemblySelection disassemblySelection = (IDisassemblySelection)selection;
        this.insertBreakpoint(part, disassemblySelection, true);
    }

    public boolean canCreateFunctionBreakpointInteractive(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void createFunctionBreakpointInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canCreateWatchpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void createWatchpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canCreateEventBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void createEventBreakpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    private void toggleBreakpointEnabled(IBreakpoint bp) {
        try {
            bp.setEnabled(!bp.isEnabled());
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((IStatus)e.getStatus());
        }
    }

    protected abstract void createLineBreakpoint(String var1, IResource var2, int var3) throws CoreException;

    protected void createLineBreakpointInteractive(IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        this.createLineBreakpoint(sourceHandle, resource, lineNumber);
    }

    protected abstract void createAddressBreakpoint(IResource var1, IAddress var2) throws CoreException;

    protected void createAddressBreakpointInteractive(IWorkbenchPart part, IResource resource, IAddress address) throws CoreException {
        this.createAddressBreakpoint(resource, address);
    }

    private IBreakpoint[] getBreakpointsAtLine(IDisassemblyPart part, int line) {
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
        IAnnotationModel annotationModel = part.getTextViewer().getAnnotationModel();
        IDocument document = part.getTextViewer().getDocument();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int bpLine;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || line != (bpLine = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    breakpoints.add(breakpoint);
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        IBreakpoint[] breakpointsArray = new IBreakpoint[breakpoints.size()];
        return breakpoints.toArray(breakpointsArray);
    }

    private void insertBreakpoint(IWorkbenchPart part, IDisassemblySelection selection, boolean interactive) throws CoreException {
        IAddress address = selection.getStartAddress();
        if (address == null) {
            return;
        }
        URI fileUri = selection.getSourceLocationURI();
        if (fileUri != null) {
            String filePath = null;
            IFile resource = selection.getSourceFile();
            if (resource != null) {
                IPath location = resource.getLocation();
                if (location == null) {
                    return;
                }
                filePath = location.toOSString();
            } else {
                resource = ResourcesPlugin.getWorkspace().getRoot();
                filePath = URIUtil.toPath((URI)fileUri).toOSString();
            }
            int srcLine = selection.getSourceLine();
            if (interactive) {
                this.createLineBreakpointInteractive(part, filePath, (IResource)resource, srcLine + 1);
            } else {
                this.createLineBreakpoint(filePath, (IResource)resource, srcLine + 1);
            }
        } else {
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            if (interactive) {
                this.createAddressBreakpointInteractive(part, (IResource)resource, address);
            } else {
                this.createAddressBreakpoint((IResource)resource, address);
            }
        }
    }

    protected void openBreakpointPropertiesDialog(ICBreakpoint bp, IWorkbenchPart part, IResource resource, Map<String, Object> attributes) {
        ISelection debugContext = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow()).getActiveContext(part.getSite().getId());
        CBreakpointContext bpContext = new CBreakpointContext(bp, debugContext, resource, attributes);
        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)part.getSite().getShell(), (IAdaptable)bpContext, null, null, null);
        if (dialog != null) {
            dialog.open();
        }
    }
}

