/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;

public class CreatedEvent
implements ICDICreatedEvent {
    Session session;
    ICDIObject source;

    public CreatedEvent(Session s, MIBreakpointCreatedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = this.session.getBreakpointManager();
        MISession miSession = bpoint.getMISession();
        int number = bpoint.getNumber();
        this.source = mgr.getBreakpoint(miSession, number);
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public CreatedEvent(Session s, MIVarCreatedEvent var) {
        this.session = s;
        VariableManager mgr = this.session.getVariableManager();
        MISession miSession = var.getMISession();
        String varName = var.getVarName();
        this.source = mgr.getVariable(miSession, varName);
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public CreatedEvent(Session s, MIRegisterCreatedEvent reg) {
        this.session = s;
        RegisterManager mgr = this.session.getRegisterManager();
        MISession miSession = reg.getMISession();
        int regno = reg.getNumber();
        this.source = mgr.getRegister(miSession, regno);
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public CreatedEvent(Session s, MIThreadCreatedEvent cthread) {
        this.session = s;
        MISession miSession = cthread.getMISession();
        Target target = this.session.getTarget(miSession);
        this.source = target.getThread(cthread.getId());
        if (this.source == null) {
            this.source = new CObject(target);
        }
    }

    public CreatedEvent(Session s, MIInferiorCreatedEvent inferior) {
        this.session = s;
        MISession miSession = inferior.getMISession();
        this.source = this.session.getTarget(miSession);
    }

    public CreatedEvent(Session s, MIMemoryCreatedEvent mblock) {
        this.session = s;
        MemoryManager mgr = this.session.getMemoryManager();
        MISession miSession = mblock.getMISession();
        MemoryBlock[] blocks = mgr.getMemoryBlocks(miSession);
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i].getStartAddress().equals(mblock.getAddress()) && blocks[i].getLength() == mblock.getLength()) {
                this.source = blocks[i];
                break;
            }
            ++i;
        }
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public CreatedEvent(Session s, MISharedLibCreatedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = this.session.getSharedLibraryManager();
        MISession miSession = slib.getMISession();
        String name = slib.getName();
        this.source = mgr.getSharedLibrary(miSession, name);
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public CreatedEvent(Session s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

