/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public class DSFSessionState {
    protected String m_sessionId;
    protected List<Object> m_sessionListeners;
    protected DsfServicesTracker m_servicesTracker;

    public DSFSessionState(String sessionId) {
        this.m_sessionId = sessionId;
        this.m_sessionListeners = new ArrayList<Object>();
        this.m_servicesTracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), this.m_sessionId);
    }

    public void dispose() {
        if (this.m_sessionId != null) {
            this.removeAllServiceEventListeners();
            this.m_sessionId = null;
            this.m_sessionListeners = null;
        }
        if (this.m_servicesTracker != null) {
            this.m_servicesTracker.dispose();
            this.m_servicesTracker = null;
        }
    }

    public String getSessionID() {
        return this.m_sessionId;
    }

    public void addServiceEventListener(Object listener) {
        final Object listener_f = listener;
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        session_f.addServiceEventListener(listener_f, null);
                        DSFSessionState.this.m_sessionListeners.add(listener_f);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    public void removeServiceEventListener(Object listener) {
        final Object listener_f = listener;
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (DSFSessionState.this.m_sessionListeners != null) {
                            session_f.removeServiceEventListener(listener_f);
                            DSFSessionState.this.m_sessionListeners.remove(listener_f);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    public void removeAllServiceEventListeners() {
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (DSFSessionState.this.m_sessionListeners != null) {
                            for (Object listener : DSFSessionState.this.m_sessionListeners) {
                                session_f.removeServiceEventListener(listener);
                            }
                            DSFSessionState.this.m_sessionListeners.clear();
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    protected DsfSession getDsfSession() {
        return DsfSession.getSession((String)this.m_sessionId);
    }

    public void execute(DsfRunnable runnable) {
        try {
            DsfSession session = this.getDsfSession();
            if (session != null) {
                session.getExecutor().execute((Runnable)runnable);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            System.err.println("DSFSessionState.execute(): session rejected execution request.");
        }
    }

    @ConfinedToDsfExecutor(value="getDsfSession().getExecutor()")
    public <V> V getService(Class<V> serviceClass) {
        return (V)(this.m_servicesTracker == null ? null : this.m_servicesTracker.getService(serviceClass));
    }
}

