/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableManagerToolChain;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuiltinSpecsDetector;

public abstract class ToolchainBuiltinSpecsDetector
extends AbstractBuiltinSpecsDetector {
    private static final String EMPTY_QUOTED_STRING = "\"\"";
    private Map<String, ITool> toolMap = new HashMap<String, ITool>();

    public abstract String getToolchainId();

    private ITool getTool(String languageId) {
        ITool tool;
        if (languageId == null) {
            return null;
        }
        if (this.currentCfgDescription == null && (tool = this.toolMap.get(languageId)) != null) {
            return tool;
        }
        String toolchainId = null;
        IToolChain toolchain = null;
        ITool tool2 = null;
        if (this.currentCfgDescription != null) {
            IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(this.currentCfgDescription);
            toolchain = cfg != null ? cfg.getToolChain() : null;
            String string = toolchainId = toolchain != null ? toolchain.getId() : null;
        }
        if (toolchain == null) {
            toolchainId = this.getToolchainId();
            toolchain = ManagedBuildManager.getExtensionToolChain(toolchainId);
        }
        while (toolchain != null) {
            tool2 = this.getTool(languageId, toolchain);
            if (tool2 != null) break;
            toolchain = toolchain.getSuperClass();
        }
        if (this.currentCfgDescription == null && tool2 != null) {
            this.toolMap.put(languageId, tool2);
        }
        if (tool2 == null) {
            ManagedBuilderCorePlugin.error("Unable to find tool in toolchain=" + toolchainId + " for language=" + languageId);
        }
        return tool2;
    }

    private ITool getTool(String languageId, IToolChain toolchain) {
        ITool[] tools;
        ITool[] iToolArray = tools = toolchain.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType[] inputTypes;
            ITool tool = iToolArray[n2];
            IInputType[] iInputTypeArray = inputTypes = tool.getInputTypes();
            int n3 = inputTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IInputType inType = iInputTypeArray[n4];
                String lang = inType.getLanguageId(tool);
                if (languageId.equals(lang)) {
                    return tool;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected String getCompilerCommand(String languageId) {
        String compilerCommand;
        ITool tool = this.getTool(languageId);
        String string = compilerCommand = tool != null ? tool.getToolCommand() : "";
        if (compilerCommand.isEmpty()) {
            ManagedBuilderCorePlugin.error("Unable to find compiler command in toolchain=" + this.getToolchainId());
        }
        return compilerCommand;
    }

    @Override
    protected String getSpecFileExtension(String languageId) {
        String[] srcFileExtensions;
        String ext = null;
        ITool tool = this.getTool(languageId);
        String[] stringArray = srcFileExtensions = tool != null ? tool.getAllInputExtensions() : null;
        if (srcFileExtensions != null && srcFileExtensions.length > 0) {
            ext = srcFileExtensions[0];
        }
        if (ext == null || ext.isEmpty()) {
            ManagedBuilderCorePlugin.error("Unable to find file extension for language " + languageId);
        }
        return ext;
    }

    @Override
    protected String getToolOptions(String languageId) {
        String flags = "";
        ITool tool = this.getTool(languageId);
        if (tool != null) {
            IOption[] options;
            IOption[] iOptionArray = options = tool.getOptions();
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                IOption option = iOptionArray[n2];
                if (option.isForScannerDiscovery()) {
                    try {
                        String optionValue = null;
                        switch (option.getBasicValueType()) {
                            case 0: {
                                if (option.getBooleanValue()) {
                                    optionValue = option.getCommand();
                                    break;
                                }
                                optionValue = option.getCommandFalse();
                                break;
                            }
                            case 1: {
                                optionValue = option.getEnumCommand(option.getSelectedEnum());
                                break;
                            }
                            case 2: {
                                optionValue = String.valueOf(option.getCommand()) + option.getStringValue();
                                break;
                            }
                            case 3: {
                                String[] values = option.getBasicStringListValue();
                                if (values == null) break;
                                optionValue = "";
                                String cmd = option.getCommand();
                                String[] stringArray = values;
                                int n3 = values.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String value = stringArray[n4];
                                    if (!value.isEmpty() && !value.equals(EMPTY_QUOTED_STRING)) {
                                        optionValue = String.valueOf(optionValue) + cmd + value + ' ';
                                    }
                                    ++n4;
                                }
                                break;
                            }
                            case 12: {
                                optionValue = option.getCommand(option.getStringValue());
                            }
                        }
                        if (optionValue != null) {
                            flags = String.valueOf(flags) + ' ' + optionValue.trim();
                        }
                    }
                    catch (BuildException e) {
                        ManagedBuilderCorePlugin.log(e);
                    }
                }
                ++n2;
            }
        }
        return flags.trim();
    }

    @Override
    protected List<IEnvironmentVariable> getEnvironmentVariables() {
        if (this.envMngr == null && this.currentCfgDescription == null) {
            IToolChain toolchain = ManagedBuildManager.getExtensionToolChain(this.getToolchainId());
            this.envMngr = new EnvironmentVariableManagerToolChain(toolchain);
        }
        List<IEnvironmentVariable> vars = super.getEnvironmentVariables();
        return vars;
    }
}

