/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class AdaptingSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private Class<?> fTargetType;
    private ListenerList fListenerList;
    private ISelectionProvider fProvider;

    public AdaptingSelectionProvider(Class<?> targetType, ISelectionProvider provider) {
        this.fProvider = provider;
        this.fTargetType = targetType;
        this.fListenerList = new ListenerList();
    }

    private ISelection convertSelection(ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<Object> adapted = new ArrayList<Object>();
            Iterator iter = ss.iterator();
            while (iter.hasNext()) {
                Object elem = this.adaptElem(iter.next());
                if (elem == null) continue;
                adapted.add(elem);
            }
            return new StructuredSelection(adapted);
        }
        return selection;
    }

    private Object adaptElem(Object elem) {
        if (this.fTargetType.isInstance(elem)) {
            return elem;
        }
        if (elem instanceof IAdaptable) {
            return ((IAdaptable)elem).getAdapter(this.fTargetType);
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fListenerList.isEmpty()) {
            this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fListenerList.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.convertSelection(this.fProvider.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.remove((Object)listener);
        if (this.fListenerList.isEmpty()) {
            this.fProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] listeners;
        SelectionChangedEvent event2 = new SelectionChangedEvent((ISelectionProvider)this, this.convertSelection(event.getSelection()));
        Object[] objectArray = listeners = this.fListenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ISelectionChangedListener l = (ISelectionChangedListener)listener;
            l.selectionChanged(event2);
            ++n2;
        }
    }
}

