/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;

public abstract class ASTNameVisitor
extends ASTVisitor {
    private int fOffset = -1;
    private String fFileName;

    public ASTNameVisitor(String fileName) {
        this(fileName, -1);
    }

    public ASTNameVisitor(String fileName, int offset) {
        this.fFileName = fileName;
        this.fOffset = offset;
        this.shouldVisitNames = true;
    }

    protected abstract int visitName(IASTName var1);

    public final int visit(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qn = (ICPPASTQualifiedName)name;
            ICPPASTNameSpecifier[] segments = qn.getAllSegments();
            boolean visited = false;
            int i = 0;
            while (i < segments.length) {
                if (segments[i] instanceof IASTName && this.checkLocation((IASTNode)segments[i])) {
                    if (this.visitName((IASTName)segments[i]) == 2) {
                        return 2;
                    }
                    visited = true;
                }
                ++i;
            }
            if (!visited && this.checkLocation((IASTNode)name)) {
                return this.visitName(name.getLastName());
            }
        } else if (this.checkLocation((IASTNode)name)) {
            return this.visitName(name);
        }
        return 3;
    }

    private boolean checkLocation(IASTNode node) {
        if (this.fFileName == null) {
            return true;
        }
        if (!this.fFileName.equals(node.getContainingFilename())) {
            return false;
        }
        IASTFileLocation loc = null;
        if (node instanceof IASTName) {
            loc = ASTManager.getImageFileLocation((IASTName)node);
        } else {
            IASTNodeLocation[] locs = node.getNodeLocations();
            if (locs != null && locs.length == 1 && locs[0] instanceof IASTFileLocation) {
                loc = (IASTFileLocation)locs[0];
            }
        }
        if (loc == null) {
            return false;
        }
        if (this.fOffset == -1) {
            return true;
        }
        int off = loc.getNodeOffset();
        int len = loc.getNodeLength();
        return off <= this.fOffset && this.fOffset < off + len;
    }
}

