/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.variable;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.extract.variable.ExtractVariableRefactoring;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtractVariableRefactoringTest26642
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"TestProject1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        this.file = TestUtils.createFile((IFolder)folder, (String)"ExtractVariableRefactoringTest26642.php", (String)"<?php function tests ($oppp){  return $oppp;}$test = 123;$test1 = 124;echo $test;$test = \"test\" $paste = tests ($test);?>");
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDownListSuite() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testExtractVar() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 47, 0);
            processor.setNewVariableName("c");
            this.checkInitCondition((Refactoring)processor);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Override
    protected void checkInitCondition(Refactoring processor) {
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((long)4L, (long)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }
}

