/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom.fragments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.match.PHPASTMatcher;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InfixExpression;
import org.eclipse.php.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.php.internal.ui.corext.dom.fragments.IASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.Util;
import org.eclipse.text.edits.TextEditGroup;

public class AssociativeInfixExpressionFragment
extends ASTFragment
implements IExpressionFragment {
    private final List<Expression> fOperands;
    private final InfixExpression fGroupRoot;

    public static IExpressionFragment createSubPartFragmentBySourceRange(InfixExpression node, ISourceRange range, IDocument document) throws BadLocationException {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)range);
        SourceRange nodeRange = new SourceRange(node.getStart(), node.getLength());
        Assert.isTrue((!Util.covers(range, (ISourceRange)nodeRange) ? 1 : 0) != 0);
        Assert.isTrue((boolean)Util.covers((ISourceRange)nodeRange, range));
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node)) {
            return null;
        }
        InfixExpression groupRoot = AssociativeInfixExpressionFragment.findGroupRoot(node);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        List<Expression> groupMembers = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(groupRoot);
        List<Expression> subGroup = AssociativeInfixExpressionFragment.findSubGroupForSourceRange(groupMembers, range);
        if (subGroup.isEmpty() || AssociativeInfixExpressionFragment.rangeIncludesExtraNonWhitespace(range, subGroup, document, (ASTNode)node)) {
            return null;
        }
        return new AssociativeInfixExpressionFragment(groupRoot, subGroup);
    }

    public static IExpressionFragment createFragmentForFullSubtree(InfixExpression node) {
        Assert.isNotNull((Object)node);
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node)) {
            return null;
        }
        InfixExpression groupRoot = AssociativeInfixExpressionFragment.findGroupRoot(node);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        List<Expression> groupMembers = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(node);
        return new AssociativeInfixExpressionFragment(node, groupMembers);
    }

    private static InfixExpression findGroupRoot(InfixExpression node) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node));
        while (!AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)node)) {
            ASTNode parent = node.getParent();
            Assert.isNotNull((Object)parent);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix(parent));
            Assert.isTrue((((InfixExpression)parent).getOperator() == node.getOperator() ? 1 : 0) != 0);
            node = (InfixExpression)parent;
        }
        return node;
    }

    private static List<Expression> findSubGroupForSourceRange(List<Expression> group, ISourceRange range) {
        Assert.isTrue((!group.isEmpty() ? 1 : 0) != 0);
        ArrayList<Expression> subGroup = new ArrayList<Expression>();
        boolean entered = false;
        boolean exited = false;
        if (range.getOffset() == ((ASTNode)group.get(0)).getStart()) {
            entered = true;
        }
        int i = 0;
        while (i < group.size() - 1) {
            Expression member = group.get(i);
            Expression nextMember = group.get(i + 1);
            if (entered) {
                subGroup.add(member);
                if (AssociativeInfixExpressionFragment.rangeEndsBetween(range, (ASTNode)member, (ASTNode)nextMember)) {
                    exited = true;
                    break;
                }
            } else if (AssociativeInfixExpressionFragment.rangeStartsBetween(range, (ASTNode)member, (ASTNode)nextMember)) {
                entered = true;
            }
            ++i;
        }
        Expression lastGroupMember = group.get(group.size() - 1);
        if (Util.getEndExclusive(range) == Util.getEndExclusive((ISourceRange)new SourceRange(lastGroupMember.getStart(), lastGroupMember.getLength()))) {
            subGroup.add(lastGroupMember);
            exited = true;
        }
        if (!exited) {
            return new ArrayList<Expression>(0);
        }
        return subGroup;
    }

    private static boolean rangeStartsBetween(ISourceRange range, ASTNode first, ASTNode next) {
        int pos = range.getOffset();
        return first.getEnd() <= pos && pos <= next.getStart();
    }

    private static boolean rangeEndsBetween(ISourceRange range, ASTNode first, ASTNode next) {
        int pos = Util.getEndExclusive(range);
        return first.getEnd() <= pos && pos <= next.getStart();
    }

    private static boolean rangeIncludesExtraNonWhitespace(ISourceRange range, List<Expression> operands, IDocument document, ASTNode scope) throws BadLocationException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(range, (ISourceRange)AssociativeInfixExpressionFragment.getRangeOfOperands(operands), document);
    }

    private static SourceRange getRangeOfOperands(List<Expression> operands) {
        Expression first = operands.get(0);
        Expression last = operands.get(operands.size() - 1);
        return new SourceRange(first.getStart(), last.getEnd() - first.getStart());
    }

    @Override
    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        IASTFragment fragmentForNode = ASTFragmentFactory.createFragmentForFullSubtree(node, this);
        if (fragmentForNode instanceof AssociativeInfixExpressionFragment) {
            AssociativeInfixExpressionFragment kin = (AssociativeInfixExpressionFragment)fragmentForNode;
            return kin.getSubFragmentsWithMyNodeMatching(this);
        }
        return new IASTFragment[0];
    }

    @Override
    public void replace(ASTRewrite rewrite, ASTNode replacement, TextEditGroup textEditGroup) {
        InfixExpression groupNode = this.getGroupRoot();
        List<Expression> allOperands = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.getGroupRoot());
        if (allOperands.size() == this.fOperands.size()) {
            if (replacement instanceof Identifier && groupNode.getParent() instanceof ParenthesisExpression) {
                rewrite.replace(groupNode.getParent(), replacement, textEditGroup);
            } else {
                rewrite.replace((ASTNode)groupNode, replacement, textEditGroup);
            }
            return;
        }
        int first = allOperands.indexOf(this.fOperands.get(0));
        int after = first + this.fOperands.size();
        ArrayList<Expression> newOperands = new ArrayList<Expression>();
        int i = 0;
        while (i < allOperands.size()) {
            if (i < first || after <= i) {
                newOperands.add((Expression)rewrite.createCopyTarget((ASTNode)allOperands.get(i)));
            } else {
                assert (replacement instanceof Expression);
                newOperands.add((Expression)replacement);
                i = after - 1;
            }
            ++i;
        }
        InfixExpression newExpression = rewrite.getAST().newInfixExpression((Expression)newOperands.get(0), this.getOperator(), (Expression)newOperands.get(1));
        rewrite.replace((ASTNode)groupNode, (ASTNode)newExpression, textEditGroup);
    }

    @Override
    public Expression createCopyTarget(ASTRewrite rewrite, boolean removeSurroundingParenthesis) throws CoreException {
        List<Expression> allOperands = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.fGroupRoot);
        if (allOperands.size() == this.fOperands.size()) {
            return (Expression)rewrite.createCopyTarget((ASTNode)this.fGroupRoot);
        }
        int startPosition = this.getStartPosition();
        String source = this.fGroupRoot.getProgramRoot().getSourceModule().getSource().substring(startPosition, this.getLength() + startPosition);
        return (Expression)rewrite.createStringPlaceholder(source, 37);
    }

    private static List<List<Expression>> getMatchingContiguousNodeSubsequences(List<Expression> source, List<Expression> toMatch) {
        ArrayList<List<Expression>> subsequences = new ArrayList<List<Expression>>();
        int i = 0;
        while (i < source.size()) {
            if (AssociativeInfixExpressionFragment.matchesAt(i, source, toMatch)) {
                subsequences.add(source.subList(i, i + toMatch.size()));
                i += toMatch.size();
                continue;
            }
            ++i;
        }
        return subsequences;
    }

    private static boolean matchesAt(int index, List<?> subject, List<?> toMatch) {
        if (index + toMatch.size() > subject.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!PHPASTMatcher.doNodesMatch((ASTNode)((ASTNode)subject.get(index)), (ASTNode)((ASTNode)toMatch.get(i)))) {
                return false;
            }
            ++i;
            ++index;
        }
        return true;
    }

    private static boolean isAGroupRoot(ASTNode node) {
        Assert.isNotNull((Object)node);
        return AssociativeInfixExpressionFragment.isAssociativeInfix(node) && !AssociativeInfixExpressionFragment.isParentInfixWithSameOperator((InfixExpression)node);
    }

    private static boolean isAssociativeInfix(ASTNode node) {
        return node instanceof InfixExpression && AssociativeInfixExpressionFragment.isOperatorAssociative(((InfixExpression)node).getOperator());
    }

    private static boolean isParentInfixWithSameOperator(InfixExpression node) {
        return node.getParent() instanceof InfixExpression && ((InfixExpression)node.getParent()).getOperator() == node.getOperator();
    }

    private static boolean isOperatorAssociative(int operator) {
        return operator == 17 || operator == 19 || operator == 16 || operator == 15 || operator == 13 || operator == 14 || operator == 11 || operator == 10 || operator == 12 || operator == 9 || operator == 8;
    }

    private AssociativeInfixExpressionFragment(InfixExpression groupRoot, List<Expression> operands) {
        Assert.isTrue((operands.size() >= 2 ? 1 : 0) != 0);
        this.fGroupRoot = groupRoot;
        this.fOperands = Collections.unmodifiableList(operands);
    }

    @Override
    public boolean matches(IASTFragment other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        AssociativeInfixExpressionFragment otherOfKind = (AssociativeInfixExpressionFragment)other;
        return this.getOperator() == otherOfKind.getOperator() && this.doOperandsMatch(otherOfKind);
    }

    private boolean doOperandsMatch(AssociativeInfixExpressionFragment other) {
        if (this.getOperands().size() != other.getOperands().size()) {
            return false;
        }
        Iterator<Expression> myOperands = this.getOperands().iterator();
        Iterator<Expression> othersOperands = other.getOperands().iterator();
        while (myOperands.hasNext() && othersOperands.hasNext()) {
            ASTNode othersOperand;
            ASTNode myOperand = (ASTNode)myOperands.next();
            if (PHPASTMatcher.doNodesMatch((ASTNode)myOperand, (ASTNode)(othersOperand = (ASTNode)othersOperands.next()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return AssociativeInfixExpressionFragment.union(this.getSubFragmentsWithMyNodeMatching(toMatch), this.getSubFragmentsWithAnotherNodeMatching(toMatch));
    }

    private IASTFragment[] getSubFragmentsWithMyNodeMatching(IASTFragment toMatch) {
        if (toMatch.getClass() != this.getClass()) {
            return new IASTFragment[0];
        }
        AssociativeInfixExpressionFragment kinToMatch = (AssociativeInfixExpressionFragment)toMatch;
        if (kinToMatch.getOperator() != this.getOperator()) {
            return new IASTFragment[0];
        }
        List<List<Expression>> matchingSubsequences = AssociativeInfixExpressionFragment.getMatchingContiguousNodeSubsequences(this.getOperands(), kinToMatch.getOperands());
        IASTFragment[] matches = new IASTFragment[matchingSubsequences.size()];
        int i = 0;
        while (i < matchingSubsequences.size()) {
            AssociativeInfixExpressionFragment match = new AssociativeInfixExpressionFragment(this.fGroupRoot, matchingSubsequences.get(i));
            Assert.isTrue((match.matches(toMatch) || toMatch.matches(match) ? 1 : 0) != 0);
            matches[i] = match;
            ++i;
        }
        return matches;
    }

    private IASTFragment[] getSubFragmentsWithAnotherNodeMatching(IASTFragment toMatch) {
        IASTFragment[] result = new IASTFragment[]{};
        for (ASTNode aSTNode : this.getOperands()) {
            result = AssociativeInfixExpressionFragment.union(result, ASTMatchingFragmentFinder.findMatchingFragments(aSTNode, (ASTFragment)toMatch));
        }
        return result;
    }

    private static IASTFragment[] union(IASTFragment[] a1, IASTFragment[] a2) {
        IASTFragment[] union = new IASTFragment[a1.length + a2.length];
        System.arraycopy(a1, 0, union, 0, a1.length);
        System.arraycopy(a2, 0, union, a1.length, a2.length);
        return union;
    }

    @Override
    public Expression getAssociatedExpression() {
        return this.fGroupRoot;
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.fGroupRoot;
    }

    public InfixExpression getGroupRoot() {
        return this.fGroupRoot;
    }

    @Override
    public int getLength() {
        return this.getEndPositionExclusive() - this.getStartPosition();
    }

    private int getEndPositionExclusive() {
        List<Expression> operands = this.getOperands();
        ASTNode lastNode = (ASTNode)operands.get(operands.size() - 1);
        return lastNode.getEnd();
    }

    @Override
    public int getStartPosition() {
        return ((ASTNode)this.getOperands().get(0)).getStart();
    }

    public List<Expression> getOperands() {
        return this.fOperands;
    }

    public int getOperator() {
        return this.fGroupRoot.getOperator();
    }

    private static List<Expression> findGroupMembersInOrderFor(InfixExpression groupRoot) {
        return new GroupMemberFinder((InfixExpression)groupRoot).fMembersInOrder;
    }

    public int hashCode() {
        return this.fGroupRoot.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociativeInfixExpressionFragment other = (AssociativeInfixExpressionFragment)obj;
        return this.fGroupRoot.equals(other.fGroupRoot) && this.fOperands.equals(other.fOperands);
    }

    private static class GroupMemberFinder
    extends ApplyAll {
        private List<Expression> fMembersInOrder = new ArrayList<Expression>();
        private InfixExpression fGroupRoot;

        public GroupMemberFinder(InfixExpression groupRoot) {
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)groupRoot));
            this.fGroupRoot = groupRoot;
            this.fGroupRoot.accept((Visitor)this);
        }

        protected boolean apply(ASTNode node) {
            if (node instanceof InfixExpression && ((InfixExpression)node).getOperator() == this.fGroupRoot.getOperator()) {
                return true;
            }
            assert (node instanceof Expression);
            this.fMembersInOrder.add((Expression)node);
            return false;
        }
    }
}

