/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import java.net.ConnectException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule
implements TestRule {
    private final int sleep;
    private final int attempts;

    public RetryRule(int sleep, int attempts) {
        assert (attempts > 0);
        this.sleep = sleep;
        this.attempts = attempts;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){
            private int attempt = 0;

            public void evaluate() throws Throwable {
                ConnectException lastError;
                do {
                    try {
                        base.evaluate();
                        lastError = null;
                    }
                    catch (ConnectException e) {
                        lastError = e;
                        Thread.sleep(RetryRule.this.sleep);
                    }
                } while (this.attempt++ < RetryRule.this.attempts);
                if (lastError != null) {
                    throw lastError;
                }
            }
        };
    }
}

