/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.variable;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.extract.variable.ExtractVariableRefactoring;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtractVariableRefactoringTestGetVariableName
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"TestProject1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        this.file = TestUtils.createFile((IFolder)folder, (String)"ExtractVariableRefactoringTestGetVariableName.php", (String)"<?php function foo(){} foo(); $a = 1; $b=1.1; $c=true;$d=\"ab\"; $e = __LINE__;?>");
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDownListSuite() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testExtractMethod() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 23, 6);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"foo", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 35, 1);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"i", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar1() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 41, 3);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"d2", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar2() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 49, 4);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"bool", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar3() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 57, 4);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"str", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar4() {
        IStructuredModel model = null;
        try {
            model = this.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 68, 8);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"line", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

