/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ProxyHelper {
    private static ServiceTracker proxyServiceTracker;

    public static synchronized void acquireProxyService(BundleContext context) {
        if (proxyServiceTracker == null) {
            proxyServiceTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
            proxyServiceTracker.open();
        }
    }

    public static synchronized void releaseProxyService() {
        if (proxyServiceTracker != null) {
            proxyServiceTracker.close();
            proxyServiceTracker = null;
        }
    }

    public static synchronized IProxyService getProxyService() {
        return proxyServiceTracker == null ? null : (IProxyService)proxyServiceTracker.getService();
    }

    public static IProxyData getProxyData(URI uri) {
        IProxyService proxyService = ProxyHelper.getProxyService();
        if (proxyService != null) {
            return ProxyHelper.doGetProxyData(proxyService, uri);
        }
        return null;
    }

    private static IProxyData doGetProxyData(IProxyService proxyService, URI uri) {
        if (uri.getHost() == null || uri.getScheme() == null) {
            return null;
        }
        IProxyData[] proxyData = proxyService.select(uri);
        if (proxyData == null) {
            return null;
        }
        IProxyData[] iProxyDataArray = proxyData;
        int n = proxyData.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData pd = iProxyDataArray[n2];
            if (pd != null && pd.getHost() != null) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    public static HttpClientBuilder createHttpClientBuilder(URI baseUri) {
        HttpClientBuilder hcBuilder = HttpClients.custom();
        if (baseUri != null) {
            ProxyHelper.configureProxy(hcBuilder, baseUri);
        }
        return hcBuilder;
    }

    public static void configureProxy(HttpClientBuilder hcBuilder, URI uri) {
        IProxyData proxyData = ProxyHelper.getProxyData(uri);
        if (proxyData != null && !"SOCKS".equals(proxyData.getType())) {
            HttpHost proxy = new HttpHost(proxyData.getHost(), proxyData.getPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            hcBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            if (proxyData.isRequiresAuthentication()) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(proxyData.getHost(), proxyData.getPort()), (Credentials)new UsernamePasswordCredentials(proxyData.getUserId(), proxyData.getPassword()));
                hcBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
        }
    }
}

