/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class PdttFile {
    private String fileName;
    private Bundle testBundle;
    private Map<String, String> config = new HashMap<String, String>();
    private String preferences;
    private String restorePreferences;
    private String description;
    private String file = "";
    private List<CharSequence> otherFiles = new LinkedList<CharSequence>();
    private int currentFile;
    private String expected = "";
    private String other;

    public PdttFile(String fileName) throws Exception {
        this(PHPCoreTests.getDefault().getBundle(), fileName, null);
    }

    public PdttFile(Bundle testBundle, String fileName) throws Exception {
        this(testBundle, fileName, null);
    }

    /*
     * Unable to fully structure code
     */
    public PdttFile(Bundle testBundle, String fileName, String charsetName) throws Exception {
        super();
        this.testBundle = testBundle;
        this.fileName = fileName;
        reader = this.openResource(fileName);
        try {
            this.parse(reader, charsetName);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            tmp = new ArrayList<CharSequence>(this.otherFiles.size());
            i = 0;
            ** for (seq : this.otherFiles)
        }
lbl-1000:
        // 1 sources

        {
            tmp.add(i, seq.toString());
            continue;
        }
lbl20:
        // 1 sources

        this.otherFiles = tmp;
    }

    public String getDescription() throws Exception {
        Assert.assertNotNull((String)("File: " + this.fileName + " doesn't contain --TEST-- section"), (Object)this.description);
        return this.description;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String getPreferences() {
        return this.preferences;
    }

    public String getRestorePreferences() {
        return this.restorePreferences;
    }

    public void applyPreferences() throws CoreException {
        PdttFile.applyPreferences(this.preferences);
    }

    public void restorePreferences() throws CoreException {
        PdttFile.applyPreferences(this.restorePreferences);
    }

    private static void applyPreferences(String preferences) throws CoreException {
        if (preferences != null) {
            Platform.getPreferencesService().importPreferences((InputStream)new ByteArrayInputStream(preferences.getBytes()));
        }
    }

    public String getFile() {
        Assert.assertNotNull((String)("File: " + this.fileName + " doesn't contain --FILE-- section"), (Object)this.file);
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOtherFile(int index) {
        Assert.assertNotNull((String)("File:" + this.fileName + '[' + index + "] doesn't contain --FILE" + index + "-- section"), (Object)this.otherFiles.get(index));
        return this.otherFiles.get(index).toString();
    }

    public String[] getOtherFiles() {
        return this.otherFiles.toArray(new String[this.otherFiles.size()]);
    }

    public String getExpected() {
        Assert.assertNotNull((String)("File: " + this.fileName + " doesn't contain --EXPECT-- section"), (Object)this.expected);
        return this.expected;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    protected InputStream openResource(String path) throws IOException {
        File localFile = new File(path);
        if (localFile.exists()) {
            return new FileInputStream(localFile);
        }
        URL url = this.testBundle.getEntry(path);
        return new BufferedInputStream(url.openStream());
    }

    protected void parse(InputStream inputStream, String charsetName) throws Exception {
        BufferedReader bReader = charsetName != null ? new BufferedReader(new InputStreamReader(inputStream, charsetName)) : new BufferedReader(new InputStreamReader(inputStream));
        String line = bReader.readLine();
        STATES state = null;
        while (line != null) {
            if (line.matches("--[A-Z0-9]+(_[A-Z0-9]+)*--")) {
                state = this.parseStateLine(line);
                if (state == null) {
                    throw new Exception("Wrong state: " + line);
                }
            } else if (state != null) {
                this.onState(state, line);
            }
            line = bReader.readLine();
        }
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void setPreferences(String preferences) {
        this.preferences = preferences;
    }

    public void setRestorePreferences(String preferences) {
        this.restorePreferences = preferences;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setExpected(String expected) {
        this.expected = expected;
    }

    public void write() throws Exception {
        PrintWriter w = new PrintWriter(new FileWriter(this.fileName));
        this.writeStates(w);
        w.close();
    }

    protected void writeStates(PrintWriter w) {
        w.println(STATES.TEST.getName());
        w.println(this.description.trim());
        if (this.config != null && this.config.size() > 0) {
            w.println(STATES.CONFIG.getName());
            for (String key : this.config.keySet()) {
                w.print(key);
                w.print(':');
                w.println(this.config.get(key));
            }
        }
        if (this.preferences != null) {
            w.println(STATES.PREFERENCES.getName());
            w.println(this.preferences.trim());
        }
        if (this.restorePreferences != null) {
            w.println(STATES.RESTORE_PREFERENCES.getName());
            w.println(this.restorePreferences.trim());
        }
        w.println(STATES.FILE.getName());
        w.println(this.file.trim());
        w.println(STATES.EXPECT.getName());
        w.println(this.expected.trim());
        if (this.other != null) {
            w.println(STATES.OTHER.getName());
            w.println(this.other.trim());
        }
        if (this.otherFiles.size() > 0) {
            int i = 0;
            for (CharSequence seq : this.otherFiles) {
                w.println(String.valueOf(STATES.OTHER_FILE.getName()) + i);
                w.println(seq.toString().trim());
            }
        }
    }

    protected STATES parseStateLine(String line) {
        Pattern compile;
        Matcher matcher;
        STATES state = STATES.byName(line);
        if (state == null && (matcher = (compile = Pattern.compile(STATES.OTHER_FILE.name)).matcher(line)).matches()) {
            state = STATES.OTHER_FILE;
            this.currentFile = Integer.valueOf(matcher.group(1));
            this.otherFiles.add(this.currentFile, new StringBuilder());
        }
        return state;
    }

    protected void onState(STATES state, String line) throws Exception {
        switch (state) {
            case TEST: {
                this.description = line;
                break;
            }
            case FILE: {
                this.file = String.valueOf(this.file) + line + "\n";
                break;
            }
            case OTHER_FILE: {
                ((StringBuilder)this.otherFiles.get(this.currentFile)).append(line).append('\n');
                break;
            }
            case EXPECT: {
                this.expected = String.valueOf(this.expected) + line + "\n";
                break;
            }
            case OTHER: {
                if (this.other == null) {
                    this.other = "";
                }
                this.other = String.valueOf(this.other) + line + "\n";
                break;
            }
            case CONFIG: {
                int i = line.indexOf(58);
                if (i == -1) {
                    throw new Exception("Wrong option in " + STATES.CONFIG.getName() + " section: " + line);
                }
                String key = line.substring(0, i);
                String value = line.substring(i + 1);
                this.config.put(key.trim(), value.trim());
                break;
            }
            case PREFERENCES: {
                if (line == null || line.length() <= 0) break;
                if (this.preferences == null) {
                    this.preferences = String.valueOf(line) + "\n";
                    break;
                }
                this.preferences = String.valueOf(this.preferences) + line + "\n";
                break;
            }
            case RESTORE_PREFERENCES: {
                if (line == null || line.length() <= 0) break;
                if (this.restorePreferences == null) {
                    this.restorePreferences = String.valueOf(line) + "\n";
                    break;
                }
                this.restorePreferences = String.valueOf(this.restorePreferences) + line + "\n";
                break;
            }
        }
    }

    protected static enum STATES {
        TEST("--TEST--"),
        CONFIG("--CONFIG--"),
        PREFERENCES("--PREFERENCES--"),
        RESTORE_PREFERENCES("--RESTORE_PREFERENCES--"),
        FILE("--FILE--"),
        EXPECT("--EXPECT--"),
        OTHER("--OTHER--"),
        OTHER_FILE("--FILE([0-9]+)--");

        String name;

        private STATES(String name) {
            this.name = name;
            Names.map.put(name.toLowerCase(), this);
        }

        public String getName() {
            return this.name;
        }

        public static STATES byName(String name) {
            return (STATES)((Object)Names.map.get(name.toLowerCase()));
        }

        private static class Names {
            private static Map<String, STATES> map = new HashMap<String, STATES>();

            private Names() {
            }
        }
    }
}

