/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.adapter;

import java.util.Enumeration;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.SelectionConverter;

public class DOMModelAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (SelectionConverter.class.equals(adapterType)) {
            return (T)((Object)new PHPSelectionConverter());
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{SelectionConverter.class};
    }

    private static class PHPSelectionConverter
    extends SelectionConverter {
        private PHPSelectionConverter() {
        }

        public Object[] getElements(IStructuredModel model, int start, int end) {
            DOMModelForPHP impl = (DOMModelForPHP)model;
            IStructuredDocument document = impl.getStructuredDocument();
            ISourceModule modelElement = null;
            Enumeration openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                DocumentAdapter adapt;
                Object nextElement = openBuffers.nextElement();
                if (!(nextElement instanceof DocumentAdapter) || !(adapt = (DocumentAdapter)nextElement).getDocument().equals(document) || !(adapt.getOwner() instanceof ISourceModule)) continue;
                modelElement = (ISourceModule)adapt.getOwner();
                break;
            }
            if (modelElement != null) {
                try {
                    IModelElement elementAt = modelElement.getElementAt(start);
                    if (elementAt instanceof IField && (elementAt.getParent() instanceof IMethod || elementAt.getParent() instanceof IType)) {
                        elementAt = elementAt.getParent();
                    }
                    if (elementAt instanceof ISourceReference) {
                        return new Object[]{elementAt};
                    }
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
            return super.getElements(model, start, end);
        }

        public IRegion getRegion(Object o) {
            if (o instanceof ISourceReference) {
                try {
                    ISourceRange sourceRange = ((ISourceReference)o).getSourceRange();
                    return new Region(sourceRange.getOffset(), sourceRange.getLength());
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
            return super.getRegion(o);
        }

        public IRegion getSelectionRegion(Object o) {
            if (o instanceof ISourceReference) {
                try {
                    ISourceRange sourceRange = ((ISourceReference)o).getNameRange();
                    if (sourceRange == null) {
                        sourceRange = ((ISourceReference)o).getSourceRange();
                    }
                    return new Region(sourceRange.getOffset(), sourceRange.getLength());
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
            return super.getRegion(o);
        }
    }
}

