/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP7;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP71;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP71
extends ASTRewriteTestsPHP7 {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP7_1;
    }

    @Test
    public void useStatementFunctionSet2() throws Exception {
        String str = "<?php use Foo\\{Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 1 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use Foo\\{function Bar}; \n ?>");
    }

    @Test
    public void useStatementConstSet2() throws Exception {
        String str = "<?php use Foo\\{Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 1 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use Foo\\{const Bar}; \n ?>");
    }

    @Test
    public void useStatementFunctionSet3() throws Exception {
        String str = "<?php use function Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, function Bar2}; \n ?>");
    }

    @Test
    public void useStatementConstSet3() throws Exception {
        String str = "<?php use function Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use const Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementConstSet4() throws Exception {
        String str = "<?php use Foo\\{const Bar, function Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use const Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet2() throws Exception {
        String str = "<?php use Foo\\{const Bar, function Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet3() throws Exception {
        String str = "<?php use function Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet4() throws Exception {
        String str = "<?php use Foo\\{function Bar, Bar, const Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 3 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(2)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar, Bar}; \n ?>");
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP71.class, NodeDeletionTestsPHP71.class})
    public static class Suite {
    }
}

