/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.internal.CachedLabel;

public class GraphLabel
extends CachedLabel {
    private Color borderColor;
    private int borderWidth;
    private int arcWidth;
    private boolean painting = false;

    public GraphLabel(boolean cacheLabel) {
        this("", cacheLabel);
    }

    public GraphLabel(String text, boolean cacheLabel) {
        this("", null, cacheLabel);
    }

    public GraphLabel(Image i, boolean cacheLabel) {
        this("", i, cacheLabel);
    }

    public GraphLabel(String text, Image i, boolean cacheLabel) {
        super(cacheLabel);
        this.initLabel();
        this.setText(text);
        this.setIcon(i);
        this.adjustBoundsToFit();
    }

    protected void initLabel() {
        super.setFont(Display.getDefault().getSystemFont());
        this.borderColor = ColorConstants.black;
        this.borderWidth = 1;
        this.arcWidth = 8;
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setBorder((Border)new MarginBorder(1));
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.adjustBoundsToFit();
    }

    protected void adjustBoundsToFit() {
        Font font;
        String text = this.getText();
        if (text != null && (font = this.getFont()) != null) {
            Dimension minSize = FigureUtilities.getTextExtents((String)text, (Font)font);
            if (this.getIcon() != null) {
                Rectangle imageRect = this.getIcon().getBounds();
                int expandHeight = Math.max(imageRect.height - minSize.height, 0);
                minSize.expand(imageRect.width + 4, expandHeight);
            }
            minSize.expand(10 + 2 * this.borderWidth, 4 + 2 * this.borderWidth);
            this.setBounds(new org.eclipse.draw2d.geometry.Rectangle(this.getLocation(), minSize));
        }
    }

    public void paint(Graphics graphics) {
        int blue = this.getBackgroundColor().getBlue();
        blue = (blue = (int)((double)blue - (double)blue * 0.2)) > 0 ? blue : 0;
        int red = this.getBackgroundColor().getRed();
        red = (int)((double)red - (double)red * 0.2);
        red = red > 0 ? red : 0;
        int green = this.getBackgroundColor().getGreen();
        green = (int)((double)green - (double)green * 0.2);
        green = green > 0 ? green : 0;
        Color lightenColor = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.pushState();
        org.eclipse.draw2d.geometry.Rectangle bounds = this.getBounds().getCopy();
        org.eclipse.draw2d.geometry.Rectangle r = bounds.getCopy();
        r.y += this.arcWidth / 2;
        r.height -= this.arcWidth;
        org.eclipse.draw2d.geometry.Rectangle top = bounds.getCopy();
        top.height /= 2;
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.fillRoundRectangle(top, this.arcWidth, this.arcWidth);
        top.y += top.height;
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(lightenColor);
        graphics.fillRoundRectangle(top, this.arcWidth, this.arcWidth);
        graphics.setBackgroundColor(lightenColor);
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.fillGradient(r, true);
        super.paint(graphics);
        graphics.popState();
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(lightenColor);
        bounds.setSize(bounds.width - 1, bounds.height - 1);
        graphics.drawRoundRectangle(bounds, this.arcWidth, this.arcWidth);
        lightenColor.dispose();
    }

    protected Color getBackgroundTextColor() {
        return this.getBackgroundColor();
    }

    public void invalidate() {
        if (!this.painting) {
            super.invalidate();
        }
    }

    public void setText(String s) {
        if (!s.equals("")) {
            super.setText(s);
        } else {
            super.setText("");
        }
        this.adjustBoundsToFit();
    }

    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public void setBounds(org.eclipse.draw2d.geometry.Rectangle rect) {
        super.setBounds(rect);
    }
}

