/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model;

import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.jface.util.Assert;

public class TextRun
extends ModelElement {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_IMPORT = 1;
    public static final int TYPE_PACKAGE = 2;
    public static final int TYPE_BULLET = 3;
    public static final int TYPE_UNDERLINE = 4;
    public static final int TYPE_CODE = 5;
    private String text;

    public TextRun(String text) {
        this.text = text;
    }

    public TextRun(String text, int type) {
        this.text = text;
        this.type = type;
    }

    public TextRun subdivideRun(int offset) {
        String remainder = this.removeRange(offset, this.size() - offset);
        return new TextRun(remainder, this.getType());
    }

    public String getText() {
        return this.text;
    }

    public void insertText(String someText, int offset) {
        this.text = String.valueOf(this.text.substring(0, offset)) + someText + this.text.substring(offset, this.text.length());
        this.firePropertyChange("text", null, this.text);
    }

    public String overwriteText(String someText, int offset) {
        String result = this.text.substring(offset, Math.min(offset + someText.length(), this.text.length()));
        this.text = String.valueOf(this.text.substring(0, offset)) + someText + this.text.substring(offset + result.length());
        this.firePropertyChange("text", null, this.text);
        return result;
    }

    public String removeRange(int offset, int length) {
        Assert.isTrue((offset <= this.text.length() ? 1 : 0) != 0);
        Assert.isTrue((offset + length <= this.text.length() ? 1 : 0) != 0);
        String result = this.text.substring(offset, offset + length);
        this.text = String.valueOf(this.text.substring(0, offset)) + this.text.substring(offset + length);
        this.firePropertyChange("text", null, this.text);
        return result;
    }

    public void setText(String text) {
        this.text = text;
        this.firePropertyChange("text", null, text);
    }

    public int size() {
        return this.getText().length();
    }

    public String toString() {
        return this.text;
    }
}

