/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelFactory
extends AbstractStylingModelFactory {
    AbstractStructuredGraphViewer viewer = null;

    public GraphModelFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object[] rels = this.getContentProvider().getElements(this.getViewer().getInput());
        if (rels != null) {
            IFigureProvider figureProvider = null;
            if (this.getLabelProvider() instanceof IFigureProvider) {
                figureProvider = (IFigureProvider)this.getLabelProvider();
            }
            int i = 0;
            while (i < rels.length) {
                Object source = this.getCastedContent().getSource(rels[i]);
                source = this.filterElement(this.getViewer().getInput(), source) ? null : source;
                Object dest = this.getCastedContent().getDestination(rels[i]);
                Object object = dest = this.filterElement(this.getViewer().getInput(), dest) ? null : dest;
                if (source == null) {
                    if (dest != null) {
                        if (figureProvider != null) {
                            this.createNode(model, dest, figureProvider.getFigure(dest));
                        } else {
                            this.createNode(model, dest);
                        }
                    }
                } else if (dest == null) {
                    if (figureProvider != null) {
                        this.createNode(model, source, figureProvider.getFigure(dest));
                    } else {
                        this.createNode(model, source);
                    }
                } else if (source != null && dest != null && !this.filterElement(this.getViewer().getInput(), rels[i])) {
                    this.createConnection(model, rels[i], source, dest);
                }
                ++i;
            }
        }
    }

    private IGraphContentProvider getCastedContent() {
        return (IGraphContentProvider)this.getContentProvider();
    }

    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    public void refresh(Graph graph, Object element, boolean updateLabels) {
        GraphConnection conn = this.viewer.getGraphModelConnection(element);
        if (conn == null) {
            GraphNode node = this.viewer.getGraphModelNode(element);
            if (node != null) {
                GraphConnection c;
                List connections = node.getSourceConnections();
                Iterator it = connections.iterator();
                while (it.hasNext()) {
                    c = (GraphConnection)((Object)it.next());
                    this.refresh(graph, c.getExternalConnection(), updateLabels);
                }
                connections = node.getTargetConnections();
                it = connections.iterator();
                while (it.hasNext()) {
                    c = (GraphConnection)((Object)it.next());
                    this.refresh(graph, c.getExternalConnection(), updateLabels);
                }
            }
            return;
        }
        Object oldSource = conn.getSource().getData();
        Object oldDest = conn.getDestination().getData();
        Object newSource = this.getCastedContent().getSource(element);
        Object newDest = this.getCastedContent().getDestination(element);
        if (!oldSource.equals(newSource) || !oldDest.equals(newDest)) {
            GraphNode internalSource = this.viewer.getGraphModelNode(newSource);
            GraphNode internalDest = this.viewer.getGraphModelNode(newDest);
            if (internalSource == null) {
                internalSource = this.createNode(graph, newSource);
            } else if (updateLabels) {
                this.styleItem(internalSource);
            }
            if (internalDest == null) {
                internalDest = this.createNode(graph, newDest);
            } else if (updateLabels) {
                this.styleItem(internalDest);
            }
            if (updateLabels) {
                this.styleItem(conn);
            }
        }
    }
}

