/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.internal.ui.palette.editparts.ColumnsLayout;
import org.eclipse.gef.internal.ui.palette.editparts.PinFigure;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.swt.graphics.Color;

public class PinnablePaletteStackFigure
extends Figure {
    private static final Color COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_85 = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_BACKGROUND, (Color)PaletteColorUtil.WIDGET_LIST_BACKGROUND, (double)0.85);
    private static final Color COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_40 = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_BACKGROUND, (Color)PaletteColorUtil.WIDGET_LIST_BACKGROUND, (double)0.4);
    private static final Color COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_65 = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_BACKGROUND, (Color)PaletteColorUtil.WIDGET_NORMAL_SHADOW, (double)0.65);
    private static final Color COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_40 = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_BACKGROUND, (Color)PaletteColorUtil.WIDGET_NORMAL_SHADOW, (double)0.4);
    private static final Color COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_80 = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_BACKGROUND, (Color)PaletteColorUtil.WIDGET_NORMAL_SHADOW, (double)0.8);
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    static final int ARROW_WIDTH = 9;
    private ChangeListener clickableArrowListener = new ChangeListener(){

        public void handleStateChanged(ChangeEvent event) {
            Clickable clickable = (Clickable)event.getSource();
            if (event.getPropertyName() == "mouseover" && PinnablePaletteStackFigure.this.getActiveFigure() instanceof ToolEntryEditPart.ToolEntryToggle) {
                ((ToolEntryEditPart.ToolEntryToggle)PinnablePaletteStackFigure.this.getActiveFigure()).setShowHoverFeedback(clickable.getModel().isMouseOver());
            }
            if (event.getPropertyName() == "selected") {
                Animation.markBegin();
                PinnablePaletteStackFigure.this.handleExpandStateChanged();
                Animation.run((int)150);
                if (PinnablePaletteStackFigure.this.isExpanded()) {
                    boolean collapseOtherStacks = PinnablePaletteStackFigure.this.layoutMode == 1 || PinnablePaletteStackFigure.this.layoutMode == 2;
                    Iterator iterator = PinnablePaletteStackFigure.this.getParent().getChildren().iterator();
                    while (iterator.hasNext()) {
                        Object childFigure = iterator.next();
                        if (!(childFigure instanceof PinnablePaletteStackFigure) || childFigure == PinnablePaletteStackFigure.this || !collapseOtherStacks && (!((PinnablePaletteStackFigure)((Object)childFigure)).isExpanded() || ((PinnablePaletteStackFigure)((Object)childFigure)).isPinnedOpen())) continue;
                        ((PinnablePaletteStackFigure)((Object)childFigure)).setExpanded(false);
                    }
                }
            }
        }
    };
    private IFigure headerFigure;
    private IFigure activeToolFigure;
    private PinFigure pinFigure;
    private RolloverArrow arrowFigure;
    private IFigure expandablePane;
    private int layoutMode = -1;
    private Rectangle headerBoundsLayoutHint = new Rectangle();

    public PinnablePaletteStackFigure() {
        this.arrowFigure = new RolloverArrow();
        this.arrowFigure.addChangeListener(this.clickableArrowListener);
        this.headerFigure = new Figure();
        this.headerFigure.add((IFigure)this.arrowFigure);
        this.pinFigure = new PinFigure();
        this.pinFigure.setBorder((Border)new MarginBorder(0, 0, 0, 2));
        this.expandablePane = new Figure();
        this.add(this.headerFigure);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        if (!this.isExpanded()) {
            return;
        }
        Rectangle headerBounds = this.headerFigure.getBounds().getCopy();
        Rectangle paneBounds = this.expandablePane.getClientArea();
        g.setBackgroundColor(COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_40);
        g.fillRectangle(paneBounds);
        if (this.layoutMode == 2 || this.layoutMode == 1) {
            int pinHeight = this.expandablePane.getInsets().top;
            Rectangle pinAreaBounds = new Rectangle(paneBounds.x, this.expandablePane.getBounds().y, paneBounds.width, pinHeight);
            g.setForegroundColor(COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_40);
            g.setBackgroundColor(COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_85);
            g.fillGradient(headerBounds, true);
            g.setBackgroundColor(COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_85);
            g.fillRectangle(pinAreaBounds);
            g.setForegroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
            g.drawLine(headerBounds.getTopLeft().getTranslated(1, 1), headerBounds.getTopRight().getTranslated(-1, 1));
            g.drawLine(headerBounds.getBottomLeft().getTranslated(1, 0), headerBounds.getTopLeft().getTranslated(1, 1));
            g.drawLine(headerBounds.getBottomRight().getTranslated(-2, 0), headerBounds.getTopRight().getTranslated(-2, 1));
            g.drawLine(pinAreaBounds.getTopLeft().getTranslated(0, 1), pinAreaBounds.getTopRight().getTranslated(-1, 1));
            g.drawLine(pinAreaBounds.getBottomLeft().getTranslated(0, -2), pinAreaBounds.getBottomRight().getTranslated(-1, -2));
            PointList points = new PointList();
            points.addPoint(headerBounds.getBottomLeft());
            points.addPoint(headerBounds.getTopLeft().getTranslated(0, 2));
            points.addPoint(headerBounds.getTopLeft().getTranslated(1, 1));
            points.addPoint(headerBounds.getTopLeft().getTranslated(2, 0));
            points.addPoint(headerBounds.getTopRight().getTranslated(-3, 0));
            points.addPoint(headerBounds.getTopRight().getTranslated(-2, 1));
            points.addPoint(headerBounds.getTopRight().getTranslated(-1, 2));
            points.addPoint(headerBounds.getBottomRight().getTranslated(-1, 0));
            points.addPoint(pinAreaBounds.getTopRight().getTranslated(-1, 0));
            points.addPoint(paneBounds.getBottomRight().getTranslated(-1, -1));
            points.addPoint(paneBounds.getBottomLeft().getTranslated(0, -1));
            points.addPoint(pinAreaBounds.getTopLeft().getTranslated(0, 0));
            points.addPoint(headerBounds.getBottomLeft());
            g.setForegroundColor(COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_40);
            g.drawPolygon(points);
            g.setForegroundColor(COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_80);
            Point pt = headerBounds.getTopLeft().getTranslated(0, 1);
            g.drawPoint(pt.x, pt.y);
            pt = headerBounds.getTopLeft().getTranslated(1, 0);
            g.drawPoint(pt.x, pt.y);
            pt = headerBounds.getTopRight().getTranslated(-2, 0);
            g.drawPoint(pt.x, pt.y);
            pt = headerBounds.getTopRight().getTranslated(-1, 1);
            g.drawPoint(pt.x, pt.y);
        } else {
            g.setBackgroundColor(COLOR_WIDGET_BACKGROUND_LIST_BACKGROUND_85);
            g.fillRectangle(headerBounds);
            g.setForegroundColor(COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_65);
            g.drawLine(headerBounds.getTopLeft(), headerBounds.getTopRight());
            g.setForegroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
            g.drawLine(headerBounds.getBottomLeft().getTranslated(0, -2), headerBounds.getBottomRight().getTranslated(0, -2));
            g.setForegroundColor(COLOR_WIDGET_BACKGROUND_NORMAL_SHADOW_65);
            g.drawLine(paneBounds.getBottomLeft().getTranslated(0, -1), paneBounds.getBottomRight().getTranslated(0, -1));
        }
    }

    public IFigure getContentPane(IFigure figure) {
        if (figure == this.activeToolFigure) {
            return this.headerFigure;
        }
        return this.getContentPane();
    }

    public IFigure getContentPane() {
        return this.expandablePane;
    }

    public IFigure getActiveFigure() {
        return this.activeToolFigure;
    }

    public boolean isExpanded() {
        return this.arrowFigure.getModel().isSelected();
    }

    public boolean isPinnedOpen() {
        return this.isExpanded() && this.pinFigure.getModel().isSelected();
    }

    public void setPinned(boolean pinned) {
        if (this.isExpanded()) {
            this.pinFigure.setSelected(pinned);
        }
    }

    public void setExpanded(boolean value) {
        this.arrowFigure.setSelected(value);
        if (!value) {
            this.pinFigure.setSelected(false);
        }
    }

    public void setLayoutMode(int newLayoutMode) {
        if (this.layoutMode == newLayoutMode) {
            return;
        }
        this.layoutMode = newLayoutMode;
        this.setExpanded(false);
        if (newLayoutMode == 0 || newLayoutMode == 3) {
            this.headerFigure.setLayoutManager((LayoutManager)new HeaderListLayout());
            this.expandablePane.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.expandablePane.setBorder((Border)new MarginBorder(1, 0, 1, 0));
            this.setLayoutManager((LayoutManager)new ToolbarLayout());
        } else {
            this.headerFigure.setLayoutManager((LayoutManager)new HeaderIconLayout());
            if (this.activeToolFigure != null) {
                this.headerFigure.setConstraint(this.activeToolFigure, (Object)BorderLayout.CENTER);
            }
            this.setLayoutManager((LayoutManager)new PaletteStackIconLayout());
            this.expandablePane.setBorder((Border)new MarginBorder(18, 0, 0, 0));
            if (this.layoutMode == 1) {
                this.expandablePane.setLayoutManager((LayoutManager)new ColumnsLayout());
            } else {
                FlowLayout fl = new FlowLayout();
                fl.setMinorSpacing(0);
                fl.setMajorSpacing(0);
                this.expandablePane.setLayoutManager((LayoutManager)fl);
            }
        }
    }

    public void activeEntryChanged(IFigure oldFigure, int oldFigureIndex, IFigure newFigure) {
        if (oldFigure != null) {
            this.expandablePane.add(oldFigure, oldFigureIndex);
        }
        if (newFigure != null) {
            this.activeToolFigure = newFigure;
            this.headerFigure.add(this.activeToolFigure, (Object)BorderLayout.CENTER, 0);
        } else {
            this.activeToolFigure = null;
        }
    }

    private void handleExpandStateChanged() {
        if (this.isExpanded()) {
            if (this.expandablePane.getParent() != this) {
                this.add(this.expandablePane);
                if (this.layoutMode == 0 || this.layoutMode == 3) {
                    this.headerFigure.add((IFigure)this.pinFigure);
                } else {
                    this.add((IFigure)this.pinFigure);
                }
            }
        } else if (this.expandablePane.getParent() == this) {
            this.remove(this.expandablePane);
            this.pinFigure.getParent().remove((IFigure)this.pinFigure);
        }
    }

    public Dimension getExpandedContainerPreferredSize(int wHint, int hHint) {
        if (this.isExpanded()) {
            return this.expandablePane.getPreferredSize(wHint, hHint);
        }
        return EMPTY_DIMENSION;
    }

    public void setHeaderBoundsLayoutHint(Rectangle rect) {
        this.headerBoundsLayoutHint.setBounds(rect);
    }

    public Dimension getHeaderPreferredSize(int wHint, int hHint) {
        return this.headerFigure.getPreferredSize(wHint, hHint);
    }

    public boolean containsPoint(int x, int y) {
        return this.headerFigure.containsPoint(x, y) || this.isExpanded() && this.expandablePane.containsPoint(x, y);
    }

    private class HeaderIconLayout
    extends StackLayout {
        private HeaderIconLayout() {
        }

        protected boolean isSensitiveVertically(IFigure container) {
            return false;
        }

        public void layout(IFigure parent) {
            Rectangle r = parent.getClientArea();
            PinnablePaletteStackFigure.this.activeToolFigure.setBounds(r);
            r.x = r.right() - ToolEntryEditPart.ICON_HIGHLIGHT_INSETS.right - 9;
            r.y += ToolEntryEditPart.ICON_HIGHLIGHT_INSETS.top;
            r.width = 9;
            r.height -= ToolEntryEditPart.ICON_HIGHLIGHT_INSETS.getHeight();
            PinnablePaletteStackFigure.this.arrowFigure.setBounds(r);
        }
    }

    private class HeaderListLayout
    extends StackLayout {
        private HeaderListLayout() {
        }

        protected boolean isSensitiveVertically(IFigure container) {
            return false;
        }

        protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
            if (PinnablePaletteStackFigure.this.isExpanded()) {
                Dimension pinSize = PinnablePaletteStackFigure.this.pinFigure.getSize();
                Dimension preferredSize = super.calculatePreferredSize(parent, wHint - pinSize.width, hHint);
                preferredSize.width += pinSize.width;
                return preferredSize;
            }
            return super.calculatePreferredSize(parent, wHint, hHint);
        }

        public void layout(IFigure parent) {
            Rectangle r = parent.getClientArea();
            Dimension pinSize = PinnablePaletteStackFigure.this.isExpanded() ? PinnablePaletteStackFigure.this.pinFigure.getPreferredSize() : EMPTY_DIMENSION;
            Rectangle.SINGLETON.setSize(pinSize);
            Rectangle.SINGLETON.setLocation(r.right() - pinSize.width, r.getCenter().y - pinSize.height / 2);
            PinnablePaletteStackFigure.this.pinFigure.setBounds(Rectangle.SINGLETON);
            PinnablePaletteStackFigure.this.activeToolFigure.setBounds(r.getResized(-pinSize.width, 0));
            r.x += ToolEntryEditPart.LIST_HIGHLIGHT_INSETS.left;
            r.y += ToolEntryEditPart.LIST_HIGHLIGHT_INSETS.top;
            r.width = 9;
            r.height -= ToolEntryEditPart.LIST_HIGHLIGHT_INSETS.getHeight();
            PinnablePaletteStackFigure.this.arrowFigure.setBounds(r);
        }
    }

    private class PaletteStackIconLayout
    extends AbstractLayout {
        private PaletteStackIconLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
            return parent.getSize();
        }

        public void layout(IFigure parent) {
            if (PinnablePaletteStackFigure.this.isExpanded()) {
                PinnablePaletteStackFigure.this.headerFigure.setBounds(PinnablePaletteStackFigure.this.headerBoundsLayoutHint);
                Rectangle paneBounds = parent.getClientArea();
                paneBounds.y += ((PinnablePaletteStackFigure)PinnablePaletteStackFigure.this).headerBoundsLayoutHint.height;
                paneBounds.height -= ((PinnablePaletteStackFigure)PinnablePaletteStackFigure.this).headerBoundsLayoutHint.height;
                PinnablePaletteStackFigure.this.expandablePane.setBounds(paneBounds);
                Rectangle pinBounds = Rectangle.SINGLETON;
                Dimension pinSize = PinnablePaletteStackFigure.this.pinFigure.getPreferredSize();
                pinBounds.setSize(pinSize);
                int pinFigureAreaHeight = ((PinnablePaletteStackFigure)PinnablePaletteStackFigure.this).expandablePane.getInsets().top;
                pinBounds.setLocation(PinnablePaletteStackFigure.this.expandablePane.getClientArea().right() - pinSize.width, paneBounds.y + pinFigureAreaHeight / 2 - pinSize.height / 2);
                PinnablePaletteStackFigure.this.pinFigure.setBounds(pinBounds);
            } else {
                PinnablePaletteStackFigure.this.headerFigure.setBounds(parent.getClientArea());
            }
        }
    }

    class RolloverArrow
    extends Toggle {
        RolloverArrow() {
            this.setRolloverEnabled(true);
            this.setBorder(null);
            this.setOpaque(false);
            this.setPreferredSize(9, -1);
        }

        public boolean hasFocus() {
            return false;
        }

        public void paintFigure(Graphics graphics) {
            Rectangle rect = this.getClientArea();
            ButtonModel model = this.getModel();
            if (this.isRolloverEnabled() && model.isMouseOver()) {
                graphics.setBackgroundColor(PaletteColorUtil.ARROW_HOVER);
                graphics.fillRoundRectangle(rect, 3, 3);
            }
            graphics.translate(this.getLocation());
            int[] points = new int[8];
            int middleY = rect.height / 2;
            if (this.isSelected() || PinnablePaletteStackFigure.this.layoutMode == 2 || PinnablePaletteStackFigure.this.layoutMode == 1) {
                int startingX;
                points[0] = startingX = 2;
                points[1] = middleY;
                points[2] = startingX + 5;
                points[3] = middleY;
                points[4] = startingX + 2;
                points[5] = middleY + 3;
                points[6] = startingX;
                points[7] = middleY;
            } else {
                int startingX;
                points[0] = startingX = 3;
                points[1] = middleY - 2;
                points[2] = startingX + 3;
                points[3] = middleY + 1;
                points[4] = startingX;
                points[5] = middleY + 4;
                points[6] = startingX;
                points[7] = middleY - 2;
            }
            graphics.setBackgroundColor(PaletteColorUtil.WIDGET_DARK_SHADOW);
            graphics.fillPolygon(points);
            graphics.translate(this.getLocation().getNegated());
        }
    }
}

