/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.StructuredActivity;
import org.eclipse.gef.examples.flow.model.Transition;

public class AddAndAssignSourceCommand
extends Command {
    private StructuredActivity parent;
    private Activity child;
    private Activity source;
    private Transition transition;

    public boolean canExecute() {
        int i = 0;
        while (i < this.source.getOutgoingTransitions().size()) {
            Activity target = ((Transition)this.source.getOutgoingTransitions().get((int)i)).target;
            if (target.equals(this.child)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void execute() {
        this.parent.addChild(this.child);
        this.transition = new Transition(this.source, this.child);
    }

    public void redo() {
        this.source.addOutput(this.transition);
        this.child.addInput(this.transition);
        this.parent.addChild(this.child);
    }

    public void setParent(StructuredActivity sa) {
        this.parent = sa;
    }

    public void setChild(Activity activity) {
        this.child = activity;
    }

    public void setSource(Activity activity) {
        this.source = activity;
    }

    public void undo() {
        this.source.removeOutput(this.transition);
        this.child.removeInput(this.transition);
        this.parent.removeChild(this.child);
    }
}

