/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.swt.graphics.LineAttributes;

public abstract class Shape
extends Figure {
    protected int lineWidth;
    private int lastLineWidth;
    protected int lineStyle;
    private int lastLineStyle;
    private LineAttributes lineAttributes = new LineAttributes(1.0f);
    private boolean fill = true;
    private boolean outline = true;
    private boolean xorFill = false;
    private boolean xorOutline = false;
    private Integer antialias = null;
    private Integer alpha = null;

    public Shape() {
        this.lineWidth = (int)this.lineAttributes.width;
        this.lineStyle = this.lineAttributes.style;
        this.lastLineWidth = this.lineWidth;
        this.lastLineStyle = this.lineStyle;
    }

    protected abstract void fillShape(Graphics var1);

    protected abstract void outlineShape(Graphics var1);

    public void paintFigure(Graphics graphics) {
        if (this.antialias != null) {
            graphics.setAntialias(this.antialias);
        }
        if (this.alpha != null) {
            graphics.setAlpha(this.alpha);
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setBackgroundColor(ColorConstants.buttonLightest);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            if (this.fill) {
                this.paintFill(graphics);
            }
            if (this.outline) {
                this.paintOutline(graphics);
            }
            graphics.setBackgroundColor(ColorConstants.buttonDarker);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
            graphics.translate(-1, -1);
        }
        if (this.fill) {
            this.paintFill(graphics);
        }
        if (this.outline) {
            this.paintOutline(graphics);
        }
    }

    private void paintOutline(Graphics graphics) {
        this.lineAttributes.width = this.getLineWidthFloat();
        this.lineAttributes.style = this.getLineStyle();
        graphics.setLineAttributes(this.lineAttributes);
        if (this.xorOutline) {
            boolean oldAdv = graphics.getAdvanced();
            graphics.setAdvanced(false);
            graphics.setXORMode(true);
            this.outlineShape(graphics);
            graphics.setAdvanced(oldAdv);
        } else {
            this.outlineShape(graphics);
        }
    }

    private void paintFill(Graphics graphics) {
        if (this.xorFill) {
            boolean oldAdv = graphics.getAdvanced();
            graphics.setAdvanced(false);
            graphics.setXORMode(true);
            this.fillShape(graphics);
            graphics.setAdvanced(oldAdv);
        } else {
            this.fillShape(graphics);
        }
    }

    public void setFill(boolean b) {
        if (this.fill != b) {
            this.fill = b;
            this.repaint();
        }
    }

    public void setFillXOR(boolean b) {
        if (this.xorFill != b) {
            this.xorFill = b;
            this.repaint();
        }
    }

    public void setOutline(boolean b) {
        if (this.outline != b) {
            this.outline = b;
            this.repaint();
        }
    }

    public void setOutlineXOR(boolean b) {
        if (this.xorOutline != b) {
            this.xorOutline = b;
            this.repaint();
        }
    }

    public void setXOR(boolean b) {
        this.xorOutline = this.xorFill = b;
        this.repaint();
    }

    public Integer getAlpha() {
        return this.alpha;
    }

    public Integer getAntialias() {
        return this.antialias;
    }

    public LineAttributes getLineAttributes() {
        return SWTGraphics.clone(this.lineAttributes);
    }

    public int getLineWidth() {
        if (this.lineWidth != this.lastLineWidth) {
            this.lineAttributes.width = this.lineWidth;
            this.lastLineWidth = this.lineWidth;
        }
        return (int)this.lineAttributes.width;
    }

    public float getLineWidthFloat() {
        if (this.lineWidth != this.lastLineWidth) {
            this.lineAttributes.width = this.lineWidth;
            this.lastLineWidth = this.lineWidth;
        }
        return this.lineAttributes.width;
    }

    public int getLineJoin() {
        return this.lineAttributes.join;
    }

    public int getLineCap() {
        return this.lineAttributes.cap;
    }

    public int getLineStyle() {
        if (this.lineStyle != this.lastLineStyle) {
            this.lineAttributes.style = this.lineStyle;
            this.lastLineStyle = this.lineStyle;
        }
        return this.lineAttributes.style;
    }

    public float[] getLineDash() {
        if (this.lineAttributes.dash != null) {
            return (float[])this.lineAttributes.dash.clone();
        }
        return null;
    }

    public float getLineDashOffset() {
        return this.lineAttributes.dashOffset;
    }

    public float getLineMiterLimit() {
        return this.lineAttributes.miterLimit;
    }

    public void setAlpha(Integer value) {
        if (this.alpha != null) {
            if (!this.alpha.equals(value)) {
                this.alpha = value;
                this.repaint();
            }
        } else if (value != null) {
            this.alpha = value;
            this.repaint();
        }
    }

    public void setAlpha(int value) {
        if (this.alpha != null) {
            if (this.alpha != value) {
                this.alpha = new Integer(value);
                this.repaint();
            }
        } else {
            this.alpha = new Integer(value);
            this.repaint();
        }
    }

    public void setAntialias(Integer value) {
        if (this.antialias != null) {
            if (!this.antialias.equals(value)) {
                this.antialias = value;
                this.repaint();
            }
        } else if (value != null) {
            this.antialias = value;
            this.repaint();
        }
    }

    public void setAntialias(int value) {
        if (this.antialias != null) {
            if (this.antialias != value) {
                this.antialias = new Integer(value);
                this.repaint();
            }
        } else {
            this.antialias = new Integer(value);
            this.repaint();
        }
    }

    public void setLineAttributes(LineAttributes la) {
        if (!this.lineAttributes.equals(la)) {
            SWTGraphics.copyLineAttributes(this.lineAttributes, la);
            this.repaint();
        }
    }

    public void setLineWidth(int w) {
        float _w = w;
        if (this.lineAttributes.width != _w) {
            this.lineAttributes.width = _w;
            this.lineWidth = w;
            this.lastLineWidth = w;
            this.repaint();
        }
    }

    public void setLineWidthFloat(float value) {
        if (this.lineAttributes.width != value) {
            this.lineAttributes.width = value;
            this.lineWidth = (int)value;
            this.lastLineWidth = (int)value;
            this.repaint();
        }
    }

    public void setLineJoin(int join) {
        if (this.lineAttributes.join != join) {
            this.lineAttributes.join = join;
            this.repaint();
        }
    }

    public void setLineCap(int cap) {
        if (this.lineAttributes.cap != cap) {
            this.lineAttributes.cap = cap;
            this.repaint();
        }
    }

    public void setLineStyle(int style) {
        if (this.lineAttributes.style != style) {
            this.lineAttributes.style = style;
            this.lineStyle = style;
            this.lastLineStyle = style;
            this.repaint();
        }
    }

    public void setLineDash(float[] dash) {
        if (dash != null && !dash.equals(this.lineAttributes.dash)) {
            this.lineAttributes.dash = (float[])dash.clone();
            this.repaint();
        } else if (dash == null && this.lineAttributes.dash != null) {
            this.lineAttributes.dash = null;
            this.repaint();
        }
    }

    public void setLineDashOffset(float dashOffset) {
        if (this.lineAttributes.dashOffset != dashOffset) {
            this.lineAttributes.dashOffset = dashOffset;
            this.repaint();
        }
    }

    public void setLineMiterLimit(float miterLimit) {
        if (this.lineAttributes.miterLimit != miterLimit) {
            this.lineAttributes.miterLimit = miterLimit;
            this.repaint();
        }
    }
}

