/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.PrecisionPoint;

public class Vector {
    public double x;
    public double y;

    public Vector() {
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector(PrecisionPoint p) {
        this.x = p.preciseX;
        this.y = p.preciseY;
    }

    public Vector(PrecisionPoint start, PrecisionPoint end) {
        this.x = end.preciseX - start.preciseX;
        this.y = end.preciseY - start.preciseY;
    }

    public Vector(Vector start, Vector end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public double getDissimilarity(Vector other) {
        return Math.abs(this.getCrossProduct(other));
    }

    public boolean isParallelTo(Vector other) {
        return this.getDissimilarity(other) == 0.0;
    }

    public double getDotProduct(Vector other) {
        return this.x * other.x + this.y * other.y;
    }

    public double getCrossProduct(Vector other) {
        return this.x * other.y - this.y * other.x;
    }

    public Vector getAdded(Vector other) {
        return new Vector(other.x + this.x, other.y + this.y);
    }

    public Vector getSubtracted(Vector other) {
        return new Vector(this.x - other.x, this.y - other.y);
    }

    public double getAngle(Vector other) {
        double cosAlpha = this.getDotProduct(other) / (this.getLength() * other.getLength());
        return Math.toDegrees(Math.acos(cosAlpha));
    }

    public Vector getAveraged(Vector vector) {
        return new Vector((this.x + vector.x) / 2.0, (this.y + vector.y) / 2.0);
    }

    public Vector getScaled(double scale) {
        return new Vector(this.x * scale, this.y * scale);
    }

    public Vector getOrthogonalComplement() {
        return new Vector(-this.y, this.x);
    }

    public double getLength() {
        return Math.sqrt(this.getDotProduct(this));
    }

    public double getSimilarity(Vector other) {
        return Math.abs(this.getDotProduct(other));
    }

    public boolean isOrthogonalTo(Vector other) {
        return this.getSimilarity(other) == 0.0;
    }

    public PrecisionPoint toPoint() {
        return new PrecisionPoint(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vector) {
            Vector r = (Vector)obj;
            return this.x == r.x && this.y == r.y;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.x * this.y) ^ (int)(this.x + this.y);
    }
}

