/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.examples.cloudio.application.actions;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.zest.cloudio.TagCloudViewer;
import org.eclipse.zest.examples.cloudio.application.Messages;
import org.eclipse.zest.examples.cloudio.application.actions.AbstractTagCloudAction;
import org.eclipse.zest.examples.cloudio.application.data.Type;
import org.eclipse.zest.examples.cloudio.application.data.TypeCollector;

public class LoadFileAction
extends AbstractTagCloudAction {
    public void run(IAction action) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.LoadFileAction_Text);
        String sourceFile = dialog.open();
        if (sourceFile == null) {
            return;
        }
        try (ProgressMonitorDialog pd = new ProgressMonitorDialog(this.getShell());){
            try {
                List<Type> types = TypeCollector.getData(new File(sourceFile), StandardCharsets.UTF_8);
                pd.setBlockOnOpen(false);
                pd.open();
                pd.getProgressMonitor().beginTask(Messages.LoadFileAction_BeginTask, 200);
                TagCloudViewer viewer = this.getViewer();
                viewer.setInput(types, pd.getProgressMonitor());
            }
            catch (IOException e) {
                e.printStackTrace();
                pd.close();
            }
        }
    }
}

