/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class BentCornerFigure
extends Figure {
    protected static int DEFAULT_CORNER_SIZE = 10;
    private int cornerSize;

    public BentCornerFigure() {
        this.setBackgroundColor(ColorConstants.tooltipBackground);
        this.setForegroundColor(ColorConstants.tooltipForeground);
        this.setCornerSize(DEFAULT_CORNER_SIZE);
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle rect = this.getBounds().getCopy();
        graphics.translate(this.getLocation());
        PointList outline = new PointList();
        outline.addPoint(0, 0);
        outline.addPoint(rect.width - this.cornerSize, 0);
        outline.addPoint(rect.width - 1, this.cornerSize);
        outline.addPoint(rect.width - 1, rect.height - 1);
        outline.addPoint(0, rect.height - 1);
        graphics.fillPolygon(outline);
        graphics.pushState();
        graphics.setLineWidth(2);
        graphics.drawRoundRectangle(new Rectangle(0, 0, rect.width - 1, rect.height - 1), 8, 8);
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillRectangle(rect.width - this.cornerSize - 1, 0, this.cornerSize + 2, this.cornerSize + 1);
        graphics.popState();
        graphics.drawLine(rect.width - this.cornerSize - 1, 0, rect.width - this.cornerSize - 1, this.cornerSize);
        graphics.drawLine(rect.width - this.cornerSize - 1, this.cornerSize, rect.width - 1, this.cornerSize);
        graphics.drawLine(rect.width - this.cornerSize - 1, 0, rect.width - 1, this.cornerSize);
        graphics.translate(this.getLocation().getNegated());
    }

    public void setCornerSize(int newSize) {
        this.cornerSize = newSize;
    }
}

