/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;

public class CircuitBorder
extends AbstractBorder {
    protected static Insets insets = new Insets(8, 6, 8, 6);
    protected static PointList connector = new PointList();
    protected static PointList bottomConnector = new PointList();

    static {
        connector.addPoint(-2, 0);
        connector.addPoint(1, 0);
        connector.addPoint(2, 1);
        connector.addPoint(2, 5);
        connector.addPoint(-1, 5);
        connector.addPoint(-1, 1);
        bottomConnector.addPoint(-2, -1);
        bottomConnector.addPoint(1, -1);
        bottomConnector.addPoint(2, -2);
        bottomConnector.addPoint(2, -6);
        bottomConnector.addPoint(-1, -6);
        bottomConnector.addPoint(-1, -2);
    }

    private static void drawConnectors(Graphics g, Rectangle rec) {
        g.setBackgroundColor(LogicColorConstants.connectorGreen);
        int i = 0;
        while (i < 4) {
            int x1 = rec.x + (2 * i + 1) * rec.width / 8;
            g.setForegroundColor(ColorConstants.listBackground);
            g.drawLine(x1 - 2, rec.y + 2, x1 + 3, rec.y + 2);
            g.setForegroundColor(LogicColorConstants.connectorGreen);
            connector.translate(x1, rec.y);
            g.fillPolygon(connector);
            g.drawPolygon(connector);
            connector.translate(-x1, -rec.y);
            g.setForegroundColor(ColorConstants.listBackground);
            g.drawLine(x1 - 2, rec.bottom() - 3, x1 + 3, rec.bottom() - 3);
            g.setForegroundColor(LogicColorConstants.connectorGreen);
            bottomConnector.translate(x1, rec.bottom());
            g.fillPolygon(bottomConnector);
            g.drawPolygon(bottomConnector);
            bottomConnector.translate(-x1, -rec.bottom());
            ++i;
        }
    }

    public Insets getInsets(IFigure figure) {
        return insets;
    }

    public void paint(IFigure figure, Graphics g, Insets in) {
        Rectangle r = figure.getBounds().getShrinked(in);
        g.setForegroundColor(LogicColorConstants.logicGreen);
        g.setBackgroundColor(LogicColorConstants.logicGreen);
        g.fillRectangle(r.x, r.y + 2, r.width, 6);
        g.fillRectangle(r.x, r.bottom() - 8, r.width, 6);
        g.fillRectangle(r.x, r.y + 2, 6, r.height - 4);
        g.fillRectangle(r.right() - 6, r.y + 2, 6, r.height - 4);
        g.setForegroundColor(LogicColorConstants.connectorGreen);
        g.drawLine(r.x, r.y + 2, r.right() - 1, r.y + 2);
        g.drawLine(r.x, r.bottom() - 3, r.right() - 1, r.bottom() - 3);
        g.drawLine(r.x, r.y + 2, r.x, r.bottom() - 3);
        g.drawLine(r.right() - 1, r.bottom() - 3, r.right() - 1, r.y + 2);
        r.shrink(new Insets(1, 1, 0, 0));
        r.expand(1, 1);
        r.shrink(this.getInsets(figure));
        CircuitBorder.drawConnectors(g, figure.getBounds().getShrinked(in));
    }
}

